/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.anycast;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.RemoteMessageRequest;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.List;

public class AIStreamIterator
implements SIMPIterator {
    private static TraceComponent tc = SibTr.register(AIStreamIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AIStream aiStream;
    private Iterator msgIterator;
    private int size;

    public AIStreamIterator(AIStream aiStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIStreamIterator", (Object)new Object[]{aiStream});
        }
        this.aiStream = aiStream;
        List<Long> ticks = aiStream.getTicksOnStream();
        this.size = ticks.size();
        this.msgIterator = ticks.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIStreamIterator", (Object)this);
        }
    }

    public void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.msgIterator = null;
        this.aiStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    public boolean hasNext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNext");
            SibTr.exit((TraceComponent)tc, (String)"hasNext");
        }
        return this.msgIterator.hasNext();
    }

    public Object next() {
        RemoteMessageRequest remoteMessageRequest;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        if (this.msgIterator.hasNext()) {
            Long ticks = (Long)this.msgIterator.next();
            remoteMessageRequest = new RemoteMessageRequest(ticks, this.aiStream);
        } else {
            remoteMessageRequest = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", remoteMessageRequest);
        }
        return remoteMessageRequest;
    }

    public void remove() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        if (this.msgIterator.hasNext()) {
            this.msgIterator.remove();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public int getSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSize");
            SibTr.exit((TraceComponent)tc, (String)"getSize", (Object)this.size);
        }
        return this.size;
    }
}

