/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MonitoredConsumer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SubscriptionRegistrar {
    private static final TraceComponent tc = SibTr.register(SubscriptionRegistrar.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Map _exactNonSelectorSubs = new HashMap();
    private Map _wildcardNonSelectorSubs = new HashMap();
    private Map _exactSelectorSubs = new HashMap();
    private Map _wildcardSelectorSubs = new HashMap();
    private boolean _areExactNonSelectorSubs = false;
    private boolean _areWildcardNonSelectorSubs = false;
    private boolean _areExactSelectorSubs = false;
    private boolean _areWildcardSelectorSubs = false;
    private MessageProcessorMatching _mpm;

    public SubscriptionRegistrar(MessageProcessorMatching mpm) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SubscriptionRegistrar", (Object)mpm);
        }
        this._mpm = mpm;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SubscriptionRegistrar", (Object)this);
        }
    }

    public boolean isKnownNonSelectorExpression(String topicExpression, boolean isWildcarded) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKnownNonSelectorExpression", (Object)new Object[]{topicExpression, new Boolean(isWildcarded)});
        }
        boolean isCategorised = false;
        isCategorised = isWildcarded ? this._wildcardNonSelectorSubs.containsKey(topicExpression) : this._exactNonSelectorSubs.containsKey(topicExpression);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isKnownNonSelectorExpression", (Object)new Boolean(isCategorised));
        }
        return isCategorised;
    }

    public boolean isKnownSelectorExpression(String topicExpression, boolean isWildcarded) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKnownSelectorExpression", (Object)new Object[]{topicExpression, new Boolean(isWildcarded)});
        }
        boolean isCategorised = false;
        isCategorised = isWildcarded ? this._wildcardSelectorSubs.containsKey(topicExpression) : this._exactSelectorSubs.containsKey(topicExpression);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isKnownSelectorExpression", (Object)new Boolean(isCategorised));
        }
        return isCategorised;
    }

    public void addNewConsumerForExpression(String topicExpression, MonitoredConsumer mc, boolean selector, boolean isWildcarded) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewConsumerForExpression", (Object)new Object[]{topicExpression, mc, new Boolean(selector), new Boolean(isWildcarded)});
        }
        ArrayList<MonitoredConsumer> consumerList = new ArrayList<MonitoredConsumer>(1);
        consumerList.add(mc);
        if (selector) {
            if (isWildcarded) {
                this._wildcardSelectorSubs.put(topicExpression, consumerList);
                this._areWildcardSelectorSubs = true;
            } else {
                this._exactSelectorSubs.put(topicExpression, consumerList);
                this._areExactSelectorSubs = true;
            }
        } else if (isWildcarded) {
            this._wildcardNonSelectorSubs.put(topicExpression, consumerList);
            this._areWildcardNonSelectorSubs = true;
        } else {
            this._exactNonSelectorSubs.put(topicExpression, consumerList);
            this._areExactNonSelectorSubs = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewConsumerForExpression");
        }
    }

    public void removeConsumerListForExpression(String topicExpression, boolean selector, boolean isWildcarded) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerListForExpression", (Object)new Object[]{topicExpression, new Boolean(selector), new Boolean(isWildcarded)});
        }
        if (selector) {
            if (isWildcarded) {
                ArrayList consumerList = (ArrayList)this._wildcardSelectorSubs.remove(topicExpression);
                if (consumerList == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"removeConsumerListForExpression", (Object)topicExpression);
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:265:1.5", topicExpression});
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:272:1.5", topicExpression}, null));
                }
                if (this._wildcardSelectorSubs.isEmpty()) {
                    this._areWildcardSelectorSubs = false;
                }
            } else {
                ArrayList consumerList = (ArrayList)this._exactSelectorSubs.remove(topicExpression);
                if (consumerList == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"removeConsumerListForExpression", (Object)topicExpression);
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:296:1.5", topicExpression});
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:303:1.5", topicExpression}, null));
                }
                if (this._exactSelectorSubs.isEmpty()) {
                    this._areExactSelectorSubs = false;
                }
            }
        } else if (isWildcarded) {
            ArrayList consumerList = (ArrayList)this._wildcardNonSelectorSubs.remove(topicExpression);
            if (consumerList == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeConsumerListForExpression", (Object)topicExpression);
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:331:1.5", topicExpression});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:338:1.5", topicExpression}, null));
            }
            if (this._wildcardNonSelectorSubs.isEmpty()) {
                this._areWildcardNonSelectorSubs = false;
            }
        } else {
            ArrayList consumerList = (ArrayList)this._exactNonSelectorSubs.remove(topicExpression);
            if (consumerList == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeConsumerListForExpression", (Object)topicExpression);
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:362:1.5", topicExpression});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.SubscriptionRegistrar", "1:369:1.5", topicExpression}, null));
            }
            if (this._exactNonSelectorSubs.isEmpty()) {
                this._areExactNonSelectorSubs = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerListForExpression");
        }
    }

    public ArrayList getConsumerListForExpression(String topicExpression, boolean selector, boolean isWildcarded) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerListForExpression", (Object)new Object[]{topicExpression, new Boolean(selector), new Boolean(isWildcarded)});
        }
        ArrayList consumerList = null;
        consumerList = selector ? (isWildcarded ? (ArrayList)this._wildcardSelectorSubs.get(topicExpression) : (ArrayList)this._exactSelectorSubs.get(topicExpression)) : (isWildcarded ? (ArrayList)this._wildcardNonSelectorSubs.get(topicExpression) : (ArrayList)this._exactNonSelectorSubs.get(topicExpression));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerListForExpression", (Object)consumerList);
        }
        return consumerList;
    }

    public void findMatchingSelectorSubs(String theTopic, Set consumerSet) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findMatchingSelectorSubs", (Object)new Object[]{theTopic});
        }
        this.findMatchingExactSelectorSubs(theTopic, consumerSet);
        if (this._areWildcardSelectorSubs) {
            for (String consumerTopic : this._wildcardSelectorSubs.keySet()) {
                String stem = this._mpm.retrieveNonWildcardStem(consumerTopic);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found consumer topic: " + consumerTopic + "with stem: " + stem));
                }
                if (!theTopic.startsWith(stem)) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Drive direct evaluation for topic: " + consumerTopic));
                }
                if (!this._mpm.evaluateDiscriminator(theTopic, consumerTopic)) continue;
                ArrayList consumerList = (ArrayList)this._wildcardSelectorSubs.get(consumerTopic);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Add members of list to set");
                }
                consumerSet.addAll(consumerList);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findMatchingSelectorSubs");
        }
    }

    private void findMatchingExactSelectorSubs(String topic, Set consumerSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findMatchingExactSelectorSubs", (Object)new Object[]{topic});
        }
        if (this._areExactSelectorSubs) {
            for (String consumerTopic : this._exactSelectorSubs.keySet()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found consumer topic: " + consumerTopic));
                }
                if (!topic.equals(consumerTopic)) continue;
                ArrayList consumerList = (ArrayList)this._exactSelectorSubs.get(topic);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Add members of list to set");
                }
                consumerSet.addAll(consumerList);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findMatchingExactSelectorSubs");
        }
    }

    public void findCandidateSubsForWildcardExpr(String topicExpression, String topicStem, Set consumerSet) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findCandidateSubsForWildcardExpr", (Object)new Object[]{topicExpression, topicStem});
        }
        if (this._areExactNonSelectorSubs) {
            this.evaluateCandidateExpression(topicExpression, this._exactNonSelectorSubs, topicStem, consumerSet);
        }
        if (this._areExactSelectorSubs) {
            this.evaluateCandidateExpression(topicExpression, this._exactSelectorSubs, topicStem, consumerSet);
        }
        if (this._areWildcardNonSelectorSubs) {
            this.isolateCandidateWildcardSubs(topicExpression, topicStem, this._wildcardNonSelectorSubs, consumerSet);
        }
        if (this._areWildcardSelectorSubs) {
            this.isolateCandidateWildcardSubs(topicExpression, topicStem, this._wildcardSelectorSubs, consumerSet);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findCandidateSubsForWildcardExpr");
        }
    }

    private void evaluateCandidateExpression(String topicExpression, Map subscriptions, String topicStem, Set consumerSet) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"evaluateCandidateExpression", (Object)new Object[]{topicExpression, topicStem});
        }
        for (String consumerTopic : subscriptions.keySet()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found consumer topic: " + consumerTopic));
            }
            if (!consumerTopic.startsWith(topicStem)) continue;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Drive direct evaluation for topic: " + consumerTopic));
            }
            if (!this._mpm.evaluateDiscriminator(consumerTopic, topicExpression)) continue;
            ArrayList consumerList = (ArrayList)subscriptions.get(consumerTopic);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Add members of list to set");
            }
            consumerSet.addAll(consumerList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"evaluateCandidateExpression");
        }
    }

    private void isolateCandidateWildcardSubs(String topicExpression, String topicStem, Map subscriptions, Set consumerSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isolateCandidateWildcardSubs", (Object)new Object[]{topicExpression, topicStem});
        }
        for (String consumerTopic : subscriptions.keySet()) {
            ArrayList consumerList;
            String consumerStem;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found consumer topic: " + consumerTopic));
            }
            if ((consumerStem = this._mpm.retrieveNonWildcardStem(consumerTopic)).length() >= topicStem.length()) {
                if (!consumerStem.startsWith(topicStem)) continue;
                consumerList = (ArrayList)subscriptions.get(consumerTopic);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Topic expressions might overlap, add members of list to set");
                }
                consumerSet.addAll(consumerList);
                continue;
            }
            if (!topicStem.startsWith(consumerStem)) continue;
            consumerList = (ArrayList)subscriptions.get(consumerTopic);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Topic expressions might overlap, add members of list to set");
            }
            consumerSet.addAll(consumerList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isolateCandidateWildcardSubs");
        }
    }

    public int getExactNonSelectorSubsSize(String topicExpression) {
        ArrayList consumerList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExactNonSelectorSubsSize", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._exactNonSelectorSubs.isEmpty() && this._exactNonSelectorSubs.containsKey(topicExpression) && (consumerList = (ArrayList)this._exactNonSelectorSubs.get(topicExpression)) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExactNonSelectorSubsSize", (Object)new Integer(numSubs));
        }
        return numSubs;
    }

    public int getWildcardNonSelectorSubs(String topicExpression) {
        ArrayList consumerList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWildcardNonSelectorSubs", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._wildcardNonSelectorSubs.isEmpty() && this._wildcardNonSelectorSubs.containsKey(topicExpression) && (consumerList = (ArrayList)this._wildcardNonSelectorSubs.get(topicExpression)) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWildcardNonSelectorSubs", (Object)new Integer(numSubs));
        }
        return numSubs;
    }

    public int getExactSelectorSubsSize(String topicExpression) {
        ArrayList consumerList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExactSelectorSubsSize", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._exactSelectorSubs.isEmpty() && this._exactSelectorSubs.containsKey(topicExpression) && (consumerList = (ArrayList)this._exactSelectorSubs.get(topicExpression)) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExactSelectorSubsSize", (Object)new Integer(numSubs));
        }
        return numSubs;
    }

    public int getWildcardSelectorSubs(String topicExpression) {
        ArrayList consumerList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWildcardSelectorSubs", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._wildcardSelectorSubs.isEmpty() && this._wildcardSelectorSubs.containsKey(topicExpression) && (consumerList = (ArrayList)this._wildcardSelectorSubs.get(topicExpression)) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWildcardSelectorSubs", (Object)new Integer(numSubs));
        }
        return numSubs;
    }
}

