/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.filters;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public final class MessageSelectorFilter
implements Filter {
    private static final TraceComponent tc = SibTr.register(MessageSelectorFilter.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private String _selectorString;
    private SelectorDomain _domain;
    private String _discriminator;
    private Selector _selectorTree;
    private Selector _discriminatorTree;

    public MessageSelectorFilter(MessageProcessor messageProcessor, SelectionCriteria criteria) throws SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageSelectorFilter", (Object)new Object[]{messageProcessor, criteria});
        }
        this._messageProcessor = messageProcessor;
        this._selectorString = criteria.getSelectorString();
        this._domain = criteria.getSelectorDomain();
        this._discriminator = criteria.getDiscriminator();
        if (this._selectorString != null) {
            this._selectorTree = messageProcessor.getMessageProcessorMatching().parseSelector(this._selectorString, this._domain);
        }
        try {
            if (this._discriminator != null) {
                this._discriminatorTree = messageProcessor.getMessageProcessorMatching().parseDiscriminator(this._discriminator);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter.MessageSelectorFilter", (String)"1:133:1.36", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageSelectorFilter", (Object)this);
        }
    }

    public boolean filterMatches(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        boolean result = true;
        if (this._selectorTree != null || this._discriminatorTree != null) {
            SIMPMessage msg = (SIMPMessage)item;
            JsMessage jsMsg = msg.getMessageIfAvailable();
            if (msg == null) {
                result = false;
            } else {
                int redelCount = msg.guessRedeliveredCount();
                if (redelCount > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Set deliverycount into message: " + redelCount));
                    }
                    jsMsg.setDeliveryCount(redelCount);
                }
                result = this._messageProcessor.getMessageProcessorMatching().evaluateMessage(this._selectorTree, this._discriminatorTree, (SIBusMessage)jsMsg);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)new Boolean(result));
        }
        return result;
    }

    public String getSelectorString() {
        return this._selectorString;
    }

    public String getDiscriminator() {
        return this._discriminator;
    }

    public SelectorDomain getDomain() {
        return this._domain;
    }
}

