/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DurableInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPReceiveMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RemotePubSubSupport
extends AbstractRemoteSupport {
    private static final TraceComponent tc = SibTr.register(RemotePubSubSupport.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Map _pseudoDurableMap = null;
    private Map<String, AnycastOutputHandler> _pseudoDurableAOHMap = null;
    private Map<String, AnycastInputHandler> _pseudoDurableAIHMap = null;

    public RemotePubSubSupport(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor) {
        super(myBaseDestinationHandler, messageProcessor);
    }

    public void initialisePseudoMaps() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialisePseudoMaps");
        }
        this._pseudoDurableMap = Collections.synchronizedMap(new HashMap());
        this._pseudoDurableAOHMap = Collections.synchronizedMap(new HashMap());
        this._pseudoDurableAIHMap = Collections.synchronizedMap(new HashMap());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialisePseudoMaps");
        }
    }

    @Override
    public int reconstituteLocalQueuePoint(int startMode) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeConsumers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeConsumers");
        }
        Map<String, AnycastInputHandler> map = this._pseudoDurableAIHMap;
        synchronized (map) {
            Iterator<String> i = this._pseudoDurableAIHMap.keySet().iterator();
            while (i.hasNext()) {
                AnycastInputHandler next = this._pseudoDurableAIHMap.get(i.next());
                RemoteConsumerDispatcher rcd = next.getRCD();
                rcd.closeAllConsumersForDelete(this._baseDestinationHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReceiveAllowedRCD(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowedRCD", (Object)new Object[]{destinationHandler});
        }
        Map<String, AnycastInputHandler> map = this._pseudoDurableAIHMap;
        synchronized (map) {
            for (String subName : this._pseudoDurableAIHMap.keySet()) {
                AnycastInputHandler aih = this._pseudoDurableAIHMap.get(subName);
                if (aih == null) continue;
                RemoteConsumerDispatcher rcd = aih.getRCD();
                rcd.notifyReceiveAllowed(destinationHandler);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowedRCD");
        }
    }

    @Override
    public Object[] getPostReconstitutePseudoIds() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPostReconstitutePseudoIds");
        }
        Object[] result = null;
        if (this._pseudoDurableMap != null) {
            result = this._pseudoDurableMap.keySet().toArray();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPostReconstitutePseudoIds", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteRemoteDurable(int startMode, HashMap consumerDispatchersDurable) throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteRemoteDurable", (Object)new Object[]{startMode});
        }
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(AOContainerItemStream.class));
        AOContainerItemStream aoTempItemStream = null;
        aoTempItemStream = (AOContainerItemStream)cursor.next();
        while (aoTempItemStream != null) {
            if (aoTempItemStream.getDurablePseudoDestID() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstituteRemoteDurable", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport", "1:319:1.27", null}, null));
            }
            String subName = aoTempItemStream.getDurableSubName();
            SIBUuid12 pseudoID = aoTempItemStream.getDurablePseudoDestID();
            String destName = this._baseDestinationHandler.constructPseudoDurableDestName(subName);
            HashMap hashMap = consumerDispatchersDurable;
            synchronized (hashMap) {
                block37: {
                    ConsumerDispatcher cd = (ConsumerDispatcher)consumerDispatchersDurable.get(subName);
                    if (cd != null) {
                        DestinationDefinition pseudoDest = null;
                        AnycastOutputHandler pseudoHandler = null;
                        try {
                            pseudoDest = this._messageProcessor.createDestinationDefinition(DestinationType.TOPICSPACE, destName);
                            pseudoDest.setReceiveExclusive(!cd.getConsumerDispatcherState().isCloned());
                            pseudoDest.setUUID(pseudoID);
                            AOContainerItemStream aostream = aoTempItemStream;
                            boolean restartFromStaleBackup = false;
                            if ((startMode & 1) == 1 && (startMode & 2) == 0) {
                                restartFromStaleBackup = true;
                            }
                            pseudoHandler = new AnycastOutputHandler(pseudoDest.getName(), pseudoDest.getUUID(), pseudoDest.isReceiveExclusive(), null, cd, aostream, this._messageProcessor, this._destinationManager.getAsyncUpdateThread(), this._destinationManager.getPersistLockThread(), System.currentTimeMillis(), restartFromStaleBackup);
                            Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
                            synchronized (map) {
                                this._pseudoDurableAOHMap.put(destName, pseudoHandler);
                                this._pseudoDurableMap.put(pseudoDest.getUUID(), pseudoHandler);
                                break block37;
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.reconstituteRemoteDurable", (String)"1:421:1.27", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)e);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.reconstituteRemoteDurable", "1:429:1.27", e});
                            if (pseudoDest != null) {
                                Map<String, AnycastOutputHandler> restartFromStaleBackup = this._pseudoDurableAOHMap;
                                synchronized (restartFromStaleBackup) {
                                    this._pseudoDurableAOHMap.remove(destName);
                                    this._pseudoDurableMap.remove(pseudoDest.getUUID());
                                }
                            }
                            if (pseudoHandler != null) {
                                pseudoHandler.close();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"reconstituteRemoteDurable", (Object)"SIErrorException");
                            }
                            SIErrorException x = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.reconstituteRemoteDurable", "1:460:1.27", e}, null));
                            throw x;
                        }
                    }
                    LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                    aoTempItemStream.removeAll((Transaction)siTran);
                    siTran.commit();
                }
            }
            aoTempItemStream = (AOContainerItemStream)cursor.next();
        }
        cursor.finished();
        cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(AIContainerItemStream.class));
        AIContainerItemStream aiTempItemStream = null;
        aiTempItemStream = (AIContainerItemStream)cursor.next();
        while (aiTempItemStream != null) {
            if (aiTempItemStream.getDurablePseudoDestID() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstituteRemoteDurable", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport", "1:510:1.27", this._baseDestinationHandler.getName()}, null));
            }
            NonLockingCursor aiStreamCursor = aiTempItemStream.newNonLockingItemStreamCursor(null);
            boolean aiStreamExists = true;
            if (aiStreamCursor.next() == null) {
                aiStreamExists = false;
            }
            aiStreamCursor.finished();
            if (aiStreamExists) {
                String subName = aiTempItemStream.getDurableSubName();
                this._aiContainerItemStreams.put(subName, aiTempItemStream);
                NonLockingCursor rcdCursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(PtoPReceiveMsgsItemStream.class));
                PtoPReceiveMsgsItemStream rcdTempItemStream = (PtoPReceiveMsgsItemStream)rcdCursor.next();
                while (rcdTempItemStream != null) {
                    if (rcdTempItemStream.getDurableSubName().equals(subName)) {
                        HashMap hashMap = consumerDispatchersDurable;
                        synchronized (hashMap) {
                            rcdTempItemStream.reconstitute(this._baseDestinationHandler);
                            rcdTempItemStream.reallocateMsgs();
                            this._rcdItemStreams.put(subName, rcdTempItemStream);
                            SIBUuid12 pseudoDestID = aiTempItemStream.getDurablePseudoDestID();
                            DestinationDefinition pseudoDest = this._messageProcessor.createDestinationDefinition(DestinationType.TOPICSPACE, subName);
                            pseudoDest.setUUID(pseudoDestID);
                            pseudoDest.setReceiveExclusive(true);
                            boolean restartFromStaleBackup = false;
                            AnycastInputHandler aih = new AnycastInputHandler(pseudoDest.getName(), pseudoDest.getUUID(), pseudoDest.isReceiveExclusive(), this._messageProcessor, aiTempItemStream, aiTempItemStream.getDmeId(), null, this._destinationManager.getAsyncUpdateThread(), this._baseDestinationHandler, restartFromStaleBackup, true);
                            this._pseudoDurableAIHMap.put(subName, aih);
                            this._pseudoDurableMap.put(pseudoDestID, aih);
                            String strippedSubName = this._baseDestinationHandler.getSubNameFromPseudoDestination(subName);
                            ConsumerDispatcherState subState = new ConsumerDispatcherState(strippedSubName, this._baseDestinationHandler.getUuid(), JsMainAdminComponentImpl.getSelectionCriteriaFactory().createSelectionCriteria(), false, aiTempItemStream.getDurableSubHome(), this._baseDestinationHandler.getName(), this._baseDestinationHandler.getBus());
                            SIBUuid8 durableHomeID = aiTempItemStream.getDmeId();
                            subState.setRemoteMEUuid(durableHomeID);
                            RemoteConsumerDispatcher rcd = new RemoteConsumerDispatcher(this._baseDestinationHandler, pseudoDest.getName(), rcdTempItemStream, subState, aih, this._baseDestinationHandler.getTransactionManager(), true);
                            rcd.setPendingDelete(true);
                            aih.addFlushedCallback(new CleanupDurableRME(rcd));
                            consumerDispatchersDurable.put(subName, rcd);
                            break;
                        }
                    }
                    rcdTempItemStream = (PtoPReceiveMsgsItemStream)rcdCursor.next();
                }
                rcdCursor.finished();
                if (rcdTempItemStream == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"reconstituteRemoteDurable", (Object)"SIResourceException");
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.reconstituteRemoteDurable", "1:673:1.27", null}, null));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Removing empty AIContainerItemStream for " + aiTempItemStream.getDurableSubName()));
                }
                SIMPTransactionManager txMan = this._messageProcessor.getTXManager();
                LocalTransaction mpTxn = txMan.createLocalTransaction(false);
                try {
                    Transaction msTxn = txMan.resolveAndEnlistMsgStoreTransaction((TransactionCommon)mpTxn);
                    aiTempItemStream.remove(msTxn, -2L);
                    mpTxn.commit();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.reconstituteRemoteDurable", (String)"1:698:1.27", (Object)this);
                }
            }
            aiTempItemStream = (AIContainerItemStream)cursor.next();
        }
        cursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteRemoteDurable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRemoteDurableRME(String subName, AnycastInputHandler aih, TransactionCommon siTran) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableRME", (Object)new Object[]{subName, aih});
        }
        boolean deleting = false;
        SIBUuid12 pseudoDestID = aih.getDestUuid();
        SIMPItemStream aihStream = (SIMPItemStream)((Object)this._aiContainerItemStreams.get(subName));
        PtoPMessageItemStream rcdStream = (PtoPMessageItemStream)this._rcdItemStreams.get(subName);
        RemoteConsumerDispatcher rcd = aih.getRCD();
        if (!rcd.hasConsumersAttached()) {
            Map<String, AnycastInputHandler> map = this._pseudoDurableAIHMap;
            synchronized (map) {
                if (this._pseudoDurableAIHMap.containsKey(subName)) {
                    deleting = true;
                    aih.delete();
                    Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(siTran);
                    aihStream.removeAll(msTran);
                    this._aiContainerItemStreams.remove(subName);
                    rcdStream.removeAll(msTran);
                    this._rcdItemStreams.remove(subName);
                    this._pseudoDurableAIHMap.remove(subName);
                    this._pseudoDurableMap.remove(pseudoDestID);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableRME", (Object)deleting);
        }
        return deleting;
    }

    public void deleteRemoteDurableDME(String subName) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        String destName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableDME", (Object)new Object[]{subName});
        }
        if (!this._pseudoDurableAOHMap.containsKey(destName = this._baseDestinationHandler.constructPseudoDurableDestName(subName))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableDME", (Object)"No remote Access");
            }
            return;
        }
        try {
            AnycastOutputHandler aoh = this._pseudoDurableAOHMap.get(destName);
            SIBUuid12 pseudoDestID = aoh.getDestUUID();
            SIMPItemStream aohStream = aoh.getItemStream();
            boolean aohCleanedup = aoh.cleanup(true, false);
            if (aohCleanedup) {
                LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                aohStream.removeAll((Transaction)siTran);
                siTran.commit();
            }
            this._pseudoDurableAOHMap.remove(destName);
            this._pseudoDurableMap.remove(pseudoDestID);
            this._destinationManager.removePseudoDestination(pseudoDestID);
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableDME", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.deleteRemoteDurableDME", (String)"1:881:1.27", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableDME", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableDME");
        }
    }

    public AnycastInputHandler getAIHByName(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIHByName", (Object)name);
        }
        AnycastInputHandler result = this._pseudoDurableAIHMap.get(name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAIHByName", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cleanupLocalisations(HashMap consumerDispatchersDurable) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLocalisations");
        }
        boolean allCleanedUp = true;
        try {
            Iterator r;
            SIBUuid12 pseudoDest;
            ArrayList<String> doneSet;
            LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
            Map<String, ControlHandler> map = this._pseudoDurableAOHMap;
            synchronized (map) {
                doneSet = new ArrayList<String>();
                for (String subName : this._pseudoDurableAOHMap.keySet()) {
                    AnycastOutputHandler aoh = this._pseudoDurableAOHMap.get(subName);
                    pseudoDest = aoh.getDestUUID();
                    SIMPItemStream aohStream = aoh.getItemStream();
                    boolean aohCleanedup = aoh.cleanup(true, false);
                    if (aohCleanedup) {
                        aohStream.removeAll((Transaction)siTran);
                        this._pseudoDurableMap.remove(pseudoDest);
                        this._baseDestinationHandler.getDestinationManager().removePseudoDestination(pseudoDest);
                        doneSet.add(subName);
                    }
                    allCleanedUp &= aohCleanedup;
                }
                r = doneSet.iterator();
                while (r.hasNext()) {
                    this._pseudoDurableAOHMap.remove(r.next());
                }
            }
            map = this._pseudoDurableAIHMap;
            synchronized (map) {
                doneSet = new ArrayList();
                for (String subName : this._pseudoDurableAIHMap.keySet()) {
                    AnycastInputHandler aih = this._pseudoDurableAIHMap.get(subName);
                    pseudoDest = aih.getDestUuid();
                    SIMPItemStream aihStream = (SIMPItemStream)((Object)this._aiContainerItemStreams.get(subName));
                    PtoPMessageItemStream rcdStream = (PtoPMessageItemStream)this._rcdItemStreams.get(subName);
                    boolean aihCleanedUp = true;
                    if (!aih.destinationDeleted()) {
                        aihCleanedUp = false;
                    } else {
                        aih.delete();
                        aihStream.removeAll((Transaction)siTran);
                        this._aiContainerItemStreams.remove(subName);
                        rcdStream.removeAll((Transaction)siTran);
                        this._rcdItemStreams.remove(subName);
                        this._pseudoDurableMap.remove(pseudoDest);
                        this._baseDestinationHandler.getDestinationManager().removePseudoDestination(pseudoDest);
                        HashMap hashMap = consumerDispatchersDurable;
                        synchronized (hashMap) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"cleanupLocalisations", (Object)("Remove subscription " + subName + " from durable CDs table"));
                            }
                            consumerDispatchersDurable.remove(subName);
                        }
                        doneSet.add(subName);
                    }
                    allCleanedUp &= aihCleanedUp;
                }
                r = doneSet.iterator();
                while (r.hasNext()) {
                    this._pseudoDurableAIHMap.remove(r.next());
                }
            }
            siTran.commit();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.cleanupLocalisations", (String)"1:1017:1.27", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)allCleanedUp);
        }
        return allCleanedUp;
    }

    public Map getPseudoDurableAIHMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPseudoDurableAIHMap");
            SibTr.exit((TraceComponent)tc, (String)"getPseudoDurableAIHMap", this._pseudoDurableAIHMap);
        }
        return this._pseudoDurableAIHMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastOutputHandler locateExistingAOH(ControlCreateStream request, SIBUuid8 sender, String destName, ConsumerDispatcherState subState) throws SIDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"locateExistingAOH", (Object)new Object[]{request, sender, destName, subState});
        }
        AnycastOutputHandler handler = null;
        Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
        synchronized (map) {
            handler = this._pseudoDurableAOHMap.get(destName);
            if (handler != null) {
                ConsumerDispatcher cd = handler.getPubSubConsumerDispatcher();
                if (!cd.getConsumerDispatcherState().equals(subState)) {
                    SIDurableSubscriptionMismatchException e = new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"locateExistingAOH", (Object)subState);
                    }
                    throw e;
                }
                if (this._messageProcessor.isBusSecure() && !cd.getConsumerDispatcherState().equalUser(subState)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"locateExistingAOH", (Object)subState);
                    }
                    throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("USER_NOT_AUTH_ACTIVATE_ERROR_CWSIP0312", new Object[]{subState.getUser(), subState.getSubscriberID(), this._baseDestinationHandler.getName()}, null));
                }
                handler.handleControlMessage(sender, (ControlMessage)request);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"locateExistingAOH", (Object)handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePseudoDestination(AnycastOutputHandler pseudoHandler, String destName, DestinationDefinition pseudoDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storePseudoDestination", (Object)new Object[]{pseudoHandler, destName, pseudoDest});
        }
        Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
        synchronized (map) {
            this._pseudoDurableAOHMap.put(destName, pseudoHandler);
            this._pseudoDurableMap.put(pseudoDest.getUUID(), pseudoHandler);
            this._destinationManager.addPseudoDestination(pseudoDest.getUUID(), this._baseDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"storePseudoDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupPseudoDestination(String destName, DestinationDefinition pseudoDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupPseudoDestination", (Object)new Object[]{destName, pseudoDest});
        }
        Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
        synchronized (map) {
            this._pseudoDurableAOHMap.remove(destName);
            this._pseudoDurableMap.remove(pseudoDest.getUUID());
            this._destinationManager.removePseudoDestination(pseudoDest.getUUID());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupPseudoDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastOutputHandler getAnycastOHForPseudoDest(String destName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastOHForPseudoDest", (Object)destName);
        }
        AnycastOutputHandler returnAOH = null;
        if (this._pseudoDurableAOHMap != null) {
            Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
            synchronized (map) {
                returnAOH = this._pseudoDurableAOHMap.get(destName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastOHForPseudoDest", returnAOH);
        }
        return returnAOH;
    }

    public RemoteConsumerDispatcher createRemoteConsumerDispatcher(String remSubName, ConsumerDispatcherState subState, SIBUuid8 durableMEUuid) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteConsumerDispatcher", (Object)new Object[]{remSubName, subState, durableMEUuid});
        }
        RemoteConsumerDispatcher rcd = null;
        ControlNotFlushed notFlushed = DurableInputHandler.issueCreateStreamRequest(this._messageProcessor, subState, this._baseDestinationHandler.getDefinition().getUUID(), durableMEUuid);
        SIBUuid12 newDestID = notFlushed.getGuaranteedTargetDestinationDefinitionUUID();
        DestinationDefinition pseudoDest = this._messageProcessor.createDestinationDefinition(DestinationType.TOPICSPACE, remSubName);
        pseudoDest.setUUID(newDestID);
        pseudoDest.setReceiveExclusive(!subState.isCloned());
        LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
        AIContainerItemStream aiContainerItemStream = new AIContainerItemStream(durableMEUuid, null, newDestID, remSubName, subState.getDurableHome());
        this._baseDestinationHandler.addItemStream(aiContainerItemStream, (Transaction)siTran);
        this._aiContainerItemStreams.put(remSubName, aiContainerItemStream);
        PtoPReceiveMsgsItemStream rcdItemStream = new PtoPReceiveMsgsItemStream(this._baseDestinationHandler, durableMEUuid, remSubName);
        this._baseDestinationHandler.addItemStream(rcdItemStream, (Transaction)siTran);
        this._rcdItemStreams.put(remSubName, rcdItemStream);
        siTran.commit();
        boolean restartFromStaleBackup = false;
        AnycastInputHandler aih = new AnycastInputHandler(pseudoDest.getName(), pseudoDest.getUUID(), pseudoDest.isReceiveExclusive(), this._messageProcessor, aiContainerItemStream, durableMEUuid, null, this._destinationManager.getAsyncUpdateThread(), this._baseDestinationHandler, restartFromStaleBackup, true);
        this._pseudoDurableAIHMap.put(remSubName, aih);
        this._pseudoDurableMap.put(newDestID, aih);
        rcd = new RemoteConsumerDispatcher(this._baseDestinationHandler, pseudoDest.getName(), rcdItemStream, subState, aih, this._baseDestinationHandler.getTransactionManager(), !subState.isCloned());
        rcd.setReadyForUse();
        aih.prepareForDurableStartup(notFlushed.getRequestID());
        this._destinationManager.addPseudoDestination(newDestID, this._baseDestinationHandler);
        aih.handleControlMessage(durableMEUuid, (ControlMessage)notFlushed);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteConsumerDispatcher", (Object)rcd);
        }
        return rcd;
    }

    @Override
    public AnycastInputHandler getAnycastInputHandlerByPseudoDestId(SIBUuid12 destID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandlerByPseudoDestId", (Object)new Object[]{destID});
        }
        AnycastInputHandler aih = null;
        if (this._pseudoDurableMap != null) {
            aih = (AnycastInputHandler)this._pseudoDurableMap.get(destID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandlerByPseudoDestId", (Object)aih);
        }
        return aih;
    }

    @Override
    public AnycastOutputHandler getAnycastOutputHandlerByPseudoDestId(SIBUuid12 destID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastOutputHandlerByPseudoDestId", (Object)new Object[]{destID});
        }
        AnycastOutputHandler aoh = null;
        if (this._pseudoDurableMap != null) {
            aoh = (AnycastOutputHandler)this._pseudoDurableMap.get(destID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastOutputHandlerByPseudoDestId", (Object)aoh);
        }
        return aoh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AnycastInputControl> getAIControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIControlAdapterIterator");
        }
        ArrayList<AnycastInputControl> controlAdapters = new ArrayList<AnycastInputControl>();
        Map<String, AnycastInputHandler> map = this._pseudoDurableAIHMap;
        synchronized (map) {
            Iterator<AnycastInputHandler> it = this._pseudoDurableAIHMap.values().iterator();
            while (it.hasNext()) {
                controlAdapters.add(new AnycastInputControl(it.next()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAIControlAdapterIterator", controlAdapters);
        }
        return controlAdapters.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ControlAdapter> getAOControlAdapterIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOControlAdapterIterator");
        }
        ArrayList<ControlAdapter> controlAdapters = new ArrayList<ControlAdapter>();
        Map<String, AnycastOutputHandler> map = this._pseudoDurableAOHMap;
        synchronized (map) {
            Iterator<AnycastOutputHandler> it = this._pseudoDurableAOHMap.values().iterator();
            while (it.hasNext()) {
                Iterator<ControlAdapter> aoStreams = it.next().getAOControlAdapterIterator();
                while (aoStreams.hasNext()) {
                    controlAdapters.add(aoStreams.next());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOControlAdapterIterator", controlAdapters);
        }
        return controlAdapters.iterator();
    }

    class CleanupDurableRME
    implements Runnable {
        RemoteConsumerDispatcher _rcd;

        public CleanupDurableRME(RemoteConsumerDispatcher rcd) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CleanupDurableRME", (Object)rcd);
            }
            this._rcd = rcd;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CleanupDurableRME", (Object)this);
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run");
            }
            try {
                this._rcd.deleteConsumerDispatcher(false);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.CleanupDurableRME.run", (String)"1:752:1.27", (Object)this._rcd.getConsumerDispatcherState().getSubscriberID());
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport.CleanupDurableRME", "1:759:1.27", this._rcd.getConsumerDispatcherState().getSubscriberID()});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

