/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport;
import com.ibm.ws.sib.processor.impl.destination.TRMFacade;
import com.ibm.ws.sib.processor.impl.interfaces.LocalizationPoint;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.dlm.Selection;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LocalisationManager {
    private static final TraceComponent tc = SibTr.register(LocalisationManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    protected BaseDestinationHandler _baseDestinationHandler;
    HashMap<SIBUuid8, OutputHandler> _queuePointOutputHandlers = null;
    private HashSet<SIBUuid8> _queuePointsGuessSet = null;
    private HashSet<SIBUuid8> _remoteQueuePointsGuessSet = null;
    protected TRMFacade _trmFacade = null;
    private boolean _hasLocal = false;
    private boolean _hasRemote = false;
    private boolean _isTemporary = false;
    private boolean _isSystem;
    private boolean _singleServer;
    protected HashMap<SIBUuid8, LocalizationPoint> _xmitQueuePoints = null;
    private MessageProcessor _messageProcessor;

    public LocalisationManager(BaseDestinationHandler baseDestinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalisationManager", (Object)new Object[]{baseDestinationHandler});
        }
        this._baseDestinationHandler = baseDestinationHandler;
        this._messageProcessor = this._baseDestinationHandler.getMessageProcessor();
        this._queuePointOutputHandlers = new HashMap(1);
        this._queuePointsGuessSet = new HashSet(1);
        this._remoteQueuePointsGuessSet = new HashSet(1);
        this._isSystem = baseDestinationHandler.isSystem();
        this._isTemporary = baseDestinationHandler.isTemporary();
        this._trmFacade = new TRMFacade(baseDestinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalisationManager", (Object)this);
        }
    }

    public void initialise(boolean singleServer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        this._singleServer = singleServer;
        this._xmitQueuePoints = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public Selection performWLMLookup(SIBUuid8 preferredME, boolean localMessage, HashSet<SIBUuid8> scopedMEs) {
        return null;
    }

    public void updateTrmAdvertisements() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputHandler getQueuePointOutputHandler(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointOutputHandler", (Object)new Object[]{meUuid});
        }
        OutputHandler result = null;
        HashMap<SIBUuid8, OutputHandler> hashMap = this._queuePointOutputHandlers;
        synchronized (hashMap) {
            result = this._queuePointOutputHandlers.get(meUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuePointOutputHandler", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuePointOutputHandler(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeQueuePointOutputHandler", (Object)new Object[]{meUuid});
        }
        HashMap<SIBUuid8, OutputHandler> hashMap = this._queuePointOutputHandlers;
        synchronized (hashMap) {
            this._queuePointOutputHandlers.remove(meUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeQueuePointOutputHandler");
        }
    }

    public boolean doesMEHostQueuePoint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doesMEHostQueuePoint", (Object)new Object[]{meUuid});
        }
        boolean result = this._queuePointsGuessSet.contains(meUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doesMEHostQueuePoint", (Object)result);
        }
        return result;
    }

    public OutputHandler searchForOutputHandler(SIBUuid8 MEUuid, boolean localMessage, AbstractRemoteSupport remoteSupport, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localQueuePointRemoved(SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"localQueuePointRemoved", (Object)new Object[]{messagingEngineUuid});
        }
        HashSet<SIBUuid8> hashSet = this._queuePointsGuessSet;
        synchronized (hashSet) {
            this._queuePointsGuessSet.remove(messagingEngineUuid);
            this._hasLocal = false;
        }
        this.updateTrmAdvertisements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"localQueuePointRemoved");
        }
    }

    public boolean isQueuePointStillAdvertisedForGet(SIBUuid8 meUuid) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocalisationSet(SIBUuid8 messagingEngineUuid, Set newQueuePointLocalisingMEUuids) {
        HashSet<SIBUuid8> hashSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationSet", (Object)new Object[]{messagingEngineUuid, newQueuePointLocalisingMEUuids});
        }
        if (this._queuePointsGuessSet != null) {
            hashSet = this._queuePointsGuessSet;
            synchronized (hashSet) {
                this._queuePointsGuessSet.clear();
                this._hasLocal = false;
                this._hasRemote = false;
                Iterator i = newQueuePointLocalisingMEUuids.iterator();
                while (i.hasNext()) {
                    SIBUuid8 meUuid = new SIBUuid8((String)i.next());
                    this._queuePointsGuessSet.add(meUuid);
                    if (meUuid.equals((Object)messagingEngineUuid)) {
                        this._hasLocal = true;
                        continue;
                    }
                    this._hasRemote = true;
                }
            }
        }
        if (this._remoteQueuePointsGuessSet != null) {
            hashSet = this._remoteQueuePointsGuessSet;
            synchronized (hashSet) {
                HashSet temp;
                HashSet hashSet2 = temp = (HashSet)this._queuePointsGuessSet.clone();
                synchronized (hashSet2) {
                    this._remoteQueuePointsGuessSet = temp;
                    this._remoteQueuePointsGuessSet.remove(messagingEngineUuid);
                }
            }
        }
        this.updateTrmAdvertisements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet");
        }
    }

    public boolean hasLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasLocal");
            SibTr.exit((TraceComponent)tc, (String)"hasLocal", (Object)this._hasLocal);
        }
        return this._hasLocal;
    }

    public boolean hasRemote() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasRemote");
            SibTr.exit((TraceComponent)tc, (String)"hasRemote", (Object)this._hasRemote);
        }
        return this._hasRemote;
    }

    public void setRemote(boolean hasRemote) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRemote", (Object)hasRemote);
        }
        this._hasRemote = hasRemote;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRemote");
        }
    }

    public void setLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLocal", (Object)this._hasLocal);
        }
        this._hasLocal = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLocal");
        }
    }

    public SIBUuid8 chooseRemoteQueuePoint(SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLocalisingUuidsSet() {
        HashSet<SIBUuid8> hashSet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearLocalisingUuidsSet");
        }
        if (this._queuePointsGuessSet != null) {
            hashSet = this._queuePointsGuessSet;
            synchronized (hashSet) {
                this._queuePointsGuessSet.clear();
            }
        }
        if (this._remoteQueuePointsGuessSet != null) {
            hashSet = this._remoteQueuePointsGuessSet;
            synchronized (hashSet) {
                this._remoteQueuePointsGuessSet.clear();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearLocalisingUuidsSet");
        }
    }

    public boolean flushQueuePointOutputHandler() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushQueuePointOutputHandler");
        }
        boolean done = true;
        for (OutputHandler handlerQ : this._queuePointOutputHandlers.values()) {
            if (!(handlerQ instanceof PtoPOutputHandler)) continue;
            done &= ((PtoPOutputHandler)handlerQ).flushAllForDelete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushQueuePointOutputHandler", (Object)new Boolean(done));
        }
        return done;
    }

    public int checkRemoteMessagePointOutputHandlers(SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashSet getQueuePointGuessSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuePointGuessSet");
        }
        HashSet theQueuePoints = null;
        HashSet<SIBUuid8> hashSet = this._queuePointsGuessSet;
        synchronized (hashSet) {
            theQueuePoints = (HashSet)this._queuePointsGuessSet.clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuePointGuessSet", (Object)theQueuePoints);
        }
        return theQueuePoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMEToQueuePointGuessSet(SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMEToQueuePointGuessSet");
        }
        HashSet<SIBUuid8> hashSet = this._queuePointsGuessSet;
        synchronized (hashSet) {
            this._queuePointsGuessSet.add(messagingEngineUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMEToQueuePointGuessSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMEToRemoteQueuePointGuessSet(SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMEToRemoteQueuePointGuessSet");
        }
        HashSet<SIBUuid8> hashSet = this._remoteQueuePointsGuessSet;
        synchronized (hashSet) {
            this._remoteQueuePointsGuessSet.add(messagingEngineUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMEToRemoteQueuePointGuessSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignQueuePointOutputHandler(OutputHandler outputHandler, SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assignQueuePointOutputHandler", (Object)new Object[]{outputHandler, messagingEngineUuid});
        }
        HashMap<SIBUuid8, OutputHandler> hashMap = this._queuePointOutputHandlers;
        synchronized (hashMap) {
            this._queuePointOutputHandlers.put(messagingEngineUuid, outputHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assignQueuePointOutputHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueuePointOutputHandler(SIBUuid8 newLocalisingMEUuid, OutputHandler outputHandler, SIBUuid8 existingUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateQueuePointOutputHandler", (Object)new Object[]{newLocalisingMEUuid, outputHandler, existingUuid});
        }
        HashMap<SIBUuid8, OutputHandler> hashMap = this._queuePointOutputHandlers;
        synchronized (hashMap) {
            this._queuePointOutputHandlers.remove(existingUuid);
            this._queuePointOutputHandlers.put(newLocalisingMEUuid, outputHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateQueuePointOutputHandler");
        }
    }

    public PtoPMessageItemStream addNewRemotePtoPLocalization(TransactionCommon transaction, SIBUuid8 messagingEngineUuid, LocalizationDefinition destinationLocalizationDefinition, boolean queuePoint, AbstractRemoteSupport remoteSupport) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewRemotePtoPLocalization", (Object)new Object[]{transaction, messagingEngineUuid, destinationLocalizationDefinition, queuePoint, remoteSupport});
        }
        PtoPXmitMsgsItemStream newMsgItemStream = null;
        try {
            if (queuePoint) {
                newMsgItemStream = new PtoPXmitMsgsItemStream(this._baseDestinationHandler, messagingEngineUuid);
            }
            transaction.registerCallback((TransactionCallback)new LocalizationAddTransactionCallback(newMsgItemStream));
            Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
            this._baseDestinationHandler.addItemStream(newMsgItemStream, msTran);
            newMsgItemStream.setDefaultDestLimits();
            newMsgItemStream.setDestMsgInterval();
            this.attachRemotePtoPLocalisation(newMsgItemStream, remoteSupport);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewRemotePtoPLocalization", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.LocalisationManager.addNewRemotePtoPLocalization", (String)"1:1562:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewRemotePtoPLocalization", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewRemotePtoPLocalization", (Object)newMsgItemStream);
        }
        return newMsgItemStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachRemotePtoPLocalisation(LocalizationPoint ptoPMessageItemStream, AbstractRemoteSupport remoteSupport) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachRemotePtoPLocalisation", (Object)new Object[]{ptoPMessageItemStream, remoteSupport});
        }
        this.setRemote(true);
        HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
        synchronized (hashMap) {
            this._xmitQueuePoints.put(ptoPMessageItemStream.getLocalizingMEUuid(), ptoPMessageItemStream);
        }
        PtoPOutputHandler remoteOutputHandler = new PtoPOutputHandler(this._baseDestinationHandler, this._baseDestinationHandler.getMessageProcessor(), remoteSupport.getSourceProtocolItemStream(), ptoPMessageItemStream.getLocalizingMEUuid(), (PtoPMessageItemStream)ptoPMessageItemStream);
        ptoPMessageItemStream.setOutputHandler(remoteOutputHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachRemotePtoPLocalisation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PtoPXmitMsgsItemStream getXmitQueuePoint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXmitQueuePoint", (Object)meUuid);
        }
        PtoPXmitMsgsItemStream stream = null;
        if (this._xmitQueuePoints != null) {
            HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                stream = (PtoPXmitMsgsItemStream)this._xmitQueuePoints.get(meUuid);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXmitQueuePoint", stream);
        }
        return stream;
    }

    public int getXmitQueuePointsSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXmitQueuePointsSize");
        }
        int size = this._xmitQueuePoints.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXmitQueuePointsSize", (Object)size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXmitQueuePoint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeXmitQueuePoint", (Object)meUuid);
        }
        if (this._xmitQueuePoints != null) {
            HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                this._xmitQueuePoints.remove(meUuid);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeXmitQueuePoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXmitQueuePoint(SIBUuid8 meUuid, PtoPMessageItemStream ptoPMessageItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addXmitQueuePoint", (Object)meUuid);
        }
        if (this._xmitQueuePoints != null) {
            HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                this._xmitQueuePoints.put(meUuid, ptoPMessageItemStream);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addXmitQueuePoint");
        }
    }

    public HashMap getAllXmitQueuePoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllXmitQueuePoints");
            SibTr.exit((TraceComponent)tc, (String)"getAllXmitQueuePoints", this._xmitQueuePoints);
        }
        return this._xmitQueuePoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<PtoPMessageItemStream> getXmitQueueIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXmitQueueIterator");
        }
        Iterator<PtoPMessageItemStream> itr = null;
        HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
        synchronized (hashMap) {
            itr = ((HashMap)this._xmitQueuePoints.clone()).values().iterator();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXmitQueueIterator", itr);
        }
        return itr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dereferenceLocalisation(LocalizationPoint ptoPMessageItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceLocalisation", (Object)ptoPMessageItemStream);
        }
        HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
        synchronized (hashMap) {
            this._xmitQueuePoints.remove(ptoPMessageItemStream.getLocalizingMEUuid());
        }
        this.removeQueuePointOutputHandler(ptoPMessageItemStream.getLocalizingMEUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceLocalisation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reallocateTransmissionStreams(PtoPXmitMsgsItemStream ignoredStream) {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"reallocateTransmissionStreams", (Object)ignoredStream);
            }
            if (this._xmitQueuePoints != null) {
                LockManager lockManager = this._baseDestinationHandler.getReallocationLockManager();
                lockManager.lockExclusive();
                try {
                    HashMap clonedXmitQueuePoints;
                    if (this._xmitQueuePoints == null) break block10;
                    HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
                    synchronized (hashMap) {
                        clonedXmitQueuePoints = (HashMap)this._xmitQueuePoints.clone();
                    }
                    for (PtoPXmitMsgsItemStream xmitQueue : clonedXmitQueuePoints.values()) {
                        if (xmitQueue == ignoredStream) continue;
                        xmitQueue.reallocateMsgs();
                    }
                }
                finally {
                    lockManager.unlockExclusive();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateTransmissionStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllLocalisationsForCleanUp(boolean singleServer, HashMap postMediatedItemStreamsRequiringCleanup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp", (Object)new Object[]{singleServer});
        }
        if (this._xmitQueuePoints != null) {
            HashMap<SIBUuid8, LocalizationPoint> hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                for (PtoPXmitMsgsItemStream ptoPXmitMsgsItemStream : this._xmitQueuePoints.values()) {
                    postMediatedItemStreamsRequiringCleanup.put(ptoPXmitMsgsItemStream.getLocalizingMEUuid(), ptoPXmitMsgsItemStream);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addAllLocalisationsForCleanUp");
        }
    }

    public void updateRemoteQueuePointSet(Set newQueuePointLocalisingMEUuids, HashMap _postMediatedItemStreamsRequiringCleanup) throws SIResourceException {
    }

    private OutputHandler searchForPtoPOutputHandler(SIBUuid8 preferredME, boolean localMessage, AbstractRemoteSupport remoteSupport, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        return null;
    }

    public void registerDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        this.updateTrmAdvertisements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    public void deregisterDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        this._trmFacade.deregisterDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public void addNewLocalPtoPLocalisation(TransactionCommon transaction, PtoPMessageItemStream newMsgItemStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewLocalPtoPLocalisation", (Object)new Object[]{transaction, newMsgItemStream});
        }
        transaction.registerCallback((TransactionCallback)new LocalizationAddTransactionCallback(newMsgItemStream));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewLocalPtoPLocalisation");
        }
    }

    public TRMFacade getTRMFacade() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTRMFacade", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTRMFacade", (Object)this._trmFacade);
        }
        return this._trmFacade;
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this._messageProcessor = messageProcessor;
    }

    public Set<SIBUuid8> getAllGetLocalisations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllGetLocalisations");
        }
        Set<SIBUuid8> rc = this._trmFacade.getAllGetLocalisations();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllGetLocalisations", rc);
        }
        return rc;
    }

    public class LocalizationRemoveTransactionCallback
    implements TransactionCallback {
        private PtoPMessageItemStream _itemStream;

        public LocalizationRemoveTransactionCallback(PtoPMessageItemStream itemStream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"LocalizationRemoveTransactionCallback", (Object)itemStream);
            }
            this._itemStream = itemStream;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalizationRemoveTransactionCallback", (Object)this);
            }
        }

        public void beforeCompletion(TransactionCommon transaction) {
        }

        public void afterCompletion(TransactionCommon transaction, boolean committed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
            }
            if (committed) {
                LocalisationManager.this.dereferenceLocalisation(this._itemStream);
            } else if (this._itemStream.getOutputHandler() != null && !LocalisationManager.this._baseDestinationHandler.isPubSub() && this._itemStream.getOutputHandler() instanceof ConsumerDispatcher) {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)this._itemStream.getOutputHandler();
                consumerDispatcher.setReadyForUse();
            }
            LocalisationManager.this.updateTrmAdvertisements();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
            }
        }
    }

    public class LocalizationAddTransactionCallback
    implements TransactionCallback {
        private PtoPMessageItemStream _newMsgItemStream;

        public LocalizationAddTransactionCallback(PtoPMessageItemStream newMsgItemStream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"LocalizationAddTransactionCallback", (Object)newMsgItemStream);
            }
            this._newMsgItemStream = newMsgItemStream;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalizationAddTransactionCallback", (Object)this);
            }
        }

        public void beforeCompletion(TransactionCommon transaction) {
        }

        public void afterCompletion(TransactionCommon transaction, boolean committed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, committed});
            }
            if (committed) {
                if (this._newMsgItemStream.getOutputHandler() != null) {
                    LocalisationManager.this._baseDestinationHandler.assignQueuePointOutputHandler(this._newMsgItemStream.getOutputHandler(), this._newMsgItemStream.getLocalizingMEUuid());
                    if (!LocalisationManager.this._baseDestinationHandler.isPubSub() && this._newMsgItemStream.getOutputHandler() instanceof ConsumerDispatcher) {
                        ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)this._newMsgItemStream.getOutputHandler();
                        consumerDispatcher.setReadyForUse();
                    }
                }
                if (LocalisationManager.this._baseDestinationHandler.getPtoPRealization() != null && this._newMsgItemStream.getLocalizingMEUuid().equals((Object)LocalisationManager.this._messageProcessor.getMessagingEngineUuid())) {
                    LocalisationManager.this._baseDestinationHandler.getPtoPRealization().registerDestination(LocalisationManager.this.hasLocal(), LocalisationManager.this._baseDestinationHandler.isDeleted());
                }
                this._newMsgItemStream.registerControlAdapterAsMBean();
                this._newMsgItemStream = null;
            } else {
                this._newMsgItemStream.setOutputHandler(null);
                LocalisationManager.this.dereferenceLocalisation(this._newMsgItemStream);
                this._newMsgItemStream = null;
            }
            LocalisationManager.this.updateTrmAdvertisements();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
            }
        }
    }
}

