/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.JSConsumerClassifications;
import com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKey;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidFlowsException;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.messagecontrol.ConsumerSet;
import com.ibm.wsspi.sib.messagecontrol.Flow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JSConsumerSet
implements ConsumerSet {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(JSConsumerSet.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String label = null;
    private JSConsumerClassifications classifications = null;
    HashMap<Integer, Integer> weightMap = null;
    private int maxActiveMessages = Integer.MAX_VALUE;
    private int currentActiveMessages = 0;
    private int preparedActiveMessages = 0;
    private Object maxActiveMessageLock = 0;
    private ReentrantReadWriteLock maxActiveMessagePrepareLock = null;
    private Lock maxActiveMessagePrepareReadLock = null;
    private Lock maxActiveMessagePrepareWriteLock = null;
    private int resumeThreshold = Integer.MAX_VALUE;
    ArrayList<DispatchableKey> keyRegistry = null;
    private boolean consumerSetSuspended = false;
    private ArrayList<DispatchableConsumerPoint> consumerList = null;
    int startPoint = 0;
    private ReadWriteLock classificationLock = null;
    private Lock classificationReadLock = null;
    private Lock classificationWriteLock = null;
    private boolean unitTestOperation = false;

    public JSConsumerSet(String label) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JSConsumerSet", (Object)new Object[]{label});
        }
        this.label = label;
        this.keyRegistry = new ArrayList();
        this.consumerList = new ArrayList();
        this.classifications = new JSConsumerClassifications(label);
        this.classificationLock = new ReentrantReadWriteLock();
        this.classificationReadLock = this.classificationLock.readLock();
        this.classificationWriteLock = this.classificationLock.writeLock();
        this.maxActiveMessageLock = new Object();
        this.maxActiveMessagePrepareLock = new ReentrantReadWriteLock();
        this.maxActiveMessagePrepareReadLock = this.maxActiveMessagePrepareLock.readLock();
        this.maxActiveMessagePrepareWriteLock = this.maxActiveMessagePrepareLock.writeLock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareLock: " + this.maxActiveMessagePrepareLock));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JSConsumerSet", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(DispatchableConsumerPoint lcp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumer", (Object)lcp);
        }
        ArrayList<DispatchableConsumerPoint> arrayList = this.consumerList;
        synchronized (arrayList) {
            this.consumerList.add(lcp);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(DispatchableConsumerPoint lcp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumer", (Object)lcp);
        }
        ArrayList<DispatchableConsumerPoint> arrayList = this.consumerList;
        synchronized (arrayList) {
            this.consumerList.remove(lcp);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGetCursorIndex(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursorIndex");
        }
        int classPos = 0;
        JSConsumerClassifications jSConsumerClassifications = this.classifications;
        synchronized (jSConsumerClassifications) {
            String keyClassification;
            if (this.classifications.getNumberOfClasses() > 0 && (keyClassification = msg.getMessageControlClassification(true)) != null && this.classifications.getWeight(keyClassification) > 0) {
                classPos = this.classifications.getPosition(keyClassification);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursorIndex", (Object)classPos);
        }
        return classPos;
    }

    public synchronized int chooseGetCursorIndex(int previous) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"chooseGetCursorIndex", (Object)new Object[]{previous});
        }
        int classPos = 0;
        if (this.classifications.getNumberOfClasses() > 0) {
            if (previous == -1) {
                this.weightMap = this.classifications.getWeightings();
            } else {
                this.weightMap.remove(previous);
            }
            if (!this.weightMap.isEmpty()) {
                classPos = this.classifications.findClassIndex(this.weightMap);
            } else if (this.unitTestOperation) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"chooseGetCursorIndex", (Object)"SIErrorException");
                }
                throw new SIErrorException();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"chooseGetCursorIndex", (Object)classPos);
        }
        return classPos;
    }

    public JSConsumerClassifications getClassifications() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getClassifications");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getClassifications", (Object)this.classifications);
        }
        return this.classifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage");
        }
        boolean messageAccepted = false;
        boolean limitReached = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.lock(): " + this.maxActiveMessagePrepareLock));
        }
        this.maxActiveMessagePrepareReadLock.lock();
        Object object = this.maxActiveMessageLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Active Messages: current: " + this.currentActiveMessages + ", prepared: " + this.preparedActiveMessages + ", maximum: " + this.maxActiveMessages + " (suspended: " + this.consumerSetSuspended + ")"));
            }
            if (!this.consumerSetSuspended) {
                if (this.currentActiveMessages + this.preparedActiveMessages == this.maxActiveMessages - 1) {
                    limitReached = true;
                } else {
                    ++this.preparedActiveMessages;
                    messageAccepted = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Prepare added");
                    }
                }
            }
            if (!messageAccepted) {
                this.maxActiveMessagePrepareReadLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.unlock(): " + this.maxActiveMessagePrepareLock));
                }
            }
        }
        if (limitReached) {
            boolean releaseWriteLock = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.lock(): " + this.maxActiveMessagePrepareLock));
            }
            this.maxActiveMessagePrepareWriteLock.lock();
            Object object2 = this.maxActiveMessageLock;
            synchronized (object2) {
                if (!this.consumerSetSuspended) {
                    messageAccepted = true;
                    ++this.preparedActiveMessages;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Prepare added");
                    }
                    if (this.currentActiveMessages + this.preparedActiveMessages == this.maxActiveMessages) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Write lock held until commit/rollback");
                        }
                        releaseWriteLock = false;
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.lock(): " + this.maxActiveMessagePrepareLock));
                        }
                        this.maxActiveMessagePrepareReadLock.lock();
                    }
                }
                if (releaseWriteLock) {
                    this.maxActiveMessagePrepareWriteLock.unlock();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.unlock(): " + this.maxActiveMessagePrepareLock));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage", (Object)messageAccepted);
        }
        return messageAccepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
        Object object = this.maxActiveMessageLock;
        synchronized (object) {
            ++this.currentActiveMessages;
            --this.preparedActiveMessages;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Active Messages: current: " + this.currentActiveMessages + ", prepared: " + this.preparedActiveMessages + ", maximum: " + this.maxActiveMessages + " (suspended: " + this.consumerSetSuspended + ")"));
            }
            if (this.preparedActiveMessages < 0) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.commitAddActiveMessage", "1:499:1.16", this.preparedActiveMessages, this.currentActiveMessages, this.maxActiveMessages, this.consumerSetSuspended}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSConsumerSet.commitAddActiveMessage", (String)"1:510:1.16", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.commitAddActiveMessage", "1:517:1.16"});
            }
            if (this.maxActiveMessagePrepareLock.isWriteLockedByCurrentThread()) {
                if (this.currentActiveMessages == this.maxActiveMessages) {
                    this.consumerSetSuspended = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("JSConsumerSet suspended " + this));
                    }
                }
                this.maxActiveMessagePrepareWriteLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.unlock(): " + this.maxActiveMessagePrepareLock));
                }
            } else {
                this.maxActiveMessagePrepareReadLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.unlock(): " + this.maxActiveMessagePrepareLock));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
        Object object = this.maxActiveMessageLock;
        synchronized (object) {
            --this.preparedActiveMessages;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Active Messages: current: " + this.currentActiveMessages + ", prepared: " + this.preparedActiveMessages + ", maximum: " + this.maxActiveMessages + " (suspended: " + this.consumerSetSuspended + ")"));
            }
            if (this.maxActiveMessagePrepareLock.isWriteLockedByCurrentThread()) {
                this.maxActiveMessagePrepareWriteLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.unlock(): " + this.maxActiveMessagePrepareLock));
                }
            } else {
                this.maxActiveMessagePrepareReadLock.unlock();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.unlock(): " + this.maxActiveMessagePrepareLock));
                }
            }
            if (this.preparedActiveMessages < 0) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.rollbackAddActiveMessage", "1:615:1.16", this.preparedActiveMessages, this.currentActiveMessages, this.maxActiveMessages, this.consumerSetSuspended}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSConsumerSet.rollbackAddActiveMessage", (String)"1:626:1.16", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.rollbackAddActiveMessage", "1:633:1.16"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveMessages(int messageCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeActiveMessages", (Object)messageCount);
        }
        boolean resumeConsumers = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.lock(): " + this.maxActiveMessagePrepareLock));
        }
        this.maxActiveMessagePrepareReadLock.lock();
        try {
            Object object = this.maxActiveMessageLock;
            synchronized (object) {
                this.currentActiveMessages -= messageCount;
                if (this.currentActiveMessages < 0) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.removeActiveMessages", "1:677:1.16", this.preparedActiveMessages, this.currentActiveMessages, this.maxActiveMessages, this.consumerSetSuspended}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSConsumerSet.removeActiveMessages", (String)"1:688:1.16", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.removeActiveMessages", "1:695:1.16"});
                }
                if (this.consumerSetSuspended && this.currentActiveMessages == this.resumeThreshold - messageCount) {
                    this.consumerSetSuspended = false;
                    resumeConsumers = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Active Messages: current: " + this.currentActiveMessages + ", prepared: " + this.preparedActiveMessages + ", maximum: " + this.maxActiveMessages + " (suspended: " + this.consumerSetSuspended + ")"));
                }
            }
        }
        finally {
            this.maxActiveMessagePrepareReadLock.unlock();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.unlock(): " + this.maxActiveMessagePrepareLock));
            }
        }
        if (resumeConsumers) {
            this.resumeConsumers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeActiveMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeConsumers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resumeConsumers");
        }
        ArrayList<DispatchableConsumerPoint> arrayList = this.consumerList;
        synchronized (arrayList) {
            int listSize = this.consumerList.size();
            ++this.startPoint;
            this.startPoint %= listSize;
            for (int i = 0; i < listSize; ++i) {
                JSLocalConsumerPoint lcp = (JSLocalConsumerPoint)this.consumerList.get((this.startPoint + i) % listSize);
                lcp.resumeConsumer(8);
            }
        }
        Thread.yield();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resumeConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrencyLimit(int maxConcurrency) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConcurrencyLimit", (Object)maxConcurrency);
        }
        boolean resumeConsumers = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.lock(): " + this.maxActiveMessagePrepareLock));
        }
        this.maxActiveMessagePrepareWriteLock.lock();
        try {
            Object object = this.maxActiveMessageLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Inital active Messages: current: " + this.currentActiveMessages + ", prepared: " + this.preparedActiveMessages + ", maximum: " + this.maxActiveMessages + " (suspended: " + this.consumerSetSuspended + ")"));
                }
                if (maxConcurrency == 0) {
                    this.maxActiveMessages = Integer.MAX_VALUE;
                    this.resumeThreshold = Integer.MAX_VALUE;
                } else {
                    this.maxActiveMessages = maxConcurrency;
                    float res = this.maxActiveMessages * 8;
                    res = Math.round(res / 10.0f);
                    this.resumeThreshold = (int)res;
                }
                if (this.currentActiveMessages > this.maxActiveMessages) {
                    this.consumerSetSuspended = true;
                } else if (this.consumerSetSuspended && this.currentActiveMessages < this.resumeThreshold) {
                    this.consumerSetSuspended = false;
                    resumeConsumers = true;
                }
            }
        }
        finally {
            this.maxActiveMessagePrepareWriteLock.unlock();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareWriteLock.unlock(): " + this.maxActiveMessagePrepareLock));
            }
        }
        if (resumeConsumers) {
            this.resumeConsumers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConcurrencyLimit");
        }
    }

    public void setFlowProperties(Flow[] flows) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFlowProperties", (Object)flows);
        }
        try {
            this.classificationWriteLock.lock();
            if (flows == null) {
                SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("NULL_FLOW_CLASSIFICATIONS_CWSIP0851", new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.setFlowProperties", "1:877:1.16", this.label}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSConsumerSet.setFlowProperties", (String)"1:885:1.16", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"setFlowProperties", (Object)"SIIncorrectCallException");
                }
                throw e;
            }
            boolean weightChangeOnly = this.classifications.setClassifications(flows);
            if (!weightChangeOnly) {
                for (DispatchableKey key : this.keyRegistry) {
                    if (key instanceof LocalQPConsumerKey) {
                        ((LocalQPConsumerKey)key).notifyResetFlowProperties();
                        continue;
                    }
                    if (!(key instanceof LocalQPConsumerKeyGroup)) continue;
                    ((LocalQPConsumerKeyGroup)key).notifyResetFlowProperties();
                }
            }
        }
        catch (InvalidFlowsException ife) {
            FFDCFilter.processException((Throwable)ife, (String)"com.ibm.ws.sib.processor.impl.JSConsumerSet.setFlowProperties", (String)"1:923:1.16", (Object)this);
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("INVALID_FLOW_CLASSIFICATIONS_CWSIP0852", new Object[]{"com.ibm.ws.sib.processor.impl.JSConsumerSet.setFlowProperties", "1:933:1.16", this.label}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setFlowProperties", (Object)"SIIncorrectCallException");
            }
            throw e;
        }
        finally {
            this.classificationWriteLock.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setFlowProperties");
        }
    }

    public Flow[] getFlows() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFlows");
        }
        Flow[] flows = this.classifications.getFlows();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFlows", (Object)flows);
        }
        return flows;
    }

    public synchronized void registerKey(DispatchableKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerKey", (Object)key);
        }
        this.keyRegistry.add(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerSetSuspended() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isConsumerSetSuspended");
        }
        boolean suspended = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.lock(): " + this.maxActiveMessagePrepareLock));
        }
        this.maxActiveMessagePrepareReadLock.lock();
        Object object = this.maxActiveMessageLock;
        synchronized (object) {
            suspended = this.consumerSetSuspended;
        }
        this.maxActiveMessagePrepareReadLock.unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("maxActiveMessagePrepareReadLock.unlock(): " + this.maxActiveMessagePrepareLock));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isConsumerSetSuspended", (Object)suspended);
        }
        return suspended;
    }

    public void takeClassificationReadLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"takeClassificationReadLock");
        }
        this.classificationReadLock.lock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"takeClassificationReadLock");
        }
    }

    public void freeClassificationReadLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"freeClassificationReadLock");
        }
        this.classificationReadLock.unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"freeClassificationReadLock");
        }
    }

    public String getLabel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLabel");
            SibTr.exit((TraceComponent)tc, (String)"getLabel", (Object)this.label);
        }
        return this.label;
    }

    public synchronized void setUnitTestOperation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUnitTestOperation");
            SibTr.exit((TraceComponent)tc, (String)"setUnitTestOperation");
        }
        this.unitTestOperation = true;
    }

    public String toString() {
        String jsConsumerSetStr = "JSConsumerSet: " + this.label;
        return jsConsumerSetStr;
    }
}

