/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.processor.gd.InternalInputStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalInputStreamManager {
    private static final TraceComponent tc = SibTr.register(InternalInputStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private UpstreamControl upControl;
    private MessageProcessor messageProcessor;
    private Map streamSets;
    protected FlushComplete flushInProgress = null;

    public InternalInputStreamManager(MessageProcessor messageProcessor, UpstreamControl upControl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalInputStreamManager", (Object)new Object[]{messageProcessor, upControl});
        }
        this.upControl = upControl;
        this.messageProcessor = messageProcessor;
        this.streamSets = Collections.synchronizedMap(new HashMap());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalInputStreamManager", (Object)this);
        }
    }

    public boolean hasStream(SIBUuid12 streamID, int priority, Reliability reliability) throws SIResourceException {
        StreamSet streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasStream", (Object)new Object[]{streamID, new Integer(priority), reliability});
        }
        if ((streamSet = (StreamSet)this.streamSets.get(streamID)) != null && streamSet.getStream(priority, reliability) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"hasStream", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasStream", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(JsMessage jsMsg) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMessage", (Object)new Object[]{jsMsg});
        }
        int priority = jsMsg.getPriority();
        Reliability reliability = jsMsg.getReliability();
        SIBUuid12 streamID = jsMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(priority, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, priority, reliability);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAckExpected(ControlAckExpected ackExpMsg) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpectedMessage", (Object)new Object[]{ackExpMsg});
        }
        int priority = ackExpMsg.getPriority();
        Reliability reliability = ackExpMsg.getReliability();
        SIBUuid12 streamID = ackExpMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(priority, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, priority, reliability);
            }
        }
        internalInputStream.processAckExpected(ackExpMsg.getTick());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpectedMessage");
        }
    }

    public List processAck(ControlAck ackMsg) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg});
        }
        long ackPrefix = ackMsg.getAckPrefix();
        List indexList = this.processAck(ackMsg, ackPrefix);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)indexList);
        }
        return indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List processAck(ControlAck ackMsg, long ackPrefix) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg, new Long(ackPrefix)});
        }
        int priority = ackMsg.getPriority();
        Reliability reliability = ackMsg.getReliability();
        List indexList = null;
        SIBUuid12 streamID = ackMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(priority, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, priority, reliability);
            }
        }
        long completedPrefix = internalInputStream.getAckPrefix();
        if (ackPrefix > completedPrefix) {
            indexList = internalInputStream.writeAckPrefix(ackPrefix);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)indexList);
        }
        return indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack nackMsg) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)nackMsg);
        }
        int priority = nackMsg.getPriority();
        Reliability reliability = nackMsg.getReliability();
        SIBUuid12 streamID = nackMsg.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(streamID, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(priority, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, priority, reliability);
            }
        }
        internalInputStream.processNack(nackMsg);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet getStreamSet(SIBUuid12 streamID, boolean create) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)new Object[]{streamID, new Boolean(create)});
        }
        StreamSet streamSet = null;
        Map map = this.streamSets;
        synchronized (map) {
            streamSet = (StreamSet)this.streamSets.get(streamID);
            if (streamSet == null && create) {
                streamSet = new StreamSet(streamID, null, 0L, StreamSet.Type.INTERNAL_INPUT);
                this.streamSets.put(streamID, streamSet);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    private InternalInputStream createStream(StreamSet streamSet, int priority, Reliability reliability) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{new Integer(priority), reliability});
        }
        InternalInputStream stream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            stream = new InternalInputStream(priority, reliability, this.upControl, streamSet.getStreamID(), null, this.messageProcessor.getAlarmManager());
        }
        streamSet.setStream(priority, reliability, stream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", stream);
        }
        return stream;
    }
}

