/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.impl.TargetStreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class GuaranteedTargetStream
extends ControllableStream
implements TargetStream,
BatchListener {
    private MPAlarmManager am;
    private static TraceComponent tc = SibTr.register(GuaranteedTargetStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int priority;
    private Reliability reliability;
    private MessageDeliverer deliverer;
    private UpstreamControl upControl;
    private final StateStream oststream;
    private long doubtHorizon;
    private long unknownHorizon;
    private long nextCompletedPrefix = 0L;
    private boolean isStreamBlocked = false;
    private JsDestinationAddress streamBlockingAddress = null;
    private boolean unexpectedBlock = false;
    private long valueHorizon = 0L;
    protected static final Hashtable pendingAlarms = new Hashtable();
    private final GuaranteedTargetStreamState streamState = GuaranteedTargetStreamState.ACTIVE;
    private int messagesInBatch = 0;
    private long numberOfMessagesReceived = 0L;
    private long timeLastMsgReceived = 0L;
    protected StreamSet streamSet;
    private SIBUuid8 remoteEngineUUID;
    private int valueCounter = 0;
    private int repeatedValueCounter = 0;
    private long lastRepeatedValueWarningTime = 0L;
    private MessageProcessor mp;
    private TargetStreamControl targetStreamControl;
    private long lastNackTick = -1L;
    private long linkBlockingTick = -1L;
    private int blockingCount = 0;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long _lastAckedTick = 0L;
    private final long ACK_GAP_FOR_SILENCE_TICKS = 50L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuaranteedTargetStream(MessageDeliverer deliverer, UpstreamControl upControl, MPAlarmManager am, StreamSet streamSet, int priority, Reliability reliability, List scratch, MessageProcessor mp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"GuaranteedTargetStream", (Object)new Object[]{deliverer, upControl, am, streamSet, priority, reliability, scratch, mp});
        }
        StateStream stateStream = this.oststream = new StateStream();
        synchronized (stateStream) {
            this.remoteEngineUUID = streamSet.getRemoteMEUuid();
            this.am = am;
            this.priority = priority;
            this.reliability = reliability;
            this.unknownHorizon = 0L;
            this.doubtHorizon = 1L;
            this.oststream.init();
            this.deliverer = deliverer;
            this.upControl = upControl;
            this.streamSet = streamSet;
            this.mp = mp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"GuaranteedTargetStream", (Object)this);
        }
    }

    @Override
    public long reconstituteCompletedPrefix(long newPrefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reconstituteCompletedPrefix", (Object)newPrefix);
        }
        long prefix = this.oststream.setCompletedPrefix(newPrefix) ? newPrefix : this.oststream.getCompletedPrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteCompletedPrefix", (Object)prefix);
        }
        return prefix;
    }

    private void persistCompletedPrefix(TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistCompletedPrefix", (Object)tran);
        }
        this.streamSet.setPersistentData(this.priority, this.reliability, this.getNextCompletedPrefix());
        this.streamSet.requestUpdate(this.reliability, tran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompletedPrefix(long newPrefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCompletedPrefix", (Object)newPrefix);
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            if (this.oststream.setCompletedPrefix(newPrefix)) {
                this.doubtHorizon = newPrefix + 1L;
                this.unknownHorizon = newPrefix;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("doubtHorizon:" + this.doubtHorizon + " unknownHorizon:" + this.unknownHorizon));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateCompletedPrefix");
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("nextCompletedPrefix: " + this.nextCompletedPrefix));
            }
            this.oststream.setCompletedPrefix(this.nextCompletedPrefix);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDoubtHorizon() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetDoubtHorizon");
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.resetDoubtHorizon(this.oststream.getCompletedPrefix() + 1L, null, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
    }

    public void resetDoubtHorizon(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetDoubtHorizon", (Object)tick);
        }
        this.resetDoubtHorizon(tick, null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDoubtHorizon(long tick, Exception e, JsDestinationAddress address) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetDoubtHorizon", (Object)new Object[]{tick, e, address});
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.doubtHorizon = tick;
            if (e != null) {
                this.setStreamIsBlocked(true, 0, e, address);
                this.linkBlockingTick = tick;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDoubtHorizon() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDoubtHorizon");
        }
        long retDoubtHorizon = 0L;
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            retDoubtHorizon = this.doubtHorizon;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDoubtHorizon", (Object)retDoubtHorizon);
        }
        return retDoubtHorizon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeValue(MessageItem msgItem) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeValue", (Object)new Object[]{msgItem});
        }
        TickRange tr = null;
        List<MessageItem> msgList = null;
        JsMessage m = msgItem.getMessage();
        long valueTick = m.getGuaranteedValueValueTick();
        this.timeLastMsgReceived = System.currentTimeMillis();
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            StateStream stateStream = this.oststream;
            synchronized (stateStream) {
                boolean canProcessMessage = false;
                try {
                    canProcessMessage = this.streamCanAcceptNewMessage(msgItem, valueTick);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeValue", (String)"1:452:1.110", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)e));
                    }
                    return;
                }
                if (canProcessMessage) {
                    boolean repeatedValue = false;
                    long completedPrefix = this.oststream.getCompletedPrefix();
                    if (valueTick > completedPrefix) {
                        tr = TickRange.newValueTick(valueTick, msgItem, -1L);
                        tr.startstamp = m.getGuaranteedValueStartTick();
                        tr.endstamp = m.getGuaranteedValueEndTick();
                        boolean streamChanged = false;
                        streamChanged = this.oststream.writeCombinedRange(tr);
                        if (streamChanged) {
                            if (tr.valuestamp > this.valueHorizon) {
                                this.valueHorizon = tr.valuestamp;
                            }
                            boolean gapcreated = false;
                            tr = this.oststream.findCompletedRange(tr);
                            if (tr.endstamp > this.unknownHorizon) {
                                if (tr.startstamp > this.unknownHorizon + 1L) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("created gap [" + (this.unknownHorizon + 1L) + ", " + (tr.startstamp - 1L) + "]"));
                                    }
                                    gapcreated = true;
                                    this.handleNewGap(this.unknownHorizon + 1L, tr.startstamp - 1L);
                                }
                                this.unknownHorizon = tr.endstamp;
                            }
                            if (!gapcreated) {
                                if (tr.startstamp <= this.doubtHorizon) {
                                    if (msgList == null) {
                                        msgList = new ArrayList<MessageItem>();
                                    }
                                    msgList.add(msgItem);
                                    this.doubtHorizon = tr.endstamp + 1L;
                                    msgList = this.advanceDoubtHorizon(msgList);
                                } else {
                                    msgList = this.advanceDoubtHorizon(msgList);
                                }
                            }
                            if (this.lastNackTick >= 0L && tr.startstamp <= this.lastNackTick && tr.endstamp >= this.lastNackTick) {
                                this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.MSG_LOST_ERROR_STATE, 2);
                                this.lastNackTick = -1L;
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Repeated V tick value - not yet acked " + valueTick + " : " + completedPrefix));
                            }
                            repeatedValue = true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Repeated V tick value - already acked " + valueTick + " : " + completedPrefix));
                        }
                        repeatedValue = true;
                    }
                    int repeatedPercent = this.mp.getCustomProperties().getRepeatedValuePercentage();
                    int repeatedInterval = this.mp.getCustomProperties().getRepeatedValueInterval();
                    if (repeatedPercent > 0 && repeatedInterval > 0) {
                        ++this.valueCounter;
                        int repeatedValueThreshold = repeatedPercent * repeatedInterval / 100;
                        if (repeatedValue) {
                            long currentTime;
                            ++this.repeatedValueCounter;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("valueCounter:" + this.valueCounter + " repeatedValueThreshold:" + repeatedValueThreshold + " repeatedValueCounter:" + this.repeatedValueCounter + " lastRepeatedValueWarningTime:" + this.lastRepeatedValueWarningTime));
                            }
                            if (this.repeatedValueCounter >= repeatedValueThreshold && (currentTime = System.currentTimeMillis()) - this.lastRepeatedValueWarningTime > 300000L) {
                                int percent = this.repeatedValueCounter * 100 / this.valueCounter;
                                this.deliverer.reportRepeatedMessages(this.remoteEngineUUID.toString(), percent);
                                this.lastRepeatedValueWarningTime = currentTime;
                                this.valueCounter = 0;
                                this.repeatedValueCounter = 0;
                            }
                        }
                        if (this.valueCounter == repeatedInterval) {
                            this.valueCounter = 0;
                            this.repeatedValueCounter = 0;
                        }
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The stream is blocked: msg discarded for resend.");
                }
            }
            if (msgList != null) {
                try {
                    this.messagesInBatch += msgList.size();
                    this.deliverer.deliverOrderedMessages(msgList, this, this.priority, this.reliability);
                }
                catch (SINotPossibleInCurrentConfigurationException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"writeValue", (Object)"GDException");
                    }
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeValue", (String)"1:709:1.110", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:716:1.110", e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)"GDException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:726:1.110", e}, null), (Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue");
        }
    }

    @Override
    public void writeSilence(MessageItem m) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{m});
        }
        JsMessage jsMsg = m.getMessage();
        long stamp = jsMsg.getGuaranteedValueValueTick();
        long ends = jsMsg.getGuaranteedValueEndTick();
        if (ends < stamp) {
            ends = stamp;
        }
        TickRange tr = new TickRange(7, jsMsg.getGuaranteedValueStartTick(), ends);
        this.writeSilenceInternal(tr, false);
        long gapFromPreviousAck = ends - this._lastAckedTick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("gap from the previous ack: " + gapFromPreviousAck + " lastAckedTick: " + this._lastAckedTick));
        }
        if (gapFromPreviousAck >= this.ACK_GAP_FOR_SILENCE_TICKS) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"sending the ACK message for the batch of silence message ", (Object)new Object[]{m});
            }
            this.sendAck();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
    }

    @Override
    public void writeSilence(ControlSilence m) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{m});
        }
        TickRange tr = new TickRange(7, m.getStartTick(), m.getEndTick());
        this.writeSilenceInternal(tr, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSilenceForced(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilenceForced", (Object)tick);
        }
        TickRange tr = null;
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.oststream.setCursor(tick);
            tr = this.oststream.getNext();
        }
        this.writeSilenceInternal(tr, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSilenceInternal(TickRange tr, boolean forced) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeSilenceInternal", (Object)new Object[]{tr, forced});
        }
        List msgList = null;
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            if (!forced || tr.valuestamp > this.nextCompletedPrefix) {
                StateStream stateStream = this.oststream;
                synchronized (stateStream) {
                    long completedPrefix = this.oststream.getCompletedPrefix();
                    if (tr.endstamp > completedPrefix) {
                        if (!forced) {
                            this.oststream.writeRange(tr);
                        } else {
                            this.oststream.writeCompletedRangeForced(tr);
                        }
                        completedPrefix = this.oststream.getCompletedPrefix();
                    }
                    if (completedPrefix + 1L > this.doubtHorizon) {
                        this.doubtHorizon = completedPrefix + 1L;
                        msgList = this.advanceDoubtHorizon(null);
                    }
                    if (this.doubtHorizon - 1L > this.unknownHorizon) {
                        this.unknownHorizon = this.doubtHorizon - 1L;
                    }
                    if (tr.endstamp > this.unknownHorizon) {
                        if (tr.startstamp > this.unknownHorizon + 1L) {
                            this.handleNewGap(this.unknownHorizon + 1L, tr.startstamp - 1L);
                        }
                        this.unknownHorizon = tr.endstamp;
                    }
                    if (this.lastNackTick >= 0L && tr.startstamp <= this.lastNackTick && tr.endstamp >= this.lastNackTick) {
                        this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.MSG_LOST_ERROR_STATE, 2);
                        this.lastNackTick = -1L;
                    }
                    if (this.isStreamBlocked()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Stream is blocked on tick: " + this.linkBlockingTick + ", see if we can unblock it"));
                        }
                        if (tr.endstamp >= this.linkBlockingTick && tr.startstamp <= this.linkBlockingTick) {
                            this.setStreamIsBlocked(false, 1, null, null);
                        }
                    }
                }
                if (msgList != null) {
                    try {
                        this.deliverer.deliverOrderedMessages(msgList, this, this.priority, this.reliability);
                    }
                    catch (SINotPossibleInCurrentConfigurationException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"writeSilenceInternal", (Object)"GDException");
                        }
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeSilenceInternal", (String)"1:960:1.110", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:967:1.110", e});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"writeSilenceInternal", (Object)"GDException");
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:977:1.110", e}, null), (Throwable)e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAckExpected(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{stamp});
        }
        ArrayList<TickRange> nackList = null;
        List msgList = null;
        boolean processNack = true;
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            StateStream stateStream = this.oststream;
            synchronized (stateStream) {
                long completedPrefix = this.oststream.getCompletedPrefix();
                long blockingTick = -1L;
                this.sendAck();
                if (this.isStreamBlocked()) {
                    if (this.isStreamBlockedUnexpectedly()) {
                        stamp = this.linkBlockingTick;
                        blockingTick = this.linkBlockingTick;
                        this.setStreamIsBlocked(false, 1, null, null);
                    } else {
                        int blockingReason = this.deliverer.checkStillBlocked();
                        if (blockingReason == 1) {
                            this.setStreamIsBlocked(false, 1, null, null);
                        } else {
                            this.setStreamIsBlocked(true, blockingReason, null, this.streamBlockingAddress);
                            if (this.blockingCount++ > 3) {
                                stamp = this.linkBlockingTick;
                                this.blockingCount = 0;
                                blockingTick = this.linkBlockingTick;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Nacking the first tick (" + stamp + ") of a blocked link"));
                                }
                            } else {
                                processNack = false;
                            }
                        }
                    }
                }
                if (processNack) {
                    if (stamp <= completedPrefix) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
                        }
                        return;
                    }
                    nackList = new ArrayList<TickRange>();
                    long startstamp = completedPrefix + 1L;
                    long endstamp = stamp;
                    this.oststream.setCursor(startstamp);
                    TickRange tr2 = null;
                    TickRange tr1 = this.oststream.getNext();
                    do {
                        if (tr1.type == 0 || tr1.type == 1) {
                            long ss = tr1.startstamp > startstamp ? tr1.startstamp : startstamp;
                            long es = endstamp > tr1.endstamp ? tr1.endstamp : endstamp;
                            TickRange tr = new TickRange(1, ss, es);
                            if (tr1.type == 0) {
                                this.oststream.writeRange(tr);
                            }
                            Hashtable hashtable = pendingAlarms;
                            synchronized (hashtable) {
                                if (!GuaranteedTargetStream.getAlarms(this).hasNext()) {
                                    this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.MSG_LOST_ERROR_STATE, 1);
                                    this.lastNackTick = endstamp;
                                }
                            }
                            nackList.add(tr);
                        } else if (tr1.type == 3 && tr1.endstamp == blockingTick) {
                            nackList.add(tr1);
                        }
                        tr2 = tr1;
                        tr1 = this.oststream.getNext();
                    } while (tr1.startstamp <= endstamp && tr1 != tr2);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"did not process AckExpected message for nacks.");
                }
                msgList = this.advanceDoubtHorizon(null);
            }
            if (msgList != null) {
                try {
                    this.deliverer.deliverOrderedMessages(msgList, this, this.priority, this.reliability);
                }
                catch (SINotPossibleInCurrentConfigurationException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"processAckExpected", (Object)"GDException");
                    }
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.processAckExpected", (String)"1:1201:1.110", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1208:1.110", e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)"GDException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1218:1.110", e}, null), (Throwable)e);
                }
            }
        }
        for (int j = 0; processNack && j < nackList.size(); ++j) {
            TickRange temptr = (TickRange)nackList.get(j);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("processAckExpected sending Nack from: " + temptr.startstamp + " to " + temptr.endstamp));
                }
                this.upControl.sendNackMessage(this.streamSet.getRemoteMEUuid(), this.streamSet.getDestUuid(), this.streamSet.getBusUuid(), temptr.startstamp, temptr.endstamp, this.priority, this.reliability, this.streamSet.getStreamID());
                continue;
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.processAckExpected", (String)"1:1252:1.110", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1259:1.110", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)e));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1270:1.110", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    private void handleNewGap(long startstamp, long endstamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewGap", (Object)new Object[]{startstamp, endstamp});
        }
        TickRange tr = new TickRange(1, startstamp, endstamp);
        this.oststream.writeRange(tr);
        this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.GAP_DETECTED_STATE, 1);
        NRTExpiryHandle nexphandle = new NRTExpiryHandle(tr, this);
        nexphandle.timer = this.am.create(this.mp.getCustomProperties().getGapCuriosityThreshold(), nexphandle);
        GuaranteedTargetStream.addAlarm(this, nexphandle);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewGap");
        }
    }

    private List advanceDoubtHorizon(List existingMsgList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"advanceDoubtHorizon", (Object)existingMsgList);
        }
        this.oststream.setCursor(this.doubtHorizon);
        TickRange tr = null;
        TickRange tr2 = null;
        ArrayList<MessageItem> msgList = null;
        if (existingMsgList != null) {
            msgList = existingMsgList;
        }
        while ((tr2 = tr) != (tr = this.oststream.getNext())) {
            if (tr.type == 7) continue;
            if (tr.type != 3) break;
            try {
                MessageItem m = (MessageItem)tr.value;
                if (msgList == null) {
                    msgList = new ArrayList<MessageItem>();
                }
                msgList.add(m);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.advanceDoubtHorizon", (String)"1:1368:1.110", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"advanceDoubtHorizon", (Object)"GDException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1375:1.110", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1383:1.110", e}, null), (Throwable)e);
            }
        }
        if (tr.startstamp > this.doubtHorizon) {
            this.doubtHorizon = tr.startstamp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"advanceDoubtHorizon", (Object)new Object[]{this.doubtHorizon, msgList});
        }
        return msgList;
    }

    protected void releaseMemory() {
    }

    @Override
    public StateStream getStateStream() {
        return this.oststream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush");
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            Iterator i = GuaranteedTargetStream.getAlarms(this);
            while (i.hasNext()) {
                NRTExpiryHandle next = (NRTExpiryHandle)i.next();
                next.timer.cancel();
                i.remove();
            }
        }
        this.getControlAdapter().getHealthState().deregister(HealthStateListener.GAP_DETECTED_STATE);
        if (this.oststream.containsState(new TickRange(0, 0L, Long.MAX_VALUE), (byte)3) || this.oststream.containsState(new TickRange(0, 0L, Long.MAX_VALUE), (byte)2)) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addAlarm(Object key, Object alarmObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addAlarm", (Object)new Object[]{key, alarmObject});
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            Set<Object> alarms = null;
            if (pendingAlarms.containsKey(key)) {
                alarms = (Set)pendingAlarms.get(key);
            } else {
                alarms = new HashSet();
                pendingAlarms.put(key, alarms);
            }
            alarms.add(alarmObject);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeAlarm(Object key, Object alarmObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAlarm", (Object)new Object[]{key, alarmObject});
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            if (pendingAlarms.containsKey(key)) {
                ((Set)pendingAlarms.get(key)).remove(alarmObject);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Iterator getAlarms(Object key) {
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            if (pendingAlarms.containsKey(key)) {
                return ((Set)pendingAlarms.get(key)).iterator();
            }
            return new GTSIterator();
        }
    }

    @Override
    public void batchPrecommit(TransactionCommon currentTran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchPrecommit", (Object)currentTran);
        }
        try {
            this.persistCompletedPrefix(currentTran);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.batchPrecommit", (String)"1:1911:1.110", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchPrecommit");
        }
    }

    @Override
    public void batchCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchCommitted", (Object)this.messagesInBatch);
        }
        this.numberOfMessagesReceived += (long)this.messagesInBatch;
        this.messagesInBatch = 0;
        this.updateCompletedPrefix();
        this.sendAck();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    @Override
    public void batchRolledBack() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"batchRolledBack");
        }
        this.resetDoubtHorizon();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchRolledBack");
        }
    }

    @Override
    public long getCompletedPrefix() {
        return this.oststream.getCompletedPrefix();
    }

    public void setNextCompletedPrefix(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setNextCompletedPrefix", (Object)tick);
            SibTr.exit((TraceComponent)tc, (String)"setNextCompletedPrefix");
        }
        this.nextCompletedPrefix = tick;
    }

    public long getNextCompletedPrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextCompletedPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getNextCompletedPrefix", (Object)this.nextCompletedPrefix);
        }
        return this.nextCompletedPrefix;
    }

    private void sendAck() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendAck");
        }
        long completedPrefix = this.oststream.getCompletedPrefix();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("sendAck up to: " + completedPrefix));
            }
            this.upControl.sendAckMessage(this.streamSet.getRemoteMEUuid(), this.streamSet.getDestUuid(), this.streamSet.getBusUuid(), completedPrefix, this.priority, this.reliability, this.streamSet.getStreamID(), true);
            this._lastAckedTick = completedPrefix;
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.sendAck", (String)"1:2019:1.110", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String streamToString(String str) {
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            return this.getStateStream().stateString(str);
        }
    }

    @Override
    public long getLastKnownTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastKnownTick");
            SibTr.exit((TraceComponent)tc, (String)"getLastKnownTick", (Object)this.unknownHorizon);
        }
        return this.unknownHorizon;
    }

    @Override
    protected int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)this.priority);
        }
        return this.priority;
    }

    @Override
    protected Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReliability");
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    private void setStreamIsBlocked(boolean value, int blockingReason, Exception exception, JsDestinationAddress blockedAddress) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStreamIsBlocked", (Object)new Object[]{value, blockingReason, exception, blockedAddress});
        }
        this.unexpectedBlock = false;
        this.isStreamBlocked = value;
        this.streamBlockingAddress = blockedAddress;
        if (this.isStreamBlocked) {
            String blockingAddress = "NULL";
            if (blockedAddress != null) {
                String busName = blockedAddress.getBusName();
                SIBUuid8 meUuid = blockedAddress.getME();
                String meUuidStr = null;
                if (meUuid != null) {
                    meUuidStr = meUuid.toString();
                }
                blockingAddress = blockedAddress.getDestinationName();
                if (busName != null) {
                    blockingAddress = blockingAddress + ":" + busName;
                }
                if (meUuidStr != null) {
                    if (busName == null) {
                        blockingAddress = blockingAddress + ":";
                    }
                    blockingAddress = blockingAddress + ":" + meUuidStr;
                }
            }
            String reasonText = "NONE";
            if (exception == null) {
                switch (blockingReason) {
                    case 0: {
                        reasonText = "NOT_FOUND";
                        break;
                    }
                    case 2: {
                        reasonText = "SEND_NOT_ALLOWED";
                        break;
                    }
                    case 3: {
                        reasonText = "DESTINATION_FULL";
                    }
                }
            } else {
                reasonText = exception instanceof SINotAuthorizedException ? "NOT_AUTHORIZED" : exception.getClass().getSimpleName();
                this.unexpectedBlock = true;
            }
            String[] inserts = new String[]{reasonText, blockingAddress};
            this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_TARGET_STREAM_STATE, 1, inserts);
        } else {
            this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.BLOCKED_TARGET_STREAM_STATE, 2);
            this.linkBlockingTick = -1L;
            this.blockingCount = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStreamIsBlocked");
        }
    }

    private boolean isStreamBlocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isStreamBlocked");
            SibTr.exit((TraceComponent)tc, (String)"isStreamBlocked", (Object)new Object[]{this.isStreamBlocked, this.linkBlockingTick});
        }
        return this.isStreamBlocked;
    }

    private boolean isStreamBlockedUnexpectedly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isStreamBlockedUnexpectedly");
            SibTr.exit((TraceComponent)tc, (String)"isStreamBlockedUnexpectedly", (Object)this.unexpectedBlock);
        }
        return this.unexpectedBlock;
    }

    @Override
    public TargetStream.TargetStreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStreamState");
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    private boolean streamCanAcceptNewMessage(MessageItem msgItem, long valueTick) throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"streamCanAcceptNewMessage", (Object)new Object[]{msgItem, valueTick});
        }
        boolean allowSend = false;
        if (this.isStreamBlocked()) {
            if (valueTick <= this.valueHorizon) {
                allowSend = true;
            }
        } else {
            JsMessage msg = msgItem.getMessage();
            int blockingReason = this.deliverer.checkAbleToAcceptMessage(msg.getRoutingDestination());
            if (blockingReason != 1) {
                if (valueTick <= this.valueHorizon) {
                    allowSend = true;
                } else {
                    this.setStreamIsBlocked(true, blockingReason, null, msg.getRoutingDestination());
                    this.linkBlockingTick = valueTick;
                }
            } else {
                allowSend = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamCanAcceptNewMessage", (Object)allowSend);
        }
        return allowSend;
    }

    @Override
    public TargetStreamControl getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.targetStreamControl == null) {
            this.targetStreamControl = new TargetStreamControl(this.remoteEngineUUID, this, this.streamSet.getStreamID(), this.getReliability(), this.getPriority());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.targetStreamControl);
        }
        return this.targetStreamControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageItem> getAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<MessageItem> msgs = new LinkedList<MessageItem>();
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.oststream.setCursor(0L);
            TickRange tr = this.oststream.getNext();
            while (tr.endstamp < Long.MAX_VALUE) {
                if (tr.type == 3) {
                    msgs.add((MessageItem)tr.value);
                }
                tr = this.oststream.getNext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream", msgs);
        }
        return Collections.unmodifiableList(msgs);
    }

    @Override
    public long getNumberOfMessagesReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNumberOfMessagesReceived");
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)this.numberOfMessagesReceived);
        }
        return this.numberOfMessagesReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countAllMessagesOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long count = 0L;
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.oststream.setCursor(0L);
            TickRange tr = this.oststream.getNext();
            while (tr.endstamp < Long.MAX_VALUE) {
                if (tr.type == 3) {
                    ++count;
                }
                tr = this.oststream.getNext();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)count);
        }
        return count;
    }

    @Override
    public long getLastMsgReceivedTimestamp() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLastMsgReceivedTimestamp");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgReceivedTimestamp", (Object)this.timeLastMsgReceived);
        }
        return this.timeLastMsgReceived;
    }

    public String toString() {
        String text = super.toString() + " [";
        text = text + this.deliverer;
        if (this.streamSet != null) {
            text = text + this.streamSet.getStreamID();
        }
        text = text + this.remoteEngineUUID + "]";
        return text;
    }

    private static class GTSIterator
    implements Iterator {
        private GTSIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }

    class NRTExpiryHandle
    implements AlarmListener {
        RangeObject nackRange;
        int repeatCount;
        int nrtIteration;
        Alarm timer;
        Object parent;
        long lastNackReportedTime = 0L;
        long lastNackReported = -1L;

        NRTExpiryHandle(RangeObject nackRange, Object p) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"NRTExpiryHandle", (Object)new Object[]{nackRange, p});
            }
            this.nackRange = nackRange;
            this.repeatCount = 1;
            this.nrtIteration = 0;
            this.parent = p;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"NRTExpiryHandle", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object alarmContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)new Object[]{alarmContext, this.parent});
            }
            GuaranteedTargetStream.removeAlarm(this.parent, this);
            boolean foundRequestedTicks = false;
            long numTicksNacked = 0L;
            ++this.nrtIteration;
            if (this.nrtIteration == this.repeatCount) {
                numTicksNacked = this.checkCuriosityAndNack();
                if (numTicksNacked > 0L) {
                    foundRequestedTicks = true;
                }
                this.nrtIteration = 0;
                this.repeatCount = 2 * this.repeatCount;
                if (this.repeatCount * GDConfig.GD_NACK_REPETITION_THRESHOLD > GDConfig.GD_MAX_NACK_REPETITION_THRESHOLD) {
                    this.repeatCount = GDConfig.GD_MAX_NACK_REPETITION_THRESHOLD / GDConfig.GD_NACK_REPETITION_THRESHOLD;
                }
                if (foundRequestedTicks && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("repeatCount=" + this.repeatCount));
                }
            } else {
                foundRequestedTicks = this.checkCuriosity();
            }
            if (foundRequestedTicks) {
                this.timer = GuaranteedTargetStream.this.am.create(GDConfig.GD_NACK_REPETITION_THRESHOLD, this);
                GuaranteedTargetStream.addAlarm(this.parent, this);
            } else {
                Hashtable hashtable = pendingAlarms;
                synchronized (hashtable) {
                    if (!GuaranteedTargetStream.getAlarms(this).hasNext()) {
                        GuaranteedTargetStream.this.getControlAdapter().getHealthState().updateHealth(HealthStateListener.GAP_DETECTED_STATE, 2);
                    }
                    if (this.lastNackReported != -1L) {
                        GuaranteedTargetStream.this.deliverer.reportResolvedGap(GuaranteedTargetStream.this.remoteEngineUUID.toString(), this.lastNackReported);
                        this.lastNackReported = -1L;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)(" Gap filled from " + this.nackRange.startstamp + "," + this.nackRange.endstamp + "doubtHorizon=" + GuaranteedTargetStream.this.getDoubtHorizon()));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long checkCuriosityAndNack() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkCuriosityAndNack");
            }
            boolean foundRequested = false;
            long tickCount = 0L;
            ArrayList<Object> nackList = null;
            StateStream stateStream = GuaranteedTargetStream.this.oststream;
            synchronized (stateStream) {
                TickRange tr2;
                GuaranteedTargetStream.this.oststream.setCursor(this.nackRange.startstamp);
                TickRange tr1 = GuaranteedTargetStream.this.oststream.getNext();
                do {
                    if (tr1.type == 1) {
                        if (!foundRequested) {
                            foundRequested = true;
                            if (tr1.startstamp > this.nackRange.startstamp) {
                                this.nackRange.startstamp = tr1.startstamp;
                            }
                        }
                        if (nackList == null) {
                            nackList = new ArrayList<Object>();
                        }
                        nackList.add(tr1.clone());
                    }
                    tr2 = tr1;
                    tr1 = GuaranteedTargetStream.this.oststream.getNext();
                } while (tr1.startstamp <= this.nackRange.endstamp && tr1 != tr2);
            }
            if (nackList != null) {
                for (int j = 0; j < nackList.size(); ++j) {
                    TickRange temptr = (TickRange)nackList.get(j);
                    long nackstart = temptr.startstamp;
                    long nackend = temptr.endstamp;
                    if (nackstart < this.nackRange.startstamp) {
                        nackstart = this.nackRange.startstamp;
                    }
                    if (nackend > this.nackRange.endstamp) {
                        nackend = this.nackRange.endstamp;
                    }
                    if (nackstart > nackend) continue;
                    if (tickCount == 0L && GuaranteedTargetStream.this.mp.getCustomProperties().getNackLogInterval() > 0L) {
                        NRTExpiryHandle nRTExpiryHandle = this;
                        synchronized (nRTExpiryHandle) {
                            if (this.lastNackReportedTime == 0L) {
                                this.lastNackReportedTime = System.currentTimeMillis();
                            } else {
                                if (this.lastNackReported != -1L && this.lastNackReported != nackstart) {
                                    GuaranteedTargetStream.this.deliverer.reportResolvedGap(GuaranteedTargetStream.this.remoteEngineUUID.toString(), this.lastNackReported);
                                    this.lastNackReported = -1L;
                                }
                                if (System.currentTimeMillis() - this.lastNackReportedTime > GuaranteedTargetStream.this.mp.getCustomProperties().getNackLogInterval() * 1000L) {
                                    GuaranteedTargetStream.this.deliverer.reportUnresolvedGap(GuaranteedTargetStream.this.remoteEngineUUID.toString(), nackstart);
                                    this.lastNackReported = nackstart;
                                    this.lastNackReportedTime = System.currentTimeMillis();
                                }
                            }
                        }
                    }
                    tickCount += nackend - nackstart + 1L;
                    try {
                        GuaranteedTargetStream.this.upControl.sendNackMessage(GuaranteedTargetStream.this.streamSet.getRemoteMEUuid(), GuaranteedTargetStream.this.streamSet.getDestUuid(), GuaranteedTargetStream.this.streamSet.getBusUuid(), nackstart, nackend, GuaranteedTargetStream.this.priority, GuaranteedTargetStream.this.reliability, GuaranteedTargetStream.this.streamSet.getStreamID());
                        continue;
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.NRTExpiryHandle.checkCuriosityAndNack", (String)"1:1674:1.110", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.NRTExpiryHandle", "1:1681:1.110", e});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"checkCuriosityAndNack", (Object)((Object)e));
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.NRTExpiryHandle", "1:1692:1.110", e}, null), (Throwable)e);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkCuriosityAndNack", (Object)tickCount);
            }
            return tickCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkCuriosity() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkCuriosity");
            }
            boolean foundRequested = false;
            StateStream stateStream = GuaranteedTargetStream.this.oststream;
            synchronized (stateStream) {
                TickRange tr2;
                GuaranteedTargetStream.this.oststream.setCursor(this.nackRange.startstamp);
                TickRange tr1 = GuaranteedTargetStream.this.oststream.getNext();
                do {
                    if (tr1.type == 1 && !foundRequested) {
                        foundRequested = true;
                        if (tr1.startstamp <= this.nackRange.startstamp) break;
                        this.nackRange.startstamp = tr1.startstamp;
                        break;
                    }
                    tr2 = tr1;
                    tr1 = GuaranteedTargetStream.this.oststream.getNext();
                } while (tr1.startstamp <= this.nackRange.endstamp && tr1 != tr2);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkCuriosity", (Object)foundRequested);
            }
            return foundRequested;
        }
    }

    public static class GuaranteedTargetStreamState
    extends TargetStream.TargetStreamState {
        public static final GuaranteedTargetStreamState ACTIVE = new GuaranteedTargetStreamState("Active", 1);

        private GuaranteedTargetStreamState(String _name, int _id) {
            super(_name, _id);
        }
    }
}

