/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.QuerySyntaxException;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.IdentifierImpl;
import com.ibm.ws.sib.matchspace.selector.impl.InvalidXPathSyntaxException;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.MatchParserImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.tools.MatchParser;
import com.ibm.ws.sib.matchspace.tools.XPath10Parser;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceComponent;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

public class XPath10ParserImpl
implements XPath10Parser {
    private static final Class cclass = XPath10ParserImpl.class;
    private static Trace tc = TraceUtils.getTrace(XPath10ParserImpl.class, (String)"SIBMatchSpace");
    private static Matching matching = null;
    List selOperands = null;
    MatchParser predicateParser = null;
    NamespaceContext namespaceContext = null;
    int locationStep = 0;

    @Override
    public Selector parseWholeSelector(String selector) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "parseWholeSelector", (Object)("selector: " + selector));
        }
        IdentifierImpl ident = new IdentifierImpl(selector);
        ident.setFullName(selector);
        ident.setSelectorDomain(2);
        XPathExpression xpexp = null;
        try {
            XPath xpath0 = XPathFactory.newInstance().newXPath();
            if (this.namespaceContext != null) {
                xpath0.setNamespaceContext(this.namespaceContext);
            }
            xpexp = xpath0.compile(selector);
        }
        catch (Exception ex) {
            FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.XPath10ParserImpl", (Throwable)ex, (String)"1:143:1.16");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug((Object)this, cclass, "parseWholeSelector", (Object)ex);
            }
            ident.setType(2);
        }
        ident.setCompiledExpression(xpexp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "parseWholeSelector", (Object)ident);
        }
        return ident;
    }

    @Override
    public Selector getSelector(String selector) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getSelector", (Object)("selector: " + selector));
        }
        this.selOperands = new ArrayList();
        Object selectorTree = null;
        try {
            this.parseSelector(selector);
            Selector[] selectorArray = new Selector[this.selOperands.size()];
            this.selOperands.toArray(selectorArray);
            for (int i = selectorArray.length - 1; i >= 0; --i) {
                Selector parsedSelector = selectorArray[i];
                selectorTree = selectorTree == null ? parsedSelector : matching.createExtensionOperator(46, parsedSelector, (Selector)selectorTree);
            }
        }
        catch (InvalidXPathSyntaxException iex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug((Object)this, cclass, "getSelector", (Object)iex);
            }
            selectorTree = this.parseWholeSelector(selector);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getSelector", selectorTree);
        }
        return selectorTree;
    }

    private void parseSelector(String selector) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "parseSelector", (Object)("selector: " + selector));
        }
        this.locationStep = -1;
        int start = 0;
        int posWildCard = selector.indexOf("//", start);
        if (posWildCard >= 0) {
            this.locationStep = 0;
            this.selOperands.add(this.createIdentifierForWildExpression(selector));
            return;
        }
        int posSeparator = selector.indexOf("/", start);
        if (posSeparator == 0) {
            String step = selector.substring(start, start + 1);
            this.selOperands.add(this.createIdentifierForSubExpression(step, step, true, false));
            ++start;
        }
        int stepEnd = 0;
        while (stepEnd >= 0) {
            StepProperties stepProperties = new StepProperties();
            this.isolateNextStep(selector, start, stepProperties);
            stepEnd = stepProperties.endOfStep;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (stepEnd < 0) {
                    tc.debug((Object)this, cclass, "parsePredicate", (Object)("isolated Step: " + selector.substring(start) + " and wrapStep is " + stepProperties.wrapStep));
                } else {
                    tc.debug((Object)this, cclass, "parsePredicate", (Object)("isolated Step: " + selector.substring(start, stepEnd) + " and wrapStep is " + stepProperties.wrapStep));
                }
            }
            if (stepProperties.wrapStep) {
                if (stepEnd < 0) {
                    this.wrapLastLocationStep(selector, start, true);
                } else {
                    this.wrapLocationStep(selector, start, stepEnd);
                }
            } else if (stepEnd < 0) {
                this.parseLastLocationStep(selector, start);
            } else {
                this.parseLocationStep(selector, start, stepEnd);
            }
            if (stepEnd < 0) continue;
            start = stepEnd + 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "parseSelector");
        }
    }

    private void parseLocationStep(String selector, int start, int stepEnd) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "parseLocationStep", (Object)("selector: " + selector + ", start: " + start + ", end: " + stepEnd));
        }
        int stepStart = start;
        int posOpenBracket = selector.indexOf("[", start);
        if (posOpenBracket > stepEnd || posOpenBracket == -1) {
            posOpenBracket = -1;
            String step = selector.substring(start, stepEnd);
            String full = selector.substring(0, stepEnd);
            this.selOperands.add(this.createIdentifierForSubExpression(step, full, true, false));
        }
        int posCloseBracket = selector.indexOf("]", start);
        boolean wrapWholeStep = false;
        boolean foundPredicates = false;
        ArrayList<Selector> tempSelOperands = new ArrayList<Selector>();
        while (posOpenBracket >= 0) {
            String predicate;
            Selector parsedPredicate;
            foundPredicates = true;
            if (posCloseBracket < posOpenBracket) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "parseLocationStep", (Object)"bracket error");
                }
                InvalidXPathSyntaxException iex = new InvalidXPathSyntaxException(selector);
                FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.XPath10ParserImpl", (Throwable)iex, (String)"1:372:1.16");
                throw iex;
            }
            String full = selector.substring(0, posOpenBracket);
            if (start != posOpenBracket) {
                String step = selector.substring(start, posOpenBracket);
                tempSelOperands.add(this.createIdentifierForSubExpression(step, full, true, false));
            }
            if ((parsedPredicate = this.parsePredicate(predicate = selector.substring(posOpenBracket + 1, posCloseBracket), full)) == null) {
                wrapWholeStep = true;
                break;
            }
            if (!Matching.isSimple(parsedPredicate)) {
                wrapWholeStep = true;
                break;
            }
            parsedPredicate.setExtended();
            tempSelOperands.add(parsedPredicate);
            start = posCloseBracket + 1;
            posOpenBracket = selector.indexOf("[", start);
            posCloseBracket = selector.indexOf("]", start);
            if (posOpenBracket <= stepEnd && posOpenBracket != -1) continue;
            posOpenBracket = -1;
        }
        if (foundPredicates) {
            if (wrapWholeStep) {
                this.wrapLocationStep(selector, stepStart, stepEnd);
            } else {
                this.selOperands.addAll(tempSelOperands);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "parseLocationStep");
        }
    }

    private void parseLastLocationStep(String selector, int start) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "parseLastLocationStep", (Object)("selector: " + selector + ", start: " + start));
        }
        int stepStart = start;
        int stepEnd = selector.length();
        int posOpenBracket = selector.indexOf("[", start);
        String remnant = null;
        String fullRemnant = null;
        ++this.locationStep;
        if (posOpenBracket > stepEnd || posOpenBracket == -1) {
            posOpenBracket = -1;
            remnant = selector.substring(start, stepEnd);
            fullRemnant = selector.substring(0, stepEnd);
        }
        int posCloseBracket = selector.indexOf("]", start);
        boolean wrapWholeStep = false;
        boolean foundPredicates = false;
        ArrayList<Selector> tempSelOperands = new ArrayList<Selector>();
        while (posOpenBracket >= 0) {
            String predicate;
            Selector parsedPredicate;
            foundPredicates = true;
            if (posCloseBracket < posOpenBracket) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "parseLastLocationStep", (Object)"bracket error");
                }
                InvalidXPathSyntaxException iex = new InvalidXPathSyntaxException(selector);
                FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.XPath10ParserImpl", (Throwable)iex, (String)"1:497:1.16");
                throw iex;
            }
            String full = selector.substring(0, posOpenBracket);
            if (start != posOpenBracket) {
                String step = selector.substring(start, posOpenBracket);
                tempSelOperands.add(this.createIdentifierForSubExpression(step, full, false, false));
            }
            if ((parsedPredicate = this.parsePredicate(predicate = selector.substring(posOpenBracket + 1, posCloseBracket), full)) == null) {
                wrapWholeStep = true;
                break;
            }
            parsedPredicate.setExtended();
            tempSelOperands.add(parsedPredicate);
            start = posCloseBracket + 1;
            posOpenBracket = selector.indexOf("[", start);
            posCloseBracket = selector.indexOf("]", start);
            if (posOpenBracket <= stepEnd && posOpenBracket != -1) continue;
            posOpenBracket = -1;
            if (start >= stepEnd) continue;
            remnant = selector.substring(start, stepEnd);
            fullRemnant = selector.substring(0, stepEnd);
        }
        if (foundPredicates) {
            if (wrapWholeStep) {
                remnant = null;
                this.wrapLastLocationStep(selector, stepStart, false);
            } else {
                this.selOperands.addAll(tempSelOperands);
            }
        }
        if (remnant != null) {
            Selector parsedPredicate = this.parsePredicate(remnant, fullRemnant);
            if (parsedPredicate == null) {
                this.selOperands.add(this.createIdentifierForSubExpression(remnant, fullRemnant, false, true));
            } else {
                parsedPredicate.setExtended();
                this.selOperands.add(parsedPredicate);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "parseLastLocationStep");
        }
    }

    private IdentifierImpl createIdentifierForSubExpression(String subExpression, String fullExpression, boolean isLocationStep, boolean isLastStep) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "createIdentifierForSubExpression", (Object)("subExpression: " + subExpression + ", isLocStep: " + new Boolean(isLocationStep) + ", isLastStep: " + new Boolean(isLocationStep)));
        }
        IdentifierImpl stepIdentifier = new IdentifierImpl(subExpression);
        stepIdentifier.setFullName(fullExpression);
        if (isLocationStep) {
            ++this.locationStep;
        }
        this.setXPathCharacteristics(stepIdentifier);
        if (!isLastStep) {
            stepIdentifier.setType(-8);
        } else {
            stepIdentifier.setType(-6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "createIdentifierForSubExpression", (Object)stepIdentifier);
        }
        return stepIdentifier;
    }

    private IdentifierImpl createIdentifierForWildExpression(String selector) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "createIdentifierForWildExpression", (Object)("selector: " + selector));
        }
        IdentifierImpl wildIdentifier = new IdentifierImpl(selector);
        this.setXPathCharacteristics(wildIdentifier);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "createIdentifierForSubExpression", (Object)wildIdentifier);
        }
        return wildIdentifier;
    }

    private void setXPathCharacteristics(IdentifierImpl identifier) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "setXPathCharacteristics", (Object)("identifier: " + identifier));
        }
        identifier.setSelectorDomain(2);
        identifier.setStep(this.locationStep);
        XPathExpression xpexp = null;
        try {
            Object node = null;
            Object ns = null;
            XPath xpath0 = XPathFactory.newInstance().newXPath();
            if (this.namespaceContext != null) {
                xpath0.setNamespaceContext(this.namespaceContext);
            }
            xpexp = xpath0.compile(identifier.getName());
        }
        catch (Exception ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit((Object)this, cclass, "setXPathCharacteristics", (Object)ex);
            }
            throw new InvalidXPathSyntaxException(identifier.getName());
        }
        identifier.setCompiledExpression(xpexp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "setXPathCharacteristics");
        }
    }

    private Selector parsePredicate(String predicate, String fullPath) {
        Selector parsed;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry(cclass, "parsePredicate", (Object)("predicate: " + predicate));
            }
            parsed = null;
            try {
                String parserInput = this.preProcessForSpecials(predicate);
                this.predicateParser = MatchParserImpl.prime(this.predicateParser, parserInput, true);
                parsed = this.predicateParser.getSelector(parserInput);
                if (parsed.getType() == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        tc.debug((Object)this, cclass, "parsePredicate", (Object)"Unable to parse predicate");
                    }
                    parsed = null;
                } else {
                    this.postProcessSelectorTree(parsed, fullPath);
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                tc.debug((Object)this, cclass, "parsePredicate", (Object)ex);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "parsePredicate", parsed);
        }
        return parsed;
    }

    private String preProcessForSpecials(String predicate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "preProcessForSpecials", (Object)("predicate: " + predicate));
        }
        String processed = predicate;
        String replace = this.replaceSpecialsWithSub(predicate);
        if (replace != null) {
            processed = replace;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "preProcessForSpecials", (Object)processed);
        }
        return processed;
    }

    private void postProcessSelectorTree(Selector parsed, String fullPath) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "postProcessSelectorTree", (Object)("parsed: " + parsed + ", fullPath: " + fullPath));
        }
        if (parsed instanceof IdentifierImpl) {
            IdentifierImpl parsedIdentifier = (IdentifierImpl)parsed;
            String identName = parsedIdentifier.getName();
            String newIdentName = this.replaceSubForSpecials(identName);
            if (newIdentName != null) {
                parsedIdentifier.setName(newIdentName);
                parsedIdentifier.setFullName(fullPath + newIdentName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug((Object)this, cclass, "postProcessSelectorTree", (Object)("Identifier name has been reset to: " + ((IdentifierImpl)parsed).getName()));
                }
            } else {
                parsedIdentifier.setFullName(fullPath + identName);
            }
            this.setXPathCharacteristics((IdentifierImpl)parsed);
        } else if (parsed instanceof OperatorImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug((Object)this, cclass, "postProcessSelectorTree", (Object)(parsed + " is an OperatorImpl"));
            }
            parsed.setExtended();
            this.postProcessOperands((OperatorImpl)parsed, fullPath);
        } else if (parsed instanceof LiteralImpl) {
            String literalString;
            String newLiteralString;
            LiteralImpl literal;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug((Object)this, cclass, "postProcessSelectorTree", (Object)(parsed + " is an LiteralImpl"));
            }
            if ((literal = (LiteralImpl)parsed).getType() == -5 && (newLiteralString = this.replaceSubForSpecials(literalString = (String)literal.getValue())) != null) {
                ((LiteralImpl)parsed).value = newLiteralString;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug((Object)this, cclass, "postProcessSelectorTree", (Object)("Literal Value has been reset to: " + ((LiteralImpl)parsed).getValue()));
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            tc.debug((Object)this, cclass, "postProcessSelectorTree", (Object)("No post processing can be done on: " + parsed));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "postProcessSelectorTree");
        }
    }

    private void postProcessOperands(OperatorImpl opImpl, String fullPath) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "postProcessOperands", (Object)("opImpl: " + opImpl + ", fullPath: " + fullPath));
        }
        for (int i = 0; i < opImpl.operands.length; ++i) {
            Selector sel = opImpl.operands[i];
            this.postProcessSelectorTree(sel, fullPath);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "postProcessOperands");
        }
    }

    private String replaceSpecialsWithSub(String inString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "replaceSpecialsWithSub", (Object)("inString: " + inString));
        }
        String outString = null;
        StringBuffer sb = null;
        int posAmpersand = inString.indexOf("@");
        if (posAmpersand >= 0) {
            sb = new StringBuffer(inString);
        }
        while (posAmpersand >= 0) {
            sb.replace(posAmpersand, posAmpersand + 1, "_$AMP$_");
            int start = posAmpersand + 1;
            posAmpersand = sb.indexOf("@", start);
        }
        int posSlash = inString.indexOf("/");
        if (posSlash >= 0 && sb == null) {
            sb = new StringBuffer(inString);
        }
        while (posSlash >= 0) {
            sb.replace(posSlash, posSlash + 1, "_$SL$_");
            int start = posSlash + 1;
            posSlash = sb.indexOf("/", start);
        }
        int posDD = inString.indexOf("..");
        if (posDD >= 0 && sb == null) {
            sb = new StringBuffer(inString);
        }
        while (posDD >= 0) {
            sb.replace(posDD, posDD + 2, "_$DD$_");
            int start = posDD + 1;
            posDD = sb.indexOf("..", start);
        }
        int posSD = -1;
        if (sb != null) {
            posSD = sb.indexOf(".");
        } else {
            posSD = inString.indexOf(".");
            if (posSD >= 0) {
                sb = new StringBuffer(inString);
            }
        }
        while (posSD >= 0) {
            int start = posSD + 1;
            if (start < sb.length() && Character.isDigit(sb.charAt(posSD + 1))) {
                posSD = -1;
            } else if (posSD > 0 && Character.isDigit(sb.charAt(posSD - 1))) {
                posSD = -1;
            }
            if (posSD >= 0) {
                sb.replace(posSD, posSD + 1, "_$SD$_");
            }
            posSD = sb.indexOf(".", start);
        }
        if (sb != null) {
            outString = sb.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "replaceSpecialsWithSub", (Object)outString);
        }
        return outString;
    }

    private String replaceSubForSpecials(String inString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "replaceSubForSpecials", (Object)("inString: " + inString));
        }
        String outString = null;
        StringBuffer sb = null;
        int posAmpersand = inString.indexOf("_$AMP$_");
        if (posAmpersand >= 0) {
            sb = new StringBuffer(inString);
        }
        while (posAmpersand >= 0) {
            sb.replace(posAmpersand, posAmpersand + 7, "@");
            int start = posAmpersand + 1;
            posAmpersand = sb.indexOf("_$AMP$_", start);
        }
        int posSlash = inString.indexOf("_$SL$_");
        if (posSlash >= 0 && sb == null) {
            sb = new StringBuffer(inString);
        }
        while (posSlash >= 0) {
            sb.replace(posSlash, posSlash + 6, "/");
            int start = posSlash + 1;
            posSlash = sb.indexOf("_$SL$_", start);
        }
        int posDD = inString.indexOf("_$DD$_");
        if (posDD >= 0 && sb == null) {
            sb = new StringBuffer(inString);
        }
        while (posDD >= 0) {
            sb.replace(posDD, posDD + 6, "..");
            int start = posDD + 2;
            posDD = sb.indexOf("_$DD$_", start);
        }
        int posSD = inString.indexOf("_$SD$_");
        if (posSD >= 0 && sb == null) {
            sb = new StringBuffer(inString);
        }
        while (posSD >= 0) {
            sb.replace(posSD, posSD + 6, ".");
            int start = posSD + 1;
            posSD = sb.indexOf("_$SD$_", start);
        }
        if (sb != null) {
            outString = sb.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "replaceSubForSpecials", (Object)outString);
        }
        return outString;
    }

    private void isolateNextStep(String selector, int start, StepProperties stepProperties) {
        boolean wrapWholeStep;
        int end;
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.entry(cclass, "isolateNextStep", (Object)("selector: " + selector + ", start: " + start));
            }
            end = -1;
            wrapWholeStep = false;
            String subSelector = selector.substring(start);
            char[] chars = subSelector.toCharArray();
            boolean acceptDot = false;
            boolean acceptStar = true;
            boolean acceptOrdinary = true;
            boolean prevSeparator = true;
            boolean acceptOpenBracket = true;
            boolean acceptCloseBracket = false;
            int openBracketCount = 0;
            boolean acceptOpenRoundBracket = false;
            boolean acceptCloseRoundBracket = false;
            int openRoundBracketCount = 0;
            boolean maybeIntegerPredicate = false;
            try {
                int subSelectorLength = chars.length;
                for (int i = 0; i < subSelectorLength; ++i) {
                    char cand = chars[i];
                    if (openBracketCount > 0 && maybeIntegerPredicate && !Character.isDigit(cand) && cand != ']') {
                        maybeIntegerPredicate = false;
                    }
                    if (cand == '*') {
                        if (acceptStar) {
                            wrapWholeStep = true;
                            acceptStar = false;
                            acceptDot = false;
                            prevSeparator = false;
                            continue;
                        }
                        throw new QuerySyntaxException("Wilcard error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (cand == '.') {
                        if (acceptDot) {
                            acceptOrdinary = !prevSeparator;
                            prevSeparator = false;
                            acceptStar = false;
                            continue;
                        }
                        throw new QuerySyntaxException("Dot error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (cand == '/') {
                        if (openBracketCount == 0 && openRoundBracketCount == 0) {
                            end = i;
                            break;
                        }
                        acceptStar = true;
                        acceptOrdinary = true;
                        acceptDot = true;
                        prevSeparator = true;
                        continue;
                    }
                    if (cand == '[') {
                        if (acceptOpenBracket) {
                            acceptStar = true;
                            acceptOrdinary = true;
                            prevSeparator = false;
                            acceptDot = true;
                            if (++openBracketCount > 1) {
                                wrapWholeStep = true;
                            }
                            acceptCloseBracket = true;
                            acceptOpenRoundBracket = true;
                            maybeIntegerPredicate = true;
                            continue;
                        }
                        throw new QuerySyntaxException("Open Bracket error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (cand == ']') {
                        if (acceptCloseBracket) {
                            acceptStar = true;
                            acceptOrdinary = true;
                            prevSeparator = false;
                            acceptDot = true;
                            acceptOpenBracket = true;
                            if (--openBracketCount < 0) {
                                throw new QuerySyntaxException("Bracket error: " + subSelector + ", at: " + (i + 1));
                            }
                            if (!maybeIntegerPredicate) continue;
                            maybeIntegerPredicate = false;
                            wrapWholeStep = true;
                            continue;
                        }
                        throw new QuerySyntaxException("Close Bracket error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (cand == '(') {
                        if (acceptOpenRoundBracket) {
                            wrapWholeStep = true;
                            acceptStar = true;
                            acceptOrdinary = true;
                            prevSeparator = false;
                            acceptDot = true;
                            acceptOpenRoundBracket = false;
                            acceptCloseRoundBracket = true;
                            ++openRoundBracketCount;
                            continue;
                        }
                        throw new QuerySyntaxException("Open Round Bracket error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (cand == ')') {
                        if (acceptCloseRoundBracket) {
                            acceptStar = true;
                            acceptOrdinary = true;
                            prevSeparator = false;
                            acceptDot = true;
                            acceptOpenRoundBracket = true;
                            acceptCloseRoundBracket = false;
                            --openRoundBracketCount;
                            continue;
                        }
                        throw new QuerySyntaxException("Close Round Bracket error: " + subSelector + ", at: " + (i + 1));
                    }
                    if (acceptOrdinary) {
                        acceptStar = true;
                        prevSeparator = false;
                        acceptDot = true;
                        acceptOpenRoundBracket = true;
                        continue;
                    }
                    throw new QuerySyntaxException("Character error: " + subSelector + ", at: " + (i + 1));
                }
                if (openBracketCount != 0) {
                    throw new QuerySyntaxException("Matching Bracket error: " + subSelector + ", non-matching square brackets");
                }
            }
            catch (QuerySyntaxException qex) {
                FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.XPath10ParserImpl", (Throwable)qex, (String)"1:1377:1.16");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                tc.debug((Object)this, cclass, "isolateNextStep", (Object)qex);
            }
        }
        stepProperties.wrapStep = wrapWholeStep;
        stepProperties.endOfStep = end == -1 ? -1 : end + start;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "isolateNextStep");
        }
    }

    private void wrapLocationStep(String selector, int start, int stepEnd) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "wrapLocationStep", (Object)("selector: " + selector + ", start: " + start + ", stepEnd: " + stepEnd));
        }
        String step = selector.substring(start, stepEnd);
        String full = selector.substring(0, stepEnd);
        this.selOperands.add(this.createIdentifierForSubExpression(step, full, true, false));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "wrapLocationStep");
        }
    }

    private void wrapLastLocationStep(String selector, int start, boolean bumpLocationStep) throws InvalidXPathSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "wrapLastLocationStep", (Object)("selector: " + selector + ", start: " + start + ", bumpLocationStep: " + new Boolean(bumpLocationStep)));
        }
        int stepEnd = selector.length();
        String step = selector.substring(start, stepEnd);
        String full = selector.substring(0, stepEnd);
        this.selOperands.add(this.createIdentifierForSubExpression(step, full, bumpLocationStep, true));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "wrapLastLocationStep");
        }
    }

    @Override
    public void setMatching(Matching matching) {
        XPath10ParserImpl.matching = matching;
    }

    @Override
    public void setNamespaceMappings(Map namespaceMappings) {
        this.namespaceContext = namespaceMappings != null ? new XPathNamespaceContext(namespaceMappings) : null;
    }

    public static class XPathNamespaceContext
    implements NamespaceContext {
        Map prefixMap = null;

        public XPathNamespaceContext(Map namespaceMappings) {
            this.prefixMap = namespaceMappings;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (this.prefixMap != null) {
                String namespace = (String)this.prefixMap.get(prefix);
                if (namespace != null) {
                    return namespace;
                }
                return "";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }

    private class StepProperties {
        int endOfStep;
        boolean wrapStep;

        private StepProperties() {
        }

        public String toString() {
            String asString = "End of step is " + this.endOfStep + " and wrapStep is " + this.wrapStep;
            return asString;
        }
    }
}

