/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.tools.Evaluator;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class EvaluatorImpl
implements Evaluator {
    private static Trace tc = TraceUtils.getTrace(EvaluatorImpl.class, (String)"SIBMatchSpace");
    private static final Class cclass = EvaluatorImpl.class;
    private static final Boolean[][] andTable = new Boolean[][]{{Boolean.TRUE, Boolean.FALSE, null}, {Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}, {null, Boolean.FALSE, null}};
    private static final Boolean[][] orTable = new Boolean[][]{{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, {Boolean.TRUE, Boolean.FALSE, null}, {Boolean.TRUE, null, null}};
    private static final int BYTE = -2;
    private static final int SHORT = -1;
    private static final int INT = 0;
    private static final int LONG = 1;
    private static final int FLOAT = 2;
    private static final int DOUBLE = 3;

    @Override
    public Object eval(Selector sel, MatchSpaceKey msg, EvalCache cache, Object contextValue, boolean permissive) throws BadMessageFormatMatchingException {
        Object ans;
        if (sel.getType() == 2) {
            throw new IllegalArgumentException();
        }
        if (sel.getUniqueId() != 0 && !sel.isExtended() && (ans = cache.getExprValue(sel.getUniqueId())) != null) {
            return ans;
        }
        ans = this.evalInternal(sel, msg, cache, contextValue, permissive);
        if (sel.getUniqueId() != 0) {
            cache.saveExprValue(sel.getUniqueId(), ans);
        }
        return ans;
    }

    @Override
    public Object eval(Selector sel) {
        try {
            return this.eval(sel, MatchSpaceKey.DUMMY, EvalCache.DUMMY, null, false);
        }
        catch (BadMessageFormatMatchingException e) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.Evaluator.eval", (Throwable)e, (String)"1:145:1.28");
            throw new IllegalStateException();
        }
    }

    private Object evalInternal(Selector sel, MatchSpaceKey bind, EvalCache cache, Object contextValue, boolean permissive) throws BadMessageFormatMatchingException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "evalInternal", new Object[]{sel, bind, cache, contextValue, new Boolean(permissive)});
        }
        Object theReturn = null;
        if (sel instanceof Literal) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug(cclass, "Selector is a literal");
            }
            theReturn = ((Literal)sel).getValue();
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "evalInternal", theReturn);
            }
            return theReturn;
        }
        if (sel instanceof Identifier) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug(cclass, "Selector is an Identifier");
            }
            Identifier id = (Identifier)sel;
            if (permissive && id.getType() != 0) {
                Object idVal;
                boolean returnList = true;
                if (id.getType() == -6) {
                    returnList = false;
                }
                if ((idVal = bind.getIdentifierValue(id, true, contextValue, returnList)) == null) {
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "evalInternal", null);
                    }
                    return null;
                }
                switch (id.getType()) {
                    case 1: {
                        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            tc.debug(cclass, "Selector type is numeric");
                        }
                        if (idVal instanceof Number) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "evalInternal", idVal);
                            }
                            return idVal;
                        }
                        theReturn = idVal instanceof ArrayList ? this.castToNumberList((ArrayList)idVal) : EvaluatorImpl.castToNumber(idVal);
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "evalInternal", theReturn);
                        }
                        return theReturn;
                    }
                    case -5: {
                        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            tc.debug(cclass, "Selector type is string");
                        }
                        if (idVal instanceof String) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "evalInternal", idVal);
                            }
                            return idVal;
                        }
                        theReturn = idVal instanceof ArrayList ? this.castToStringList((ArrayList)idVal) : idVal.toString();
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "evalInternal", theReturn);
                        }
                        return theReturn;
                    }
                    case -6: {
                        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            tc.debug(cclass, "Selector type is boolean");
                        }
                        if (idVal instanceof Boolean) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "evalInternal", idVal);
                            }
                            return idVal;
                        }
                        theReturn = EvaluatorImpl.castToBoolean(idVal);
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "evalInternal", theReturn);
                        }
                        return theReturn;
                    }
                }
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is default");
                }
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", null);
                }
                return null;
            }
            boolean returnList = true;
            if (id.getType() == -6) {
                returnList = false;
            }
            theReturn = bind.getIdentifierValue(id, false, contextValue, returnList);
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "evalInternal", theReturn);
            }
            return theReturn;
        }
        Operator op = (Operator)sel;
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            tc.debug(cclass, "Selector is an operator");
        }
        Object val0 = this.eval(op.getOperands()[0], bind, cache, contextValue, permissive);
        Object val1 = op.getOperands().length == 1 ? null : this.eval(op.getOperands()[1], bind, cache, contextValue, permissive);
        switch (op.getOp()) {
            case 1: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is NOT");
                }
                if (val0 instanceof Boolean) {
                    theReturn = EvaluatorImpl.not((Boolean)val0);
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "evalInternal", theReturn);
                    }
                    return theReturn;
                }
                if (permissive && val0 != null) {
                    theReturn = EvaluatorImpl.not(EvaluatorImpl.castToBoolean(val0));
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "evalInternal", theReturn);
                    }
                    return theReturn;
                }
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", null);
                }
                return null;
            }
            case 2: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is NEG");
                }
                if (!(val0 instanceof Number)) {
                    if (permissive && val0 != null) {
                        if ((val0 = EvaluatorImpl.castToNumber(val0)) == null) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "evalInternal", null);
                            }
                            return null;
                        }
                    } else {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "evalInternal", null);
                        }
                        return null;
                    }
                }
                return EvaluatorImpl.neg((Number)val0);
            }
            case 3: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type ISNULL");
                }
                theReturn = val0 == null;
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 4: 
            case 5: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is LIKE");
                }
                if (!(val0 instanceof String)) {
                    if (permissive && val0 != null) {
                        val0 = val0.toString();
                    } else {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "evalInternal", null);
                        }
                        return null;
                    }
                }
                theReturn = ((LikeOperatorImpl)op).getInternalPattern().match((String)val0);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 40: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is NE");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, false) : EvaluatorImpl.not(EvaluatorImpl.compare(val0, val1, false, permissive));
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 45: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is EQ");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, true) : EvaluatorImpl.compare(val0, val1, false, permissive);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 41: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is GT");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, true) : EvaluatorImpl.compare(val1, val0, true, permissive);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 42: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is LT");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, true) : EvaluatorImpl.compare(val0, val1, true, permissive);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 43: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is GE");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, false) : EvaluatorImpl.not(EvaluatorImpl.compare(val0, val1, true, permissive));
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 44: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is LE");
                }
                theReturn = val0 instanceof ArrayList ? this.compareList((ArrayList)val0, val1, false, permissive, false) : EvaluatorImpl.not(EvaluatorImpl.compare(val1, val0, true, permissive));
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is ARITHMETIC");
                }
                theReturn = EvaluatorImpl.promoteAndEvaluate(op.getOp(), val0, val1, permissive);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
            case 46: 
            case 47: {
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Selector type is ANDOR");
                }
                if (!(val0 instanceof Boolean) && permissive && val0 != null) {
                    val0 = EvaluatorImpl.castToBoolean(val0);
                }
                if (!(val1 instanceof Boolean) && permissive && val1 != null) {
                    val1 = EvaluatorImpl.castToBoolean(val1);
                }
                theReturn = op.getOp() == 46 ? EvaluatorImpl.and((Boolean)val0, (Boolean)val1) : EvaluatorImpl.or((Boolean)val0, (Boolean)val1);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "evalInternal", theReturn);
                }
                return theReturn;
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            tc.debug(cclass, "Selector type is DEFAULT");
        }
        throw new IllegalStateException();
    }

    /*
     * Loose catch block
     */
    public static Number castToNumber(Object val) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "castToNumber", val);
        }
        if (!(val instanceof String)) {
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "castToNumber", null);
            }
            return null;
        }
        String stringVal = (String)val;
        if (stringVal.length() == 0) {
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "castToNumber", null);
            }
            return null;
        }
        switch (stringVal.charAt(stringVal.length() - 1)) {
            case 'L': 
            case 'l': {
                stringVal = stringVal.substring(0, stringVal.length() - 1);
                Long theLong = new Long(stringVal);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "castToNumber", (Object)theLong);
                }
                return theLong;
            }
            case 'F': 
            case 'f': {
                Float theFloat = new Float(stringVal);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "castToNumber", (Object)theFloat);
                }
                return theFloat;
            }
            case 'D': 
            case 'd': {
                Double theDouble = new Double(stringVal);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "castToNumber", (Object)theDouble);
                }
                return theDouble;
            }
        }
        {
            catch (NumberFormatException e) {
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "castToNumber", null);
                }
                return null;
            }
        }
        try {
            Long theLong = new Long(stringVal);
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "castToNumber", (Object)theLong);
            }
            return theLong;
        }
        catch (NumberFormatException e) {
            Double theDouble = new Double(stringVal);
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "castToNumber", (Object)theDouble);
            }
            return theDouble;
        }
    }

    private static Boolean castToBoolean(Object val) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "castToBoolean", val);
        }
        Boolean theReturn = null;
        if (val instanceof String) {
            String stringVal = (String)val;
            if (stringVal.equalsIgnoreCase("true")) {
                theReturn = Boolean.TRUE;
            } else if (stringVal.equalsIgnoreCase("false")) {
                theReturn = Boolean.FALSE;
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "castToBoolean", (Object)theReturn);
        }
        return theReturn;
    }

    @Override
    public ArrayList castToNumberList(ArrayList childNodeList) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "castToNumberList", (Object)childNodeList);
        }
        ArrayList<Number> numberList = new ArrayList<Number>();
        if (childNodeList != null) {
            Iterator iterNode = childNodeList.iterator();
            while (iterNode.hasNext()) {
                String strValue = this.getStringFromNode(iterNode.next());
                Number num = EvaluatorImpl.castToNumber(strValue);
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Add number to list: ", (Object)num);
                }
                numberList.add(num);
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "castToNumberList", numberList);
        }
        return numberList;
    }

    @Override
    public ArrayList castToStringList(ArrayList childNodeList) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "castToStringList", (Object)childNodeList);
        }
        ArrayList<String> stringList = new ArrayList<String>();
        if (childNodeList != null) {
            Iterator iterNode = childNodeList.iterator();
            while (iterNode.hasNext()) {
                String strValue = this.getStringFromNode(iterNode.next());
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "Add string to list: ", (Object)strValue);
                }
                stringList.add(strValue);
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "castToStringList", stringList);
        }
        return stringList;
    }

    protected String getStringFromNode(Object inNode) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getStringFromNode", inNode);
        }
        String strValue = null;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "getStringFromNode", strValue);
        }
        return strValue;
    }

    @Override
    public String getNodeText(Object inNode) {
        return null;
    }

    @Override
    public Object getDocumentRoot(MatchSpaceKey msg) throws BadMessageFormatMatchingException {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getDocumentRoot", (Object)msg);
        }
        Object docRoot = null;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "getDocumentRoot", docRoot);
        }
        return docRoot;
    }

    protected Boolean compareList(ArrayList firstList, Object val1, boolean lessThan, boolean permissive, boolean overallTrue) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "compareList", new Object[]{firstList, val1, new Boolean(lessThan), new Boolean(permissive), new Boolean(overallTrue)});
        }
        Boolean finalReturn = null;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "compareList", finalReturn);
        }
        return finalReturn;
    }

    protected static Boolean compare(Object val0, Object val1, boolean lessThan, boolean permissive) {
        int ans1;
        int ans0;
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "compare", new Object[]{val0, val1, new Boolean(lessThan), new Boolean(permissive)});
        }
        Boolean theReturn = null;
        int n = val0 instanceof Number ? 0 : (val0 instanceof Boolean ? 1 : (val0 instanceof String ? 2 : (ans0 = val0 instanceof Serializable ? 3 : 4)));
        int n2 = val1 instanceof Number ? 0 : (val1 instanceof Boolean ? 1 : (val1 instanceof String ? 2 : (ans1 = val1 instanceof Serializable ? 3 : 4)));
        if (ans0 > 3 || ans1 > 3) {
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "compare", null);
            }
            return null;
        }
        int category = ans0 * 4 + ans1;
        if (permissive) {
            switch (category) {
                case 0: 
                case 5: 
                case 10: 
                case 15: {
                    break;
                }
                case 2: {
                    val1 = EvaluatorImpl.castToNumber(val1);
                    if (val1 == null) {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compare", null);
                        }
                        return null;
                    }
                    category = 0;
                    break;
                }
                case 6: {
                    val1 = EvaluatorImpl.castToBoolean(val1);
                    if (val1 == null) {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compare", null);
                        }
                        return null;
                    }
                    category = 5;
                    break;
                }
                case 8: {
                    val0 = EvaluatorImpl.castToNumber(val0);
                    if (val0 == null) {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compare", null);
                        }
                        return null;
                    }
                    category = 0;
                    break;
                }
                case 9: {
                    val0 = EvaluatorImpl.castToBoolean(val0);
                    if (val0 == null) {
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compare", null);
                        }
                        return null;
                    }
                    category = 4;
                    break;
                }
                default: {
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "compare", null);
                    }
                    return null;
                }
            }
        }
        switch (category) {
            case 0: {
                int comp = EvaluatorImpl.compare((Number)val0, (Number)val1);
                theReturn = lessThan ? Boolean.valueOf(comp < 0) : Boolean.valueOf(comp == 0);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "compare", (Object)theReturn);
                }
                return theReturn;
            }
            case 5: 
            case 10: {
                if (lessThan) {
                    if (permissive) {
                        if ((val1 = EvaluatorImpl.castToNumber(val1)) == null) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "compare", null);
                            }
                            return null;
                        }
                        if ((val0 = EvaluatorImpl.castToNumber(val0)) == null) {
                            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                tc.exit(cclass, "compare", null);
                            }
                            return null;
                        }
                        int comp2 = EvaluatorImpl.compare((Number)val0, (Number)val1);
                        theReturn = comp2 < 0;
                        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            tc.exit(cclass, "compare", (Object)theReturn);
                        }
                        return theReturn;
                    }
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "compare", null);
                    }
                    return null;
                }
            }
            case 15: {
                if (lessThan) {
                    if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        tc.exit(cclass, "compare", null);
                    }
                    return null;
                }
                theReturn = val0.equals(val1);
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "compare", (Object)theReturn);
                }
                return theReturn;
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "compare", null);
        }
        return null;
    }

    private static Object promoteAndEvaluate(int op, Object val0, Object val1, boolean permissive) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "promoteAndEvaluate", new Object[]{new Integer(op), val0, val1, new Boolean(permissive)});
        }
        Object theReturn = null;
        theReturn = val0 instanceof ArrayList ? EvaluatorImpl.promoteAndEvaluateList(op, val0, val1, permissive) : EvaluatorImpl.promoteAndEvaluateScalar(op, val0, val1, permissive);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "promoteAndEvaluate", theReturn);
        }
        return theReturn;
    }

    private static Object promoteAndEvaluateScalar(int op, Object val0, Object val1, boolean permissive) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "promoteAndEvaluateScalar", new Object[]{new Integer(op), val0, val1, new Boolean(permissive)});
        }
        Number theReturn = null;
        if (!(val0 instanceof Number)) {
            if (permissive && val0 != null) {
                val0 = EvaluatorImpl.castToNumber(val0);
            } else {
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "promoteAndEvaluateScalar", null);
                }
                return null;
            }
        }
        if (!(val1 instanceof Number)) {
            if (permissive && val1 != null) {
                val1 = EvaluatorImpl.castToNumber(val1);
            } else {
                if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    tc.exit(cclass, "promoteAndEvaluateScalar", null);
                }
                return null;
            }
        }
        if (val0 == null || val1 == null) {
            if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                tc.exit(cclass, "promoteAndEvaluateScalar", null);
            }
            return null;
        }
        switch (op) {
            case 48: {
                theReturn = EvaluatorImpl.plus((Number)val0, (Number)val1);
                break;
            }
            case 49: {
                theReturn = EvaluatorImpl.minus((Number)val0, (Number)val1);
                break;
            }
            case 50: {
                theReturn = EvaluatorImpl.times((Number)val0, (Number)val1);
                break;
            }
            case 51: {
                theReturn = EvaluatorImpl.div((Number)val0, (Number)val1);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "promoteAndEvaluateScalar", (Object)theReturn);
        }
        return theReturn;
    }

    private static Object promoteAndEvaluateList(int op, Object val0, Object val1, boolean permissive) {
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "promoteAndEvaluateScalar", new Object[]{new Integer(op), val0, val1, new Boolean(permissive)});
        }
        Object numVal0 = ((ArrayList)val0).get(0);
        Object numVal1 = ((ArrayList)val1).get(0);
        Object theReturn = EvaluatorImpl.promoteAndEvaluateScalar(op, numVal0, numVal1, permissive);
        if (tc.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit(cclass, "promoteAndEvaluateScalar", theReturn);
        }
        return theReturn;
    }

    public static int ttIndex(Boolean bVal) {
        int idx = 2;
        if (bVal != null) {
            if (bVal.booleanValue()) {
                idx = 0;
            } else if (!bVal.booleanValue()) {
                idx = 1;
            }
        }
        return idx;
    }

    public static Boolean and(Boolean a, Boolean b) {
        return andTable[EvaluatorImpl.ttIndex(a)][EvaluatorImpl.ttIndex(b)];
    }

    public static Boolean or(Boolean a, Boolean b) {
        return orTable[EvaluatorImpl.ttIndex(a)][EvaluatorImpl.ttIndex(b)];
    }

    public static Boolean not(Boolean bVal) {
        if (bVal == null) {
            return null;
        }
        if (bVal.equals(Boolean.TRUE)) {
            return Boolean.FALSE;
        }
        if (bVal.equals(Boolean.FALSE)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static int compare(Number a, Number b) {
        int bType;
        int aType = EvaluatorImpl.getType(a);
        int compType = aType >= (bType = EvaluatorImpl.getType(b)) ? aType : bType;
        switch (compType) {
            case 0: {
                int li = a.intValue();
                int ri = b.intValue();
                return li < ri ? -1 : (li == ri ? 0 : 1);
            }
            case 1: {
                long ll = a.longValue();
                long rl = b.longValue();
                return ll < rl ? -1 : (ll == rl ? 0 : 1);
            }
            case 2: {
                float lf = a.floatValue();
                float rf = b.floatValue();
                return lf < rf ? -1 : (lf == rf ? 0 : 1);
            }
            case 3: {
                double ld = a.doubleValue();
                double rd = b.doubleValue();
                return ld < rd ? -1 : (ld == rd ? 0 : 1);
            }
        }
        throw new IllegalStateException();
    }

    public static int getType(Number val) {
        if (val instanceof Integer) {
            return 0;
        }
        if (val instanceof Long) {
            return 1;
        }
        if (val instanceof Short) {
            return -1;
        }
        if (val instanceof Byte) {
            return -2;
        }
        if (val instanceof Double) {
            return 3;
        }
        if (val instanceof Float) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static Number neg(Number n) {
        switch (EvaluatorImpl.getType(n)) {
            case 0: {
                return new Integer(-n.intValue());
            }
            case 1: {
                return new Long(-n.longValue());
            }
            case 2: {
                return new Float(-n.floatValue());
            }
            case 3: {
                return new Double(-n.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number plus(Number a, Number b) {
        int bType;
        int aType = EvaluatorImpl.getType(a);
        int compType = aType >= (bType = EvaluatorImpl.getType(b)) ? aType : bType;
        switch (compType) {
            case 0: {
                return new Integer(a.intValue() + b.intValue());
            }
            case 1: {
                return new Long(a.longValue() + b.longValue());
            }
            case 2: {
                return new Float(a.floatValue() + b.floatValue());
            }
            case 3: {
                return new Double(a.doubleValue() + b.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number times(Number a, Number b) {
        int bType;
        int aType = EvaluatorImpl.getType(a);
        int compType = aType >= (bType = EvaluatorImpl.getType(b)) ? aType : bType;
        switch (compType) {
            case 0: {
                return new Integer(a.intValue() * b.intValue());
            }
            case 1: {
                return new Long(a.longValue() * b.longValue());
            }
            case 2: {
                return new Float(a.floatValue() * b.floatValue());
            }
            case 3: {
                return new Double(a.doubleValue() * b.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number minus(Number a, Number b) {
        int bType;
        int aType = EvaluatorImpl.getType(a);
        int compType = aType >= (bType = EvaluatorImpl.getType(b)) ? aType : bType;
        switch (compType) {
            case 0: {
                return new Integer(a.intValue() - b.intValue());
            }
            case 1: {
                return new Long(a.longValue() - b.longValue());
            }
            case 2: {
                return new Float(a.floatValue() - b.floatValue());
            }
            case 3: {
                return new Double(a.doubleValue() - b.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number div(Number a, Number b) {
        int bType;
        int aType = EvaluatorImpl.getType(a);
        int compType = aType >= (bType = EvaluatorImpl.getType(b)) ? aType : bType;
        switch (compType) {
            case 0: {
                return new Integer(a.intValue() / b.intValue());
            }
            case 1: {
                return new Long(a.longValue() / b.longValue());
            }
            case 2: {
                return new Float(a.floatValue() / b.floatValue());
            }
            case 3: {
                return new Double(a.doubleValue() / b.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    public static int hash(Object val) {
        int hash;
        if (val instanceof Number) {
            long basis;
            if (EvaluatorImpl.getType((Number)val) > 1) {
                double doubleVal = ((Number)val).doubleValue();
                if (doubleVal != (double)(basis = (long)doubleVal)) {
                    basis = Double.doubleToLongBits(doubleVal);
                }
            } else {
                basis = ((Number)val).longValue();
            }
            hash = (int)(basis ^ basis >> 32);
        } else {
            hash = val.hashCode();
        }
        return hash;
    }

    public static boolean equals(Object a, Object b) {
        if (a instanceof Number) {
            if (b instanceof Number) {
                return EvaluatorImpl.compare((Number)a, (Number)b) == 0;
            }
            return false;
        }
        return a.equals(b);
    }
}

