/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchTarget;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.InternTable;
import com.ibm.ws.sib.matchspace.impl.PatternWrapper;
import com.ibm.ws.sib.matchspace.impl.StringMatcher;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class PartialMatch {
    private static final Class cclass = PartialMatch.class;
    private static Trace tc = TraceUtils.getTrace(PartialMatch.class, (String)"SIBMatchSpace");
    PartialMatch next;
    StringMatcher owner;
    char[] key;
    ContentMatcher singleMatchManyChild;
    protected List matchManyChildren;
    PartialMatch suffix;
    PartialMatch matchOneChild;
    ContentMatcher exactChild;

    PartialMatch(StringMatcher owner) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "PartialMatch", (Object)("owner: " + owner));
        }
        this.key = new char[0];
        this.owner = owner;
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "PartialMatch");
        }
    }

    PartialMatch newPartialMatch() {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "newPartialMatch");
        }
        PartialMatch ans = new PartialMatch(this.owner);
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "newPartialMatch", (Object)ans);
        }
        return ans;
    }

    PartialMatch(char[] key, PartialMatch next, StringMatcher owner) {
        if (tc.isEntryEnabled()) {
            tc.entry(cclass, "PartialMatch", (Object)("key: " + new String(key) + " next: " + next + " owner: " + owner));
        }
        this.key = key;
        this.next = next;
        this.owner = owner;
        if (tc.isEntryEnabled()) {
            tc.exit(cclass, "PartialMatch", (Object)this);
        }
    }

    PartialMatch newPartialMatch(char[] key, PartialMatch pm) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "newPartialMatch", (Object)("key: " + new String(key) + ", pm:" + pm));
        }
        PartialMatch ans = new PartialMatch(key, pm, this.owner);
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "newPartialMatch", (Object)ans);
        }
        return ans;
    }

    PartialMatch findOrCreate(char[] key) {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "findOrCreate", (Object)("key: " + new String(key)));
        }
        PartialMatch pm = this;
        while (true) {
            if (Arrays.equals(key, pm.key)) {
                if (tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "findOrCreate", (Object)("pm: " + pm));
                }
                return pm;
            }
            if (pm.next == null || pm.next.key.length > key.length) {
                pm.next = this.newPartialMatch(key, pm.next);
                if (tc.isEntryEnabled()) {
                    tc.exit((Object)this, cclass, "findOrCreate", (Object)("pm.next: " + pm.next));
                }
                return pm.next;
            }
            pm = pm.next;
        }
    }

    void cleanChain() {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "cleanChain");
        }
        PartialMatch p = this;
        while (p.next != null) {
            if (p.next.isEmpty()) {
                p.next = p.next.next;
                continue;
            }
            p = p.next;
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "cleanChain");
        }
    }

    boolean isEmpty() {
        boolean result;
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "isEmpty");
        }
        boolean manyChildResult = this.singleMatchManyChild == null && (this.matchManyChildren == null || this.matchManyChildren.isEmpty());
        boolean bl = result = manyChildResult && this.matchOneChild == null && this.exactChild == null && this.suffix == null;
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "isEmpty", (Object)("result: " + new Boolean(result)));
        }
        return result;
    }

    boolean isEmptyChain() {
        boolean result;
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "isEmptyChain");
        }
        boolean bl = result = this.next == null && this.isEmpty();
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "isEmptyChain", (Object)("result: " + new Boolean(result)));
        }
        return result;
    }

    void put(PatternWrapper pattern, Conjunction selector, MatchTarget object, InternTable subExpr) throws MatchingException {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "put", new Object[]{pattern, selector, object, subExpr});
        }
        switch (pattern.getState()) {
            case 3: {
                this.exactChild = this.owner.nextMatcher(selector, this.exactChild);
                this.exactChild.put(selector, object, subExpr);
                break;
            }
            case 4: {
                if (this.hasMidClauses(pattern)) {
                    ContentMatcher newNext;
                    ContentMatcher next = null;
                    MatchManyWrapper wrapper = this.findMatchManyWrapper(pattern);
                    if (wrapper != null) {
                        next = wrapper.matcher;
                    }
                    if ((newNext = this.owner.nextMatcher(selector, next)) != next) {
                        if (this.matchManyChildren == null) {
                            this.matchManyChildren = new ArrayList(3);
                        }
                        MatchManyWrapper matchManyElement = new MatchManyWrapper(pattern, newNext);
                        this.matchManyChildren.add(matchManyElement);
                    }
                    newNext.put(selector, object, subExpr);
                    break;
                }
                this.singleMatchManyChild = this.owner.nextMatcher(selector, this.singleMatchManyChild);
                this.singleMatchManyChild.put(selector, object, subExpr);
                break;
            }
            case 0: 
            case 1: {
                PartialMatch pm = this.findOrCreate(pattern.getChars());
                pm.put(pattern, selector, object, subExpr);
                break;
            }
            case 5: 
            case 6: {
                if (this.matchOneChild == null) {
                    this.matchOneChild = this.newPartialMatch();
                }
                pattern.advance();
                this.matchOneChild.put(pattern, selector, object, subExpr);
                break;
            }
            case 2: {
                if (this.suffix == null) {
                    this.suffix = this.newPartialMatch();
                }
                pattern.advance();
                this.suffix.put(pattern, selector, object, subExpr);
            }
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "put");
        }
    }

    void remove(PatternWrapper pattern, Conjunction selector, MatchTarget object, InternTable subExpr, OrdinalPosition parentId) throws MatchingException {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "remove", new Object[]{pattern, selector, object, subExpr});
        }
        block0 : switch (pattern.getState()) {
            case 3: {
                this.exactChild = this.exactChild.remove(selector, object, subExpr, parentId);
                break;
            }
            case 4: {
                if (this.hasMidClauses(pattern)) {
                    MatchManyWrapper wrapper = this.findMatchManyWrapper(pattern);
                    if (wrapper == null) {
                        throw new MatchingException();
                    }
                    ContentMatcher next = wrapper.matcher;
                    ContentMatcher newNext = next.remove(selector, object, subExpr, parentId);
                    if (newNext == null) {
                        this.matchManyChildren.remove(wrapper);
                        break;
                    }
                    if (newNext == next) break;
                    MatchManyWrapper newWrapper = new MatchManyWrapper(pattern, newNext);
                    this.matchManyChildren.add(newWrapper);
                    break;
                }
                this.singleMatchManyChild = this.singleMatchManyChild.remove(selector, object, subExpr, parentId);
                break;
            }
            case 0: 
            case 1: {
                char[] chars = pattern.getChars();
                PartialMatch pm = this;
                while (true) {
                    if (pm == null) {
                        throw new MatchingException();
                    }
                    if (Arrays.equals(chars, pm.key)) {
                        pm.remove(pattern, selector, object, subExpr, parentId);
                        break block0;
                    }
                    pm = pm.next;
                }
            }
            case 5: 
            case 6: {
                pattern.advance();
                this.matchOneChild.remove(pattern, selector, object, subExpr, parentId);
                if (!this.matchOneChild.isEmptyChain()) break;
                this.matchOneChild = null;
                break;
            }
            case 2: {
                pattern.advance();
                this.suffix.remove(pattern, selector, object, subExpr, parentId);
                if (!this.suffix.isEmptyChain()) break;
                this.suffix = null;
            }
        }
        if (this.key.length == 0) {
            this.cleanChain();
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "remove");
        }
    }

    void get(char[] chars, int start, int length, boolean invert, MatchSpaceKey msg, EvalCache cache, Object contextValue, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "get", new Object[]{chars, new Integer(start), new Integer(length), new Boolean(invert), msg, cache, result});
        }
        PartialMatch pm = this;
        while (pm != null && length >= pm.key.length) {
            block11: {
                int origin = invert ? start + length - pm.key.length : start;
                for (int i = 0; i < pm.key.length; ++i) {
                    if (pm.key[i] == chars[origin + i]) {
                        continue;
                    }
                    break block11;
                }
                if (length == pm.key.length) {
                    if (pm.exactChild != null) {
                        pm.exactChild.get(null, msg, cache, contextValue, result);
                    }
                    if (pm.singleMatchManyChild != null) {
                        pm.singleMatchManyChild.get(null, msg, cache, contextValue, result);
                    }
                } else if (!invert) {
                    pm.doPartialGet(chars, start + pm.key.length, length - pm.key.length, false, msg, cache, contextValue, result);
                } else {
                    pm.doPartialGet(chars, start, length - pm.key.length, true, msg, cache, contextValue, result);
                }
            }
            pm = pm.next;
        }
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "get");
        }
    }

    void doPartialGet(char[] chars, int start, int length, boolean invert, MatchSpaceKey msg, EvalCache cache, Object contextValue, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        if (tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "doPartialGet", new Object[]{chars, new Integer(start), new Integer(length), new Boolean(invert), msg, cache, result});
        }
        if (this.matchOneChild != null) {
            if (!invert) {
                this.matchOneChild.get(chars, start + 1, length - 1, false, msg, cache, contextValue, result);
            } else {
                this.matchOneChild.get(chars, start, length - 1, true, msg, cache, contextValue, result);
            }
        }
        if (this.suffix != null) {
            this.suffix.get(chars, start, length, true, msg, cache, contextValue, result);
        }
        this.getFromManyChildMatchers(chars, start, length, msg, cache, contextValue, result);
        if (tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "doPartialGet");
        }
    }

    public boolean hasMidClauses(PatternWrapper pattern) {
        return pattern.hasMidClauses();
    }

    public void getFromManyChildMatchers(char[] chars, int start, int length, MatchSpaceKey msg, EvalCache cache, Object contextValue, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        if (this.singleMatchManyChild != null) {
            this.singleMatchManyChild.get(null, msg, cache, contextValue, result);
        }
        if (this.matchManyChildren != null) {
            for (MatchManyWrapper nextElement : this.matchManyChildren) {
                ContentMatcher next;
                PatternWrapper nextPattern = nextElement.pattern;
                if (!nextPattern.matchMidClauses(chars, start, length) || (next = nextElement.matcher) == null) continue;
                next.get(null, msg, cache, contextValue, result);
            }
        }
    }

    private MatchManyWrapper findMatchManyWrapper(PatternWrapper pattern) {
        MatchManyWrapper wrapper = null;
        if (this.matchManyChildren != null) {
            for (MatchManyWrapper nextElement : this.matchManyChildren) {
                PatternWrapper nextPattern = nextElement.pattern;
                if (!nextPattern.equals(pattern)) continue;
                wrapper = nextElement;
                break;
            }
        }
        return wrapper;
    }

    private class MatchManyWrapper {
        PatternWrapper pattern;
        ContentMatcher matcher;

        public MatchManyWrapper(PatternWrapper pattern, ContentMatcher matcher) {
            this.pattern = pattern;
            this.matcher = matcher;
        }

        public boolean equals(Object o) {
            if (o instanceof MatchManyWrapper) {
                MatchManyWrapper other = (MatchManyWrapper)o;
                return this.pattern.equals(other.pattern);
            }
            return false;
        }
    }
}

