/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.InvalidFileStoreConfigurationException;
import com.ibm.ws.sib.admin.SIBFileStore;
import com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl;
import com.ibm.ws.sib.utils.ras.SibTr;

public class SIBFileStoreImpl
implements SIBFileStore {
    private static final TraceComponent tc = SibTr.register(JsMainAdminComponentImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private String uuid = null;
    private String path = "${server.output.dir}//messaging/messageStore";
    private long logFileSize = 0xA00000L;
    private long fileStoreSize = 0x19000000L;
    private long minPermanentFileStoreSize = 0x1400000L;
    private long maxPermanentFileStoreSize = this.fileStoreSize / 2L;
    private long minTemporaryFileStoreSize = 0x1400000L;
    private long maxTemporaryFileStoreSize = this.fileStoreSize / 2L;
    private boolean unlimitedTemporaryStoreSize = false;
    private boolean unlimitedPermanentStoreSize = false;

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) throws InvalidFileStoreConfigurationException {
        if (path == null || path.trim().isEmpty()) {
            throw new InvalidFileStoreConfigurationException(nls.getFormattedMessage("INVALID_FS_PATH_SIAS0120", null, null));
        }
        this.path = path;
    }

    public long getLogFileSize() {
        return this.logFileSize;
    }

    public void setLogFileSize(long logFileSize) throws InvalidFileStoreConfigurationException {
        this.logFileSize = logFileSize;
    }

    public long getFileStoreSize() {
        return this.fileStoreSize;
    }

    public void setFileStoreSize(long fileStoreSize) throws InvalidFileStoreConfigurationException {
        this.fileStoreSize = fileStoreSize < this.minPermanentFileStoreSize + this.minTemporaryFileStoreSize ? 0x19000000L : fileStoreSize;
        this.maxPermanentFileStoreSize = this.fileStoreSize / 2L;
        this.maxTemporaryFileStoreSize = this.fileStoreSize / 2L;
    }

    public long getMinPermanentFileStoreSize() {
        return this.minPermanentFileStoreSize;
    }

    public void setMinPermanentFileStoreSize(long minPermanentFileStoreSize) {
        this.minPermanentFileStoreSize = minPermanentFileStoreSize;
    }

    public long getMaxPermanentFileStoreSize() {
        return this.maxPermanentFileStoreSize;
    }

    public void setMaxPermanentFileStoreSize(long maxPermanentFileStoreSize) {
        this.maxPermanentFileStoreSize = maxPermanentFileStoreSize;
    }

    public long getMinTemporaryFileStoreSize() {
        return this.minTemporaryFileStoreSize;
    }

    public void setMinTemporaryFileStoreSize(long minTemporaryFileStoreSize) {
        this.minTemporaryFileStoreSize = minTemporaryFileStoreSize;
    }

    public long getMaxTemporaryFileStoreSize() {
        return this.maxTemporaryFileStoreSize;
    }

    public void setMaxTemporaryFileStoreSize(long maxTemporaryFileStoreSize) {
        this.maxTemporaryFileStoreSize = maxTemporaryFileStoreSize;
    }

    public boolean isUnlimitedTemporaryStoreSize() {
        return this.unlimitedTemporaryStoreSize;
    }

    public void setUnlimitedTemporaryStoreSize(boolean unlimitedTemporaryStoreSize) {
        this.unlimitedTemporaryStoreSize = false;
    }

    public boolean isUnlimitedPermanentStoreSize() {
        return this.unlimitedPermanentStoreSize;
    }

    public void setUnlimitedPermanentStoreSize(boolean unlimitedPermanentStoreSize) {
        this.unlimitedPermanentStoreSize = false;
    }

    public void validateFileStoreSettings() throws InvalidFileStoreConfigurationException {
        if (this.logFileSize >= this.maxPermanentFileStoreSize) {
            String errorMsg = nls.getFormattedMessage("INVALID_FILE_SIZE_SIAS0124", new Object[]{this.logFileSize / 0x100000L, this.maxPermanentFileStoreSize / 0x100000L}, null);
            SibTr.warning((TraceComponent)tc, (String)errorMsg);
            this.logFileSize = this.maxPermanentFileStoreSize - 0x100000L;
        }
        if (this.logFileSize > this.minPermanentFileStoreSize) {
            this.minPermanentFileStoreSize = this.logFileSize;
            this.minTemporaryFileStoreSize = this.logFileSize;
        }
    }
}

