/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;

public class StaticCATSubscription {
    private static String CLASS_NAME = StaticCATSubscription.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATSubscription.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void rcvCreateDurableSub(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateDurableSub", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        short consumerFlags = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ConnectionObjectId:", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"ConsumerFlags:", (Object)consumerFlags);
        }
        if (consumerFlags > 7) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Consumer flags (" + consumerFlags + ") > 0x07"));
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8014", new Object[]{"" + consumerFlags}, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0003");
        }
        boolean noLocal = (consumerFlags & 2) != 0;
        boolean supportMultipleConsumers = (consumerFlags & 4) != 0;
        SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        String subscriptionName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Subscription Name:", (Object)subscriptionName);
        }
        String subscriptionHome = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Subscription Home:", (Object)subscriptionHome);
        }
        SelectionCriteria criteria = request.getSelectionCriteria();
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        String alternateUser = request.getString();
        try {
            connection.createDurableSubscription(subscriptionName, subscriptionHome, destAddress, criteria, supportMultipleConsumers, noLocal, alternateUser);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 195, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0001");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2025", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateDurableSub"), (String)"3-011-0002");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-011-0002", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateDurableSub");
        }
    }

    public static void rcvCreateConsumerForDurableSub(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        block29: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rcvCreateConsumerForDurableSub", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
            }
            ConversationState convState = (ConversationState)conversation.getAttachment();
            short connectionObjectID = request.getShort();
            short clientSessionId = request.getShort();
            short consumerFlags = request.getShort();
            short reliabilityShort = request.getShort();
            int requestedBytes = request.getInt();
            short unrecovShort = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"ConnectionObjectId:", (Object)connectionObjectID);
                SibTr.debug((TraceComponent)tc, (String)"ClientSessionId:", (Object)clientSessionId);
                SibTr.debug((TraceComponent)tc, (String)"ConsumerFlags:", (Object)consumerFlags);
                SibTr.debug((TraceComponent)tc, (String)"Reliability:", (Object)reliabilityShort);
                SibTr.debug((TraceComponent)tc, (String)"RequestedBytes:", (Object)requestedBytes);
                SibTr.debug((TraceComponent)tc, (String)"UnrecovReliability", (Object)unrecovShort);
            }
            try {
                Reliability reliability = null;
                if (reliabilityShort != -1) {
                    reliability = Reliability.getReliability((int)reliabilityShort);
                }
                int validFlags = 71;
                if ((consumerFlags | 0x47) != 71) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Consumer flags (" + consumerFlags + ") not valid, valid flags =" + 71));
                    }
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8014", new Object[]{"" + consumerFlags}, null));
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0010");
                }
                boolean readAheadPermitted = (consumerFlags & 1) != 0;
                boolean noLocal = (consumerFlags & 2) != 0;
                boolean supportMultipleConsumers = (consumerFlags & 4) != 0;
                boolean bifurcatable = (consumerFlags & 0x40) != 0;
                Reliability unrecoverableReliability = null;
                if (unrecovShort != -1) {
                    unrecoverableReliability = Reliability.getReliability((int)unrecovShort);
                }
                SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Destination Address", (Object)destAddress);
                }
                String subscriptionName = request.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Subscription Name:", (Object)subscriptionName);
                }
                String subscriptionHome = request.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Subscription Home:", (Object)subscriptionHome);
                }
                SelectionCriteria criteria = request.getSelectionCriteria();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Selection Criteria", (Object)criteria);
                }
                String alternateUser = request.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Alternate User Id: ", (Object)alternateUser);
                }
                SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
                try {
                    ConsumerSession session = connection.createConsumerSessionForDurableSubscription(subscriptionName, subscriptionHome, destAddress, criteria, supportMultipleConsumers, noLocal, reliability, readAheadPermitted, unrecoverableReliability, bifurcatable, alternateUser);
                    CATMainConsumer mainConsumer = new CATMainConsumer(conversation, clientSessionId, session, readAheadPermitted, noLocal, unrecoverableReliability);
                    short durableSubscriberObjectID = (short)convState.addObject(mainConsumer);
                    mainConsumer.setConsumerSessionId(durableSubscriberObjectID);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Durable Subscription Id:", (Object)durableSubscriberObjectID);
                    }
                    StaticCATHelper.sendSessionCreateResponse(231, requestNumber, conversation, durableSubscriberObjectID, (DestinationSession)session, destAddress);
                    if (!readAheadPermitted) break block29;
                    try {
                        mainConsumer.setRequestedBytes(requestedBytes);
                        mainConsumer.setAsynchConsumerCallback(requestNumber, 0, 0L, 1, null);
                        mainConsumer.start(requestNumber, false, false, null);
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0006");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Unable to create readahead async consumer");
                            SibTr.exception((TraceComponent)tc, (Exception)((Exception)e.getCause()));
                        }
                        throw new SIResourceException(e.getMessage());
                    }
                }
                catch (SIDurableSubscriptionNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
                }
                catch (SINotAuthorizedException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
                }
                catch (SIException e) {
                    if (!convState.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0007");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-011-0007", conversation, requestNumber);
                }
                catch (ConversationStateFullException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0008");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-011-0008", conversation, requestNumber);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateConsumerForDurableSub"), (String)"3-011-0009");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-011-0009", conversation, requestNumber);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateConsumerForDurableSub");
        }
    }

    public static void rcvDeleteDurableSub(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvDeleteDurableSub", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ConnectionObjectId:", (Object)connectionObjectID);
        }
        String subscriptionName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Subscription Name:", (Object)subscriptionName);
        }
        String subscriptionHome = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Subscription Home:", (Object)subscriptionHome);
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        try {
            connection.deleteDurableSubscription(subscriptionName, subscriptionHome);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 196, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvDeleteDurableSub"), (String)"3-011-0004");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2025", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvDeleteDurableSub"), (String)"3-011-0005");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-011-0005", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvDeleteDurableSub");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATSubscription.java, SIB.comms, WASX.SIB, aa1225.01 1.59");
        }
    }
}

