/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.clientsupport.CATSyncAsynchReader;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public class CATTimer
implements AlarmListener {
    private static String CLASS_NAME = CATTimer.class.getName();
    private CATSyncAsynchReader asynchReader = null;
    private static final TraceComponent tc = SibTr.register(CATTimer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public CATTimer(CATSyncAsynchReader asynchReader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)asynchReader);
        }
        this.asynchReader = asynchReader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmObj) {
        boolean sessionAvailable;
        block32: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)alarmObj);
            }
            sessionAvailable = true;
            if (!this.asynchReader.isComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async reader has not yet got a message");
                }
                try {
                    try {
                        this.asynchReader.stopSession();
                    }
                    catch (SISessionDroppedException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a SISessionDroppedException", (Object)((Object)e));
                        }
                        sessionAvailable = false;
                        if (this.asynchReader.isConversationClosed()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The Conversation was closed - no need to panic");
                            }
                            break block32;
                        }
                        throw e;
                    }
                    catch (SISessionUnavailableException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a SISessionUnavailableException", (Object)((Object)e));
                        }
                        sessionAvailable = false;
                        if (this.asynchReader.isConversationClosed()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The Conversation was closed - no need to panic");
                            }
                            break block32;
                        }
                        throw e;
                    }
                }
                catch (SIException sis) {
                    if (!this.asynchReader.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)sis, (String)(CLASS_NAME + ".alarm"), (String)"3-017-0001", (Object)this);
                    }
                    sessionAvailable = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)sis.getMessage(), (Object)((Object)sis));
                    }
                    this.asynchReader.sendErrorToClient(sis, "3-017-0001");
                }
                finally {
                    block33: {
                        if (!this.asynchReader.isComplete()) {
                            try {
                                MPConsumerSession mpSession = (MPConsumerSession)this.asynchReader.getCATMainConsumer().getConsumerSession();
                                mpSession.getConnection().removeConnectionListener((SICoreConnectionListener)this.asynchReader);
                            }
                            catch (SIException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block33;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                            }
                        }
                    }
                }
            }
        }
        if (sessionAvailable) {
            if (this.asynchReader.isComplete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async reader got a message");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No message received");
                }
                this.asynchReader.sendNoMessageToClient();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATTimer.java, SIB.comms, WASX.SIB, aa1225.01 1.27");
        }
    }
}

