/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.clientsupport.CATAsynchConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATBifurcatedConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATBrowseConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATProxyConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATSessSynchConsumer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;

public class CATMainConsumer
extends CATConsumer {
    private static String CLASS_NAME = CATMainConsumer.class.getName();
    private static final TraceComponent tc = SibTr.register(CATMainConsumer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private Conversation conversation;
    private ConsumerSession consumerSession;
    private short clientSessionId;
    private CATConsumer subConsumer;
    private int lowestPriority = 11;
    private int requestedBytes;
    private short consumerSessionId;
    private boolean readAheadPermitted;
    private boolean noLocal;
    private boolean connectionReceive = false;
    private short messageBatchNumber = 0;
    private volatile boolean started = false;
    private Reliability unrecoverableReliability = null;
    private BrowserSession browserSession = null;
    private Semaphore startSemaphore = new Semaphore(1);
    private volatile boolean stoppableSessionStopped = false;

    public CATMainConsumer(Conversation conversation, short clientSessionId, ConsumerSession consumerSession, boolean readAheadPermitted, boolean noLocal, Reliability unrecoverableReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conversation, clientSessionId, consumerSession, readAheadPermitted, noLocal, unrecoverableReliability});
        }
        this.conversation = conversation;
        this.clientSessionId = clientSessionId;
        this.consumerSession = consumerSession;
        this.readAheadPermitted = readAheadPermitted;
        this.noLocal = noLocal;
        this.unrecoverableReliability = unrecoverableReliability;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public CATMainConsumer(Conversation conversation, short clientSessionId, BrowserSession browserSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conversation, clientSessionId, browserSession});
        }
        this.conversation = conversation;
        this.clientSessionId = clientSessionId;
        this.browserSession = browserSession;
        this.subConsumer = new CATBrowseConsumer(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean isStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isStarted");
        }
        this.startSemaphore.waitOnIgnoringInterruptions();
        this.startSemaphore.post();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isStarted", (Object)this.started);
        }
        return this.started;
    }

    public boolean getUsingConnectionReceive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUsingConnectionReceive");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUsingConnectionReceive", (Object)this.connectionReceive);
        }
        return this.connectionReceive;
    }

    public void setUsingConnectionReceive(boolean connectionReceive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUsingConnectionReceive", (Object)connectionReceive);
        }
        this.connectionReceive = connectionReceive;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUsingConnectionReceive");
        }
    }

    @Override
    protected Conversation getConversation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversation");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversation", (Object)this.conversation);
        }
        return this.conversation;
    }

    protected boolean getNoLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNoLocal");
        }
        this.checkNotBrowserSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNoLocal", (Object)("" + this.noLocal));
        }
        return this.noLocal;
    }

    protected boolean getReadAheadPermitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReadAheadPermitted");
        }
        this.checkNotBrowserSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReadAheadPermitted", (Object)("" + this.readAheadPermitted));
        }
        return this.readAheadPermitted;
    }

    @Override
    protected short getClientSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientSessionId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientSessionId", (Object)("" + this.clientSessionId));
        }
        return this.clientSessionId;
    }

    protected void setClientSessionId(short clientSessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setClientSessionId", (Object)clientSessionId);
        }
        this.clientSessionId = clientSessionId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setClientSessionId");
        }
    }

    @Override
    public ConsumerSession getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        this.checkNotBrowserSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession", (Object)this.consumerSession);
        }
        return this.consumerSession;
    }

    @Override
    protected int getLowestPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestPriority");
        }
        this.checkNotBrowserSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestPriority", (Object)("" + this.lowestPriority));
        }
        return this.lowestPriority;
    }

    protected void setLowestPriority(int lowestPriority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLowestPriority", (Object)lowestPriority);
        }
        this.checkNotBrowserSession();
        if (lowestPriority < this.lowestPriority) {
            this.lowestPriority = lowestPriority;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLowestPriority");
        }
    }

    protected short getConsumerSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSessionId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSessionId", (Object)this.consumerSessionId);
        }
        return this.consumerSessionId;
    }

    protected void setConsumerSessionId(short consumerSessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConsumerSessionId", (Object)consumerSessionId);
        }
        this.consumerSessionId = consumerSessionId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConsumerSessionId");
        }
    }

    protected int getRequestedBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRequestedBytes");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRequestedBytes", (Object)this.requestedBytes);
        }
        return this.requestedBytes;
    }

    protected void setRequestedBytes(int requestedBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRequestedBytes", (Object)requestedBytes);
        }
        this.requestedBytes = requestedBytes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRequestedBytes");
        }
    }

    protected short getMessageBatchNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageBatchNumber");
        }
        this.checkNotBrowserSession();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageBatchNumber", (Object)this.messageBatchNumber);
        }
        return this.messageBatchNumber;
    }

    protected void incremenetMessageBatchNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incremenetMessageBatchNumber");
        }
        this.checkNotBrowserSession();
        this.messageBatchNumber = (short)(this.messageBatchNumber + 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message batch number is now: " + this.messageBatchNumber));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incremenetMessageBatchNumber");
        }
    }

    @Override
    protected Reliability getUnrecoverableReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUnrecoverableReliability", (Object)this.unrecoverableReliability);
        }
        return this.unrecoverableReliability;
    }

    @Override
    public void receive(int requestNumber, int tran, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{requestNumber, tran, timeout});
        }
        if (this.subConsumer == null) {
            this.subConsumer = new CATSessSynchConsumer(this);
        }
        this.subConsumer.receive(requestNumber, tran, timeout);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
        }
    }

    @Override
    public void close(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)requestNumber);
        }
        if (this.subConsumer != null) {
            this.subConsumer.close(requestNumber);
        } else {
            super.close(requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext});
        }
        this.setAsynchConsumerCallback(requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, false, 0, 0L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
    }

    @Override
    public void setAsynchConsumerCallback(int requestNumber, int maxActiveMessages, long messageLockExpiry, int batchsize, OrderingContext orderContext, boolean stoppable, int maxSequentialFailures, long hiddenMessageDelay) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback", (Object)new Object[]{requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay});
        }
        this.checkNotBrowserSession();
        if (this.getReadAheadPermitted()) {
            if (maxActiveMessages == 0 && messageLockExpiry == 0L && !stoppable) {
                this.subConsumer = new CATProxyConsumer(this);
            } else {
                try {
                    this.getConsumerSession().stop();
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught SIException on calling stop on ConsumerSession.", (Object)((Object)e));
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
                this.subConsumer = new CATAsynchConsumer(this);
            }
        } else {
            this.subConsumer = new CATAsynchConsumer(this);
        }
        this.subConsumer.setAsynchConsumerCallback(requestNumber, maxActiveMessages, messageLockExpiry, batchsize, orderContext, stoppable, maxSequentialFailures, hiddenMessageDelay);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsynchConsumerCallback");
        }
    }

    @Override
    public void unsetAsynchConsumerCallback(int requestNumber, boolean stoppable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsetAsynchConsumerCallback", (Object)("requestNumber=" + requestNumber + ",stoppable=" + stoppable));
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unsetAsynchConsumerCallback(requestNumber, stoppable);
        }
        this.subConsumer = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsetAsynchConsumerCallback");
        }
    }

    @Override
    public void start(int requestNumber, boolean deliverImmediately, boolean sendReply, SendListener sendListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{requestNumber, deliverImmediately, sendReply, sendListener});
        }
        this.start(requestNumber, deliverImmediately, sendReply, sendListener, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void start(int requestNumber, boolean deliverImmediately, boolean sendReply, SendListener sendListener, boolean restart) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{requestNumber, deliverImmediately, sendReply, sendListener, restart});
        }
        if (restart && this.stoppableSessionStopped) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stoppable session now stopped so ignoring the restart request");
            }
        } else {
            this.stoppableSessionStopped = false;
            this.checkNotBrowserSession();
            SessionStartSendListener listener = new SessionStartSendListener();
            this.startSemaphore.waitOnIgnoringInterruptions();
            try {
                if (this.subConsumer != null) {
                    this.subConsumer.start(requestNumber, deliverImmediately, sendReply, listener);
                } else {
                    super.start(requestNumber, deliverImmediately, sendReply, listener);
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".start"), (String)"3-027-0004", (Object)this, (Object[])new Object[]{this.subConsumer});
                listener.errorOccurred(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)e);
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)requestNumber);
        }
        this.checkNotBrowserSession();
        SessionStopSendListener listener = new SessionStopSendListener();
        this.startSemaphore.waitOnIgnoringInterruptions();
        try {
            if (this.subConsumer != null) {
                this.subConsumer.stop(requestNumber, listener);
            } else {
                super.stop(requestNumber, listener);
            }
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".stop"), (String)"3-027-0005", (Object)this, (Object[])new Object[]{this.subConsumer});
            listener.errorOccurred(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockSet(requestNumber, msgHandles, reply);
        } else {
            super.unlockSet(requestNumber, msgHandles, reply);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void unlockSet(int requestNumber, SIMessageHandle[] msgHandles, boolean reply, boolean incrementLockcount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockSet", (Object)new Object[]{requestNumber, msgHandles, reply, incrementLockcount});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockSet(requestNumber, msgHandles, reply, incrementLockcount);
        } else {
            super.unlockSet(requestNumber, msgHandles, reply, incrementLockcount);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockSet");
        }
    }

    @Override
    public void readSet(int requestNumber, SIMessageHandle[] msgHandles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readSet", (Object)new Object[]{requestNumber, msgHandles});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.readSet(requestNumber, msgHandles);
        } else {
            super.readSet(requestNumber, msgHandles);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readSet");
        }
    }

    @Override
    public void readAndDeleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet", (Object)new Object[]{requestNumber, msgHandles, tran});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.readAndDeleteSet(requestNumber, msgHandles, tran);
        } else {
            super.readAndDeleteSet(requestNumber, msgHandles, tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAndDeleteSet");
        }
    }

    @Override
    public void deleteSet(int requestNumber, SIMessageHandle[] msgHandles, int tran, boolean reply) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteSet", (Object)new Object[]{requestNumber, msgHandles, tran, reply});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.deleteSet(requestNumber, msgHandles, tran, reply);
        } else {
            super.deleteSet(requestNumber, msgHandles, tran, reply);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteSet");
        }
    }

    @Override
    public void unlockAll(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)requestNumber);
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockAll(requestNumber);
        } else {
            super.unlockAll(requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    @Override
    public void flush(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flush", (Object)requestNumber);
        }
        if (this.subConsumer != null) {
            this.subConsumer.flush(requestNumber);
        } else {
            super.flush(requestNumber);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flush");
        }
    }

    @Override
    public void requestMsgs(int requestNumber, int receiveBytes, int requestedBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestMsgs", (Object)new Object[]{requestNumber, receiveBytes, requestedBytes});
        }
        if (this.subConsumer != null) {
            this.subConsumer.requestMsgs(requestNumber, receiveBytes, requestedBytes);
        } else {
            super.requestMsgs(requestNumber, receiveBytes, requestedBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestMsgs");
        }
    }

    private void checkNotBrowserSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkNotBrowserSession");
        }
        if (this.browserSession != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Browser session != null", (Object)this.browserSession);
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_UNEXPECTED_SICO2041", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".checkNotBrowserSession"), (String)"3-027-0001", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkNotBrowserSession");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkNotBrowserSession");
        }
    }

    protected BrowserSession getBrowserSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBrowserSession");
        }
        if (this.browserSession == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Browser session == null");
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("BROWSER_SESSION_EXPECTED_SICO2042", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getBrowserSession"), (String)"3-027-0002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBrowserSession");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBrowserSession", (Object)this.browserSession);
        }
        return this.browserSession;
    }

    public void setBifurcatedSession(BifurcatedConsumerSession sess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBifurcatedSession", (Object)sess);
        }
        this.subConsumer = new CATBifurcatedConsumer(this, sess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBifurcatedSession");
        }
    }

    public void stopStoppableSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopStoppableSession");
        }
        this.stoppableSessionStopped = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopStoppableSession");
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": started: " + this.started + ", readAhead: " + this.readAheadPermitted + ", unrecovReliability: " + this.unrecoverableReliability + ", batchNumber: " + this.messageBatchNumber + ", noLocal: " + this.noLocal + ", requestedBytes: " + this.requestedBytes + ", -> SubConsumer: " + this.subConsumer;
    }

    @Override
    public void unlockAll(int requestNumber, boolean incrementUnlockCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{requestNumber, incrementUnlockCount});
        }
        this.checkNotBrowserSession();
        if (this.subConsumer != null) {
            this.subConsumer.unlockAll(requestNumber, incrementUnlockCount);
        } else {
            super.unlockAll(requestNumber, incrementUnlockCount);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    @Override
    public void dump(FormattedWriter writer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dump", (Object)new Object[]{writer});
        }
        try {
            writer.newLine();
            writer.startTag(this.getClass().getSimpleName());
            writer.indent();
            super.dump(writer);
            if (this.subConsumer != null) {
                this.subConsumer.dump(writer);
            }
            writer.outdent();
            writer.newLine();
            writer.endTag(this.getClass().getSimpleName());
        }
        catch (Throwable t) {
            try {
                writer.write("\nUnable to dump " + this + " " + t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dump");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATMainConsumer.java, SIB.comms, WASX.SIB, aa1225.01 1.62.1.1");
        }
    }

    private class SessionStopSendListener
    implements SendListener {
        private boolean hasPosted = false;

        private SessionStopSendListener() {
        }

        public synchronized void dataSent(Conversation conversation) {
            CATMainConsumer.this.started = false;
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }

        public synchronized void errorOccurred(SIConnectionLostException exception, Conversation conversation) {
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }

        public synchronized void errorOccurred(RuntimeException e) {
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }
    }

    private class SessionStartSendListener
    implements SendListener {
        private boolean hasPosted = false;

        private SessionStartSendListener() {
        }

        public synchronized void dataSent(Conversation conversation) {
            CATMainConsumer.this.started = true;
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }

        public synchronized void errorOccurred(SIConnectionLostException exception, Conversation conversation) {
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }

        public synchronized void errorOccurred(RuntimeException e) {
            if (!this.hasPosted) {
                CATMainConsumer.this.startSemaphore.post();
                this.hasPosted = true;
            }
        }
    }
}

