/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.utils.PasswordSuppressingProperties;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class Configuration
implements FFDCSelfIntrospectable {
    private static TraceComponent tc = SibTr.register(Configuration.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String PROPERTY_FILE = "MessageStore.properties";
    public static final int POOLED_CONNECTIONS = 3;
    protected String persistentMessageStoreClassname = "com.ibm.ws.sib.msgstore.persistence.objectManager.PersistentMessageStoreImpl";
    protected String objectManagerLogDirectory = ".";
    protected long objectManagerLogSize = Long.parseLong("10485760");
    protected String objectManagerPermanentStoreDirectory = ".";
    protected long objectManagerMinimumPermanentStoreSize = Long.parseLong("20971520");
    protected long objectManagerMaximumPermanentStoreSize = Long.parseLong("20971520");
    protected boolean objectManagerPermanentStoreSizeUnlimited = false;
    protected String objectManagerTemporaryStoreDirectory = ".";
    protected long objectManagerMinimumTemporaryStoreSize = Long.parseLong("20971520");
    protected long objectManagerMaximumTemporaryStoreSize = Long.parseLong("20971520");
    protected boolean objectManagerTemporaryStoreSizeUnlimited = false;
    protected String datasourceClassname = null;
    protected String datasourceUsername = null;
    protected String datasourcePassword = null;
    protected Properties datasourceProperties = new PasswordSuppressingProperties();
    protected String schemaName = "IBMWSSIB";
    protected int numberOfPooledConnections = 3;
    protected int numberOfPermanentTables = 1;
    protected int numberOfTemporaryTables = 1;
    protected boolean createTablesAutomatically = true;
    protected boolean cleanPersistenceOnStart = false;
    protected boolean verbose = false;

    protected Configuration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>()");
            SibTr.exit((TraceComponent)tc, (String)"<ctor>()", (Object)this);
        }
    }

    public static Configuration createBasicConfiguration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBasicConfiguration()");
        }
        Configuration config = new Configuration();
        try {
            config.loadFromPropertyFile();
        }
        catch (IOException ioe) {
            config.datasourceClassname = "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource";
            config.datasourceProperties.setProperty("databaseName", System.getProperty("js.test.dbname", "msdb"));
            config.datasourceProperties.setProperty("createDatabase", "create");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBasicConfiguration()", (Object)config);
        }
        return config;
    }

    public void loadFromPropertyFile() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadFromPropertyFile()");
        }
        String key = null;
        Properties config = new Properties();
        InputStream is = this.getClass().getResourceAsStream(PROPERTY_FILE);
        if (is == null) {
            throw new IOException("Resource MessageStore.properties not found in current classloader");
        }
        config.load(is);
        Enumeration<?> vEnum = config.propertyNames();
        while (vEnum.hasMoreElements()) {
            key = (String)vEnum.nextElement();
            if (key.equals("datasourceClassname")) {
                this.datasourceClassname = config.getProperty(key);
                continue;
            }
            if (key.equals("username")) {
                this.datasourceUsername = config.getProperty(key);
                continue;
            }
            if (key.equals("password")) {
                this.datasourcePassword = config.getProperty(key);
                continue;
            }
            if (key.equals("schemaname")) {
                this.schemaName = config.getProperty(key);
                continue;
            }
            if (key.equals("poolSize")) {
                this.numberOfPooledConnections = Integer.parseInt(config.getProperty(key));
                continue;
            }
            if (key.equals("verbose")) {
                this.verbose = Boolean.valueOf(config.getProperty(key));
                continue;
            }
            this.datasourceProperties.setProperty(key, config.getProperty(key));
        }
        if (this.datasourceClassname == null) {
            throw new IllegalStateException("The properties file must specify datasourceClassname");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadFromPropertyFile()");
        }
    }

    public String getPersistentMessageStoreClassname() {
        return this.persistentMessageStoreClassname;
    }

    public void setPersistentMessageStoreClassname(String persistentMessageStoreClassname) {
        this.persistentMessageStoreClassname = persistentMessageStoreClassname;
    }

    public String getObjectManagerLogDirectory() {
        return this.objectManagerLogDirectory;
    }

    public void setObjectManagerLogDirectory(String objectManagerLogDirectory) {
        this.objectManagerLogDirectory = objectManagerLogDirectory;
    }

    public long getObjectManagerLogSize() {
        return this.objectManagerLogSize;
    }

    public void setObjectManagerLogSize(long objectManagerLogSize) {
        this.objectManagerLogSize = objectManagerLogSize;
    }

    public String getObjectManagerPermanentStoreDirectory() {
        return this.objectManagerPermanentStoreDirectory;
    }

    public void setObjectManagerPermanentStoreDirectory(String objectManagerPermanentStoreDirectory) {
        this.objectManagerPermanentStoreDirectory = objectManagerPermanentStoreDirectory;
    }

    public long getObjectManagerMinimumPermanentStoreSize() {
        return this.objectManagerMinimumPermanentStoreSize;
    }

    public void setObjectManagerMinimumPermanentStoreSize(long objectManagerMinimumPermanentStoreSize) {
        this.objectManagerMinimumPermanentStoreSize = objectManagerMinimumPermanentStoreSize;
    }

    public long getObjectManagerMaximumPermanentStoreSize() {
        return this.objectManagerMaximumPermanentStoreSize;
    }

    public void setObjectManagerMaximumPermanentStoreSize(long objectManagerMaximumPermanentStoreSize) {
        this.objectManagerMaximumPermanentStoreSize = objectManagerMaximumPermanentStoreSize;
    }

    public boolean isObjectManagerPermanentStoreSizeUnlimited() {
        return this.objectManagerPermanentStoreSizeUnlimited;
    }

    public void setObjectManagerPermanentStoreSizeUnlimited(boolean objectManagerPermanentStoreSizeUnlimited) {
        this.objectManagerPermanentStoreSizeUnlimited = objectManagerPermanentStoreSizeUnlimited;
    }

    public String getObjectManagerTemporaryStoreDirectory() {
        return this.objectManagerTemporaryStoreDirectory;
    }

    public void setObjectManagerTemporaryStoreDirectory(String objectManagerTemporaryStoreDirectory) {
        this.objectManagerTemporaryStoreDirectory = objectManagerTemporaryStoreDirectory;
    }

    public long getObjectManagerMinimumTemporaryStoreSize() {
        return this.objectManagerMinimumTemporaryStoreSize;
    }

    public void setObjectManagerMinimumTemporaryStoreSize(long objectManagerMinimumTemporaryStoreSize) {
        this.objectManagerMinimumTemporaryStoreSize = objectManagerMinimumTemporaryStoreSize;
    }

    public long getObjectManagerMaximumTemporaryStoreSize() {
        return this.objectManagerMaximumTemporaryStoreSize;
    }

    public void setObjectManagerMaximumTemporaryStoreSize(long objectManagerMaximumTemporaryStoreSize) {
        this.objectManagerMaximumTemporaryStoreSize = objectManagerMaximumTemporaryStoreSize;
    }

    public boolean isObjectManagerTemporaryStoreSizeUnlimited() {
        return this.objectManagerTemporaryStoreSizeUnlimited;
    }

    public void setObjectManagerTemporaryStoreSizeUnlimited(boolean objectManagerTemporaryStoreSizeUnlimited) {
        this.objectManagerTemporaryStoreSizeUnlimited = objectManagerTemporaryStoreSizeUnlimited;
    }

    public String getDatasourceClassname() {
        return this.datasourceClassname;
    }

    public String getDatasourcePassword() {
        return this.datasourcePassword;
    }

    public String getDatasourceUsername() {
        return this.datasourceUsername;
    }

    public void setDatasourceClassname(String dataSourceClassname) {
        this.datasourceClassname = dataSourceClassname;
    }

    public void setDatasourcePassword(String dataSourcePassword) {
        this.datasourcePassword = dataSourcePassword;
    }

    public void setDatasourceUsername(String dataSourceUsername) {
        this.datasourceUsername = dataSourceUsername;
    }

    public Properties getDatasourceProperties() {
        return this.datasourceProperties;
    }

    public boolean isCreateTablesAutomatically() {
        return this.createTablesAutomatically;
    }

    public void setCreateTablesAutomatically(boolean createTablesAutomatically) {
        this.createTablesAutomatically = createTablesAutomatically;
    }

    public void setDatabaseSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getDatabaseSchemaName() {
        return this.schemaName;
    }

    public boolean isCleanPersistenceOnStart() {
        return this.cleanPersistenceOnStart;
    }

    public void setCleanPersistenceOnStart(boolean cleanPersistenceOnStart) {
        this.cleanPersistenceOnStart = cleanPersistenceOnStart;
    }

    public int getNumberOfPooledConnections() {
        return this.numberOfPooledConnections;
    }

    public void setNumberOfPooledConnections(int numberOfPooledConnections) {
        this.numberOfPooledConnections = numberOfPooledConnections;
    }

    public int getNumberOfTemporaryTables() {
        return this.numberOfTemporaryTables;
    }

    public void setNumberOfTemporaryTables(int numberOfTemporaryTables) {
        this.numberOfTemporaryTables = numberOfTemporaryTables;
    }

    public int getNumberOfPermanentTables() {
        return this.numberOfPermanentTables;
    }

    public void setNumberOfPermanentTables(int numberOfPermanentTables) {
        this.numberOfPermanentTables = numberOfPermanentTables;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public String toString() {
        return "Pers MS Class name: " + this.persistentMessageStoreClassname + ", OM Log directory: " + this.objectManagerLogDirectory + ", OM Log size: " + this.objectManagerLogSize + ", OM Permanent Store directory: " + this.objectManagerPermanentStoreDirectory + ", OM Permanent Store size minimum: " + this.objectManagerMinimumPermanentStoreSize + ", OM Permanent Store size maximum: " + this.objectManagerMaximumPermanentStoreSize + ", OM Permanent Store size unlimited: " + this.objectManagerPermanentStoreSizeUnlimited + ", OM Temporary Store directory: " + this.objectManagerTemporaryStoreDirectory + ", OM Temporary Store size minimum: " + this.objectManagerMinimumTemporaryStoreSize + ", OM Temporary Store size maximum: " + this.objectManagerMaximumTemporaryStoreSize + ", OM Temporary Store size unlimited: " + this.objectManagerTemporaryStoreSizeUnlimited + ", Data source class name: " + this.datasourceClassname + ", User name: " + this.datasourceUsername + ", Password: **********, Schema name: " + this.schemaName + ", Pool size: " + this.numberOfPooledConnections + ", Create tables: " + this.createTablesAutomatically + ", Clean start: " + this.cleanPersistenceOnStart + ", Properties: " + this.datasourceProperties + ", Permanent tables: " + this.numberOfPermanentTables + ", Temporary tables: " + this.numberOfTemporaryTables;
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }
}

