/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.mfp.impl.SchemaStoreItemStream;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Map;

public class SchemaStore {
    private static TraceComponent tc = SibTr.register(SchemaStore.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    static Map<MessageStore, SchemaStoreItemStream> schemaStores = new HashMap<MessageStore, SchemaStoreItemStream>();

    static void saveSchemas(MessageStore msgStore, JMFSchema[] schemas) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"saveSchemas");
        }
        try {
            SchemaStoreItemStream schemaStore = SchemaStore.getSchemaStore(msgStore);
            for (int i = 0; i < schemas.length; ++i) {
                if (schemaStore.containsSchema(schemas[i].getLongID())) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Saving schema:" + schemas[i].getID()));
                }
                schemaStore.addSchema(schemas[i], msgStore.getTransactionFactory().createAutoCommitTransaction());
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)((Object)e), (String)"saveSchemas", (String)"83");
            throw new MessageEncodeFailedException((Throwable)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"saveSchemas");
        }
    }

    static void loadSchemas(MessageStore msgStore, long[] schemaIds) throws MessageRestoreFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"loadSchemas");
        }
        try {
            SchemaStoreItemStream schemaStore = SchemaStore.getSchemaStore(msgStore);
            for (int i = 0; i < schemaIds.length; ++i) {
                if (JMFRegistry.instance.retrieve(schemaIds[i]) != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Restoring schema:" + schemaIds[i]));
                }
                JMFRegistry.instance.register(schemaStore.findSchema(schemaIds[i]));
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)((Object)e), (String)"loadSchemas", (String)"105");
            throw new MessageRestoreFailedException((Throwable)((Object)e));
        }
        catch (JMFException e) {
            FFDCFilter.processException((Throwable)e, (String)"loadSchemas", (String)"108");
            throw new MessageRestoreFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadSchemas");
        }
    }

    private static SchemaStoreItemStream getSchemaStore(MessageStore msgStore) throws MessageStoreException {
        SchemaStoreItemStream store;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSchemaStore");
        }
        if ((store = schemaStores.get(msgStore)) == null) {
            Filter filter = new Filter(){

                @Override
                public boolean filterMatches(AbstractItem item) {
                    return item instanceof SchemaStoreItemStream;
                }
            };
            store = (SchemaStoreItemStream)msgStore.findFirstMatching(filter);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && store != null) {
                SibTr.debug((TraceComponent)tc, (String)"Schema store found in message store");
            }
            if (store == null) {
                store = new SchemaStoreItemStream();
                msgStore.add(store, msgStore.getTransactionFactory().createAutoCommitTransaction());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"New schema store created");
                }
            }
            schemaStores.put(msgStore, store);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSchemaStore");
        }
        return store;
    }

    public static void messageStoreStoppingNotify(MessageStore msgStore) {
        schemaStores.remove(msgStore);
    }
}

