/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class JsDestinationAddressImpl
implements JsDestinationAddress,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = SibTr.register(JsDestinationAddressImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String TEMPORARY_QUEUE_DESTINATION_PREFIX = "_Q";
    private static final String TEMPORARY_TOPIC_DESTINATION_PREFIX = "_T";
    private String destinationName;
    private boolean localOnly;
    private transient SIBUuid8 meId;
    private String busName;
    private transient boolean temporary = false;
    private transient boolean temporarySet = false;

    JsDestinationAddressImpl(String destinationName, boolean localOnly, SIBUuid8 meId, String busName) {
        this(destinationName, localOnly, meId, busName, false);
    }

    JsDestinationAddressImpl(String destinationName, boolean localOnly, SIBUuid8 meId, String busName, boolean fromMediation) {
        this.destinationName = destinationName;
        this.localOnly = localOnly;
        this.meId = meId;
        this.busName = busName;
    }

    @Override
    public final boolean isTemporary() {
        if (!this.temporarySet) {
            if (this.destinationName.startsWith(TEMPORARY_QUEUE_DESTINATION_PREFIX) || this.destinationName.startsWith(TEMPORARY_TOPIC_DESTINATION_PREFIX)) {
                this.temporary = true;
            }
            this.temporarySet = true;
        }
        return this.temporary;
    }

    @Override
    public final String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public final boolean isLocalOnly() {
        return this.localOnly;
    }

    @Override
    public final SIBUuid8 getME() {
        return this.meId;
    }

    @Override
    public String getBusName() {
        return this.busName;
    }

    @Override
    public final void setME(SIBUuid8 meId) {
        this.meId = meId;
    }

    @Override
    public void setBusName(String busName) {
        this.busName = busName;
    }

    public final int hashCode() {
        int hash = 0;
        if (this.destinationName != null) {
            hash = this.destinationName.hashCode();
        }
        if (this.busName != null) {
            hash += this.busName.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj.hashCode() != this.hashCode()) {
            return false;
        }
        JsDestinationAddressImpl other = (JsDestinationAddressImpl)obj;
        if (!(other.getDestinationName() == this.destinationName || this.destinationName != null && this.destinationName.equals(other.getDestinationName()))) {
            return false;
        }
        if (!(other.getBusName() == this.busName || this.busName != null && this.busName.equals(other.getBusName()))) {
            return false;
        }
        if (this.meId == other.getME()) {
            return true;
        }
        return this.meId != null && this.meId.equals((Object)other.getME());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[ " + this.destinationName);
        buff.append(", " + this.localOnly);
        buff.append(", ");
        buff.append(this.meId == null ? null : this.meId.toString());
        buff.append(", " + this.busName);
        buff.append(" ]");
        return buff.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeObject");
        }
        out.defaultWriteObject();
        byte[] id = null;
        if (this.meId != null) {
            id = this.meId.toByteArray();
        }
        out.writeObject(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readObject");
        }
        in.defaultReadObject();
        byte[] id = (byte[])in.readObject();
        if (id != null) {
            this.meId = new SIBUuid8(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readObject");
        }
    }
}

