/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.servlets;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.ApplicationRegistry;
import io.openliberty.microprofile.openapi20.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.servlets.OpenAPIServletBase;
import io.openliberty.microprofile.openapi20.utils.Constants;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.utils.OpenAPIUtils;
import io.smallrye.openapi.runtime.io.Format;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;

@WebServlet(name="ApplicationServlet", urlPatterns={"/"}, loadOnStartup=1)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationServlet
extends OpenAPIServletBase {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ApplicationServlet.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Format responseFormat = this.getResponseFormat(request);
        String contentType = responseFormat == Format.JSON ? "application/json" : "text/plain";
        String requestURI = request.getRequestURI();
        if (Constants.REGEX_COMPONENT_REQUEST_URI.matcher(requestURI).matches()) {
            String document;
            OpenAPIProvider currentProvider = ApplicationRegistry.getInstance().getCurrentOpenAPIProvider();
            if (currentProvider != null) {
                if (currentProvider.getServersDefined()) {
                    document = currentProvider.getOpenAPIDocument(responseFormat);
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Server information was already set by the user. So not setting Liberty's server information", (Object[])new Object[0]);
                    }
                } else {
                    List<Server> servers = this.getOpenAPIModelServers(request, currentProvider.getApplicationPath());
                    document = currentProvider.getOpenAPIDocument(servers, responseFormat);
                }
            } else {
                OpenAPI defaultOpenAPIModel = OpenAPIUtils.createBaseOpenAPIDocument();
                defaultOpenAPIModel.setServers(this.getOpenAPIModelServers(request));
                document = OpenAPIUtils.getOpenAPIDocument(defaultOpenAPIModel, responseFormat);
            }
            if (document != null) {
                this.writeResponse(response, document, Response.Status.OK, contentType);
            } else {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Null document. Return 500.", (Object[])new Object[0]);
                }
                this.writeResponse(response, null, Response.Status.INTERNAL_SERVER_ERROR, contentType);
            }
        } else {
            this.writeResponse(response, null, Response.Status.NOT_FOUND, contentType);
        }
    }
}

