/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import io.openliberty.microprofile.openapi20.css.OpenAPIUIBundlesUpdater;
import io.openliberty.microprofile.openapi20.utils.CloudUtils;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CustomCSSWABUpdater {
    private static final TraceComponent tc = Tr.register(CustomCSSWABUpdater.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -3125976396610369114L;

    /*
     * WARNING - void declaration
     */
    public void restoreDefaults() {
        block3: {
            try {
                HashMap<String, Object> filesToUpdate = new HashMap<String, Object>();
                filesToUpdate.put("css/custom-header.css", "css/default-header.css");
                OpenAPIUIBundlesUpdater.updateResources(filesToUpdate, true);
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Updated the OpenAPI UI bundles with the default CSS file", (Object[])new Object[0]);
                }
            }
            catch (Exception filesToUpdate) {
                void e;
                FFDCFilter.processException((Throwable)filesToUpdate, (String)"io.openliberty.microprofile.openapi20.css.CustomCSSWABUpdater", (String)"45", (Object)this, (Object[])new Object[0]);
                if (!LoggingUtils.isEventEnabled(tc)) break block3;
                Tr.event((TraceComponent)tc, (String)"Exception restoring default CSS headers in WAB", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()});
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    public void update(Map<String, Object> cssData) {
        Object cssUrlObj = cssData.get("header-css-url");
        try {
            HashMap<String, Object> filesToUpdate = new HashMap<String, Object>();
            String cssContent = (String)cssData.get("header-css-content");
            filesToUpdate.put("css/custom-header.css", cssContent);
            if (cssContent.contains("background-image:") && cssUrlObj != null && cssUrlObj instanceof String) {
                this.processBackgroundImage((String)cssUrlObj, cssContent, filesToUpdate);
            }
            OpenAPIUIBundlesUpdater.updateResources(filesToUpdate, false);
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Updated the OpenAPI UI bundles with the custom CSS file " + cssUrlObj), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Tr.warning((TraceComponent)tc, (String)"CUSTOM_CSS_NOT_PROCESSED", (Object[])new Object[]{cssUrlObj.toString(), e.getClass().getName(), e.getLocalizedMessage()});
            this.restoreDefaults();
        }
    }

    private void processBackgroundImage(String cssUrl, String cssContent, Map<String, Object> filesToUpdate) throws URISyntaxException, IOException {
        if (!cssContent.contains("background-image: url(images/custom-logo.png);")) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"UNSUPPORTED_CSS_VALUE", (Object[])new Object[]{"background-image", "background-image: url(images/custom-logo.png);"}));
        }
        String parentPath = PathUtils.getParent((String)cssUrl);
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath.concat("/");
        }
        String backgroundImagePath = parentPath.concat("images/custom-logo.png");
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("backgroundImagePath=" + backgroundImagePath), (Object[])new Object[0]);
        }
        Serializable image = null;
        image = backgroundImagePath.startsWith("http:") || backgroundImagePath.startsWith("https:") ? new URL(backgroundImagePath) : new File(new URI(backgroundImagePath));
        this.validateImage(image);
        filesToUpdate.put("css/images/custom-logo.png", image);
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Added image to map at css/images/custom-logo.png", (Object[])new Object[0]);
        }
    }

    private void validateImage(Object img) throws IOException {
        if (img != null) {
            if (img instanceof File) {
                File aFile = (File)img;
                if (FileUtils.fileExists((File)aFile) && FileUtils.fileIsFile((File)aFile) && FileUtils.getInputStream((File)aFile) != null) {
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("File is valid :" + aFile.getAbsolutePath()), (Object[])new Object[0]);
                    }
                    return;
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CSS_BACKGROUND_IMAGE", (Object[])new Object[]{aFile.getAbsolutePath()}));
            }
            if (img instanceof URL) {
                URL url = (URL)img;
                if (CloudUtils.getUrlAsStream(url, "image/png") != null) {
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Image at URL is valid :" + url), (Object[])new Object[0]);
                    }
                    return;
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CSS_BACKGROUND_IMAGE", (Object[])new Object[]{url}));
            }
        }
    }

    public void serverStopping() {
        OpenAPIUIBundlesUpdater.serverStopping();
    }
}

