/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.ApplicationProcessor;
import io.openliberty.microprofile.openapi20.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationRegistry {
    private static final TraceComponent tc = Tr.register(ApplicationRegistry.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final ApplicationRegistry INSTANCE = new ApplicationRegistry();
    private Map<String, ApplicationInfo> applications = Collections.synchronizedMap(new HashMap());
    private ApplicationInfo currentApp = null;
    private OpenAPIProvider currentProvider = null;
    static final long serialVersionUID = -4820309680077992803L;

    public static ApplicationRegistry getInstance() {
        return INSTANCE;
    }

    public void addApplication(ApplicationInfo newAppInfo) {
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application started: appInfo=" + newAppInfo), (Object[])new Object[0]);
        }
        this.applications.put(newAppInfo.getName(), newAppInfo);
        this.processApplication(newAppInfo);
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Adding application ended: appInfo=" + newAppInfo), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(ApplicationInfo removedAppInfo) {
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application started: appInfo=" + removedAppInfo), (Object[])new Object[0]);
        }
        this.applications.remove(removedAppInfo.getName());
        if (this.currentApp != null && this.currentApp.getName().equals(removedAppInfo.getName())) {
            this.currentApp = null;
            this.currentProvider = null;
            Map<String, ApplicationInfo> map = this.applications;
            synchronized (map) {
                for (ApplicationInfo appInfo : this.applications.values()) {
                    this.processApplication(appInfo);
                    if (this.currentApp == null) continue;
                    break;
                }
            }
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Application Processor: Removing application ended: appInfo=" + removedAppInfo), (Object[])new Object[0]);
        }
    }

    public OpenAPIProvider getCurrentOpenAPIProvider() {
        return this.currentProvider;
    }

    private void processApplication(ApplicationInfo appInfo) {
        if (this.currentApp == null) {
            this.currentProvider = ApplicationProcessor.processApplication(appInfo);
            if (this.currentProvider != null) {
                this.currentApp = appInfo;
            }
        }
    }

    private ApplicationRegistry() {
    }
}

