/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.ApplicationRegistry;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ApplicationListener
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(ApplicationListener.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 285348364044018834L;

    /*
     * WARNING - void declaration
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        block4: {
            try {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application starting process started: " + appInfo), (Object[])new Object[0]);
                }
                ApplicationRegistry.getInstance().addApplication(appInfo);
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application starting process ended: " + appInfo), (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.ApplicationListener", (String)"46", (Object)this, (Object[])new Object[]{appInfo});
                if (!LoggingUtils.isEventEnabled(tc)) break block4;
                Tr.event((TraceComponent)tc, (String)("Failed to process application: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - void declaration
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        block2: {
            try {
                ApplicationRegistry.getInstance().removeApplication(appInfo);
            }
            catch (Throwable throwable) {
                void e;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.ApplicationListener", (String)"62", (Object)this, (Object[])new Object[]{appInfo});
                if (!LoggingUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Failed to remove application: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }
}

