/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.inbound.security;

import com.ibm.ws.jca.security.internal.J2CSecurityHelper;
import com.ibm.ws.jca.security.internal.SecWorkContextHandler;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.concurrent.RejectedExecutionException;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.security.auth.Subject;

public class SecurityInflowContext
implements ThreadContext {
    private static final long serialVersionUID = 4737189049209862723L;
    private final String resourceAdapterIdentifier;
    private final WorkContext securityContext;
    private final transient SubjectManager subjectManager = new SubjectManager();
    private final transient WSSecurityService securityService;
    private final transient UnauthenticatedSubjectService unauthSubjService;
    private final transient AuthenticationService authService;
    private final transient CredentialsService credService;
    private Subject priorCallerSubject;
    private Subject priorInvocationSubject;

    public SecurityInflowContext(CredentialsService credService, WSSecurityService wss, UnauthenticatedSubjectService unauthSubjService, AuthenticationService authService, Object securityContext, String resourceAdapterIdentifier) {
        this.resourceAdapterIdentifier = resourceAdapterIdentifier;
        this.securityContext = (WorkContext)securityContext;
        this.securityService = wss;
        this.authService = authService;
        this.unauthSubjService = unauthSubjService;
        this.credService = credService;
    }

    public ThreadContext clone() {
        try {
            SecurityInflowContext copy = (SecurityInflowContext)super.clone();
            copy.priorCallerSubject = null;
            copy.priorInvocationSubject = null;
            return copy;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
    }

    public void taskStarting() {
        try {
            SecWorkContextHandler.getInstance().associate(this.credService, this.securityService, this.unauthSubjService, this.authService, this.securityContext, this.resourceAdapterIdentifier);
            Subject subj = J2CSecurityHelper.getRunAsSubject();
            this.priorCallerSubject = this.subjectManager.getCallerSubject();
            this.priorInvocationSubject = this.subjectManager.getInvocationSubject();
            this.subjectManager.setCallerSubject(subj);
            this.subjectManager.setInvocationSubject(subj);
            if (this.securityContext instanceof WorkContextLifecycleListener) {
                ((WorkContextLifecycleListener)this.securityContext).contextSetupComplete();
            }
        }
        catch (WorkCompletedException x) {
            this.subjectManager.setCallerSubject(this.priorCallerSubject);
            this.subjectManager.setInvocationSubject(this.priorInvocationSubject);
            if (this.securityContext instanceof WorkContextLifecycleListener) {
                ((WorkContextLifecycleListener)this.securityContext).contextSetupFailed("3");
            }
            throw new RejectedExecutionException(x);
        }
    }

    public void taskStopping() {
        SecWorkContextHandler.getInstance().dissociate();
        this.subjectManager.setCallerSubject(this.priorCallerSubject);
        this.subjectManager.setInvocationSubject(this.priorInvocationSubject);
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        throw new NotSerializableException();
    }
}

