/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.Property;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ConfigEntry {
    private static TraceComponent tc = Tr.register(ConfigEntry.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public String className;
    public String name;
    public String instanceName;
    public String skipCacheAttribute;
    public HashSet allNames;
    public int sharingPolicy = 1;
    public HashMap properties;
    public CacheId[] cacheIds;
    public DependencyId[] dependencyIds;
    public Invalidation[] invalidations;
    public String appName;
    public int iClassName;
    public static final int SERVLET = 1;
    public static final int COMMAND = 2;
    public static final int WEB_SERVICE = 3;
    public static final int WEB_SERVICE_CLIENT = 4;
    public static final int STATIC = 5;
    public static final int PORTLET = 6;
    public Object[] processorData = null;

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("[CacheEntry]");
        pw.println("className     : " + this.className);
        pw.println("instanceName     : " + this.instanceName);
        pw.println("skipCacheAttribute : " + this.skipCacheAttribute);
        pw.println("name          : " + this.name);
        pw.println("all names      : " + this.allNames);
        pw.println("sharingPolicy : " + this.sharingPolicy);
        pw.println("appName : " + this.appName);
        if (this.properties != null && this.properties.size() > 0) {
            Iterator it = this.properties.values().iterator();
            while (it.hasNext()) {
                pw.println(((Property)it.next()).toString());
            }
        }
        for (i = 0; this.cacheIds != null && i < this.cacheIds.length; ++i) {
            pw.println("[CacheId " + i + "]");
            pw.println(this.cacheIds[i]);
        }
        for (i = 0; this.dependencyIds != null && i < this.dependencyIds.length; ++i) {
            pw.println("[Dependency " + i + "]");
            pw.println(this.dependencyIds[i]);
        }
        for (i = 0; this.invalidations != null && i < this.invalidations.length; ++i) {
            pw.println("[Invalidation " + i + "]");
            pw.println(this.invalidations[i]);
        }
        return sw.toString();
    }

    public String fancyFormat() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("[" + this.name + "]");
        pw.println("instanceName     : " + this.instanceName);
        pw.println("skip-cache-attribute : " + this.skipCacheAttribute);
        pw.println("className      : " + this.className);
        pw.println("sharing Policy : " + this.sharingPolicy + " " + (this.sharingPolicy == 1 ? "NOT_SHARED" : (this.sharingPolicy == 3 ? "SHARED_PULL" : (this.sharingPolicy == 2 ? "SHARED_PUSH" : (this.sharingPolicy == 4 ? "SHARED_PUSH_PULL" : "unknown")))));
        if (this.properties != null && this.properties.size() > 0) {
            Iterator it = this.properties.values().iterator();
            while (it.hasNext()) {
                pw.println(((Property)it.next()).fancyFormat(1));
            }
        }
        for (i = 0; this.cacheIds != null && i < this.cacheIds.length; ++i) {
            pw.println("[CacheId " + i + "]");
            pw.println(this.cacheIds[i].fancyFormat(1));
        }
        for (i = 0; this.dependencyIds != null && i < this.dependencyIds.length; ++i) {
            pw.println("[Dependency " + i + "]");
            pw.println(this.dependencyIds[i].fancyFormat(1));
        }
        for (i = 0; this.invalidations != null && i < this.invalidations.length; ++i) {
            pw.println("[Invalidation " + i + "]");
            pw.println(this.invalidations[i].fancyFormat(1));
        }
        return sw.toString();
    }

    public static String getESIDependencies(Enumeration e1, Enumeration e2) {
        if (!(e1 != null && e1.hasMoreElements() || e2 != null && e2.hasMoreElements())) {
            return null;
        }
        StringBuffer sb = new StringBuffer("dependencies=\"");
        if (e1 != null) {
            while (e1.hasMoreElements()) {
                sb.append(" ");
                sb.append((String)e1.nextElement());
            }
        }
        if (e2 != null) {
            while (e2.hasMoreElements()) {
                sb.append(" ");
                sb.append((String)e2.nextElement());
            }
        }
        return sb.toString();
    }

    public Object clone() {
        ConfigEntry ce = new ConfigEntry();
        ce.className = this.className;
        ce.iClassName = this.iClassName;
        ce.instanceName = this.instanceName;
        ce.skipCacheAttribute = this.skipCacheAttribute;
        ce.name = this.name;
        ce.allNames = this.allNames;
        ce.sharingPolicy = this.sharingPolicy;
        ce.appName = this.appName;
        if (this.properties != null) {
            ce.properties = new HashMap(this.properties.size());
            for (Object key : this.properties.keySet()) {
                ce.properties.put(key, ((Property)this.properties.get(key)).clone());
            }
        }
        if (this.cacheIds != null) {
            ce.cacheIds = new CacheId[this.cacheIds.length];
            for (int i = 0; i < this.cacheIds.length; ++i) {
                ce.cacheIds[i] = (CacheId)this.cacheIds[i].clone();
            }
        }
        if (this.dependencyIds != null) {
            ce.dependencyIds = new DependencyId[this.dependencyIds.length];
            for (int i = 0; i < this.dependencyIds.length; ++i) {
                ce.dependencyIds[i] = (DependencyId)this.dependencyIds[i].clone();
            }
        }
        if (this.invalidations != null) {
            ce.invalidations = new Invalidation[this.invalidations.length];
            for (int i = 0; i < this.invalidations.length; ++i) {
                ce.invalidations[i] = (Invalidation)this.invalidations[i].clone();
            }
        }
        if (this.processorData != null) {
            ce.processorData = new Object[this.processorData.length];
            for (int i = 0; i < this.processorData.length; ++i) {
                ce.processorData[i] = this.processorData[i];
            }
        }
        return ce;
    }
}

