/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.config;

import com.ibm.websphere.cache.EntryInfo;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.CacheId;
import com.ibm.ws.cache.config.Component;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.DependencyId;
import com.ibm.ws.cache.config.Invalidation;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Property;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.Value;
import com.ibm.ws.cache.intf.DCacheConfig;
import com.ibm.ws.cache.intf.JSPCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class CacheProcessor {
    private static TraceComponent tc = Tr.register(CacheProcessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final String PROPERTY_SHARING_POLICY = "sharing-policy";
    public static final String PROPERTY_SHARINGPOLICY = "sharingpolicy";
    public static final String PROPERTY_PERSIST_TO_DISK = "persist-to-disk";
    public static final String PROPERTY_DELAY_INVALIDATIONS = "delay-invalidations";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_INACTIVITY = "inactivity";
    public static final String PROPERTY_PRIORITY = "priority";
    public static final String PROPERTY_DO_NOT_CACHE = "do-not-cache";
    protected static final int SLOT_SHARINGPOLICY = 0;
    protected static final int SLOT_TIMEOUT = 1;
    protected static final int SLOT_PRIORITY = 2;
    protected static final int SLOT_PERSIST_TO_DISK = 3;
    protected static final int SLOT_INACTIVITY = 4;
    protected static final int SLOT_DO_NOT_CACHE = 5;
    protected static final int BASE_SLOTS = 6;
    protected boolean cacheable = false;
    protected StringBuffer id = new StringBuffer();
    protected ArrayList groupIds = null;
    protected ArrayList invalidationIds = null;
    protected ConfigEntry configEntry;
    protected boolean delayInvalidations = false;
    protected int timeout = -1;
    protected int inactivity = -1;
    protected int priority = -1;
    protected int sharingPolicy = -1;
    protected boolean persistToDisk = true;
    protected CacheId cacheIdForMetaDataGenerator = null;
    protected boolean doNotCache = false;
    protected static final Object[] emptyArgs = new Object[0];

    public CacheProcessor() {
    }

    public CacheProcessor(ConfigEntry configEntry) {
        this.configEntry = configEntry;
    }

    public void reset(ConfigEntry configEntry) {
        this.cacheable = false;
        this.id = new StringBuffer();
        this.groupIds = null;
        this.invalidationIds = null;
        this.configEntry = configEntry;
        this.delayInvalidations = false;
        this.timeout = -1;
        this.inactivity = -1;
        this.priority = -1;
        this.persistToDisk = true;
        this.sharingPolicy = configEntry != null ? configEntry.sharingPolicy : -1;
        this.doNotCache = false;
        if (this.cacheIdForMetaDataGenerator != null) {
            this.cacheIdForMetaDataGenerator.metaDataGeneratorImpl = null;
            this.cacheIdForMetaDataGenerator = null;
        }
    }

    public boolean preProcess(ConfigEntry configEntry) {
        Property p;
        String val;
        boolean valid = true;
        if (configEntry.processorData == null) {
            configEntry.processorData = new Object[6];
        }
        String string = val = (p = (Property)configEntry.properties.get(PROPERTY_PERSIST_TO_DISK)) != null ? p.value : null;
        if (val != null) {
            val = val.trim();
            configEntry.processorData[3] = new Boolean(val);
        }
        String string2 = val = (p = (Property)configEntry.properties.get(PROPERTY_DO_NOT_CACHE)) != null ? p.value : null;
        if (val != null) {
            configEntry.processorData[5] = new Boolean(val);
        }
        for (int i = 0; i < configEntry.cacheIds.length; ++i) {
            valid &= this.preProcess(configEntry.cacheIds[i]);
        }
        return valid;
    }

    public boolean preProcess(CacheId cacheId) {
        if (cacheId.processorData == null) {
            cacheId.processorData = new Object[6];
        }
        if (cacheId.properties != null) {
            String val;
            Property p = (Property)cacheId.properties.get(PROPERTY_SHARING_POLICY);
            String string = val = p != null ? p.value : null;
            if (val == null) {
                val = (String)cacheId.properties.get(PROPERTY_SHARINGPOLICY);
            }
            if (val != null) {
                if (val.equalsIgnoreCase("none")) {
                    cacheId.processorData[0] = new Integer(1);
                } else if (val.equalsIgnoreCase("pull")) {
                    cacheId.processorData[0] = new Integer(3);
                } else if (val.equalsIgnoreCase("push")) {
                    cacheId.processorData[0] = new Integer(2);
                } else if (val.equalsIgnoreCase("both")) {
                    cacheId.processorData[0] = new Integer(4);
                }
            }
            if ((p = (Property)cacheId.properties.get(PROPERTY_TIMEOUT)) != null) {
                val = p.value;
            }
            if (val != null) {
                cacheId.processorData[1] = new Integer(val);
            }
            if ((p = (Property)cacheId.properties.get(PROPERTY_INACTIVITY)) != null && (val = p.value) != null) {
                cacheId.processorData[4] = new Integer(val);
            }
            if ((p = (Property)cacheId.properties.get(PROPERTY_PRIORITY)) != null) {
                val = p.value;
            }
            if (val != null) {
                cacheId.processorData[2] = new Integer(val);
            }
            if ((p = (Property)cacheId.properties.get(PROPERTY_DO_NOT_CACHE)) != null && (val = p.value) != null) {
                cacheId.processorData[5] = new Boolean(val);
            }
        }
        return true;
    }

    public void processCacheIdProperties(CacheId cacheid) {
        if (cacheid.processorData[0] != null) {
            this.sharingPolicy = (Integer)cacheid.processorData[0];
        }
        if (cacheid.processorData[1] != null) {
            this.timeout = (Integer)cacheid.processorData[1];
        }
        if (cacheid.processorData[4] != null) {
            this.inactivity = (Integer)cacheid.processorData[4];
        }
        if (cacheid.processorData[2] != null) {
            this.priority = (Integer)cacheid.processorData[2];
        }
        if (cacheid.processorData[5] != null) {
            this.doNotCache = (Boolean)cacheid.processorData[5];
        }
    }

    public void processConfigEntryProperties() {
        if (this.configEntry.processorData[3] != null) {
            this.persistToDisk = (Boolean)this.configEntry.processorData[3];
        }
        if (this.configEntry.processorData[5] != null) {
            this.doNotCache = (Boolean)this.configEntry.processorData[5];
        }
    }

    protected abstract Object getComponentValue(Component var1);

    public String getBaseName() {
        return this.configEntry.name;
    }

    public boolean execute() {
        int i;
        this.cacheable = false;
        if (this.configEntry.cacheIds != null) {
            for (i = 0; !this.cacheable && i < this.configEntry.cacheIds.length; ++i) {
                this.id.append(this.getBaseName());
                this.cacheable = this.processCacheId(this.configEntry.cacheIds[i]);
                if (this.cacheable) continue;
                this.id.setLength(0);
            }
        }
        if (this.configEntry.dependencyIds != null) {
            for (i = 0; i < this.configEntry.dependencyIds.length; ++i) {
                this.processDependencyId(this.configEntry.dependencyIds[i]);
            }
        }
        if (this.configEntry.className.equalsIgnoreCase("command")) {
            Property p = (Property)this.configEntry.properties.get(PROPERTY_DELAY_INVALIDATIONS);
            if (p != null && "true".equalsIgnoreCase(p.value)) {
                this.delayInvalidations = true;
            }
        } else {
            this.setInvalidationIds();
        }
        return this.cacheable;
    }

    public String getId() {
        if (this.cacheable) {
            return this.id.toString();
        }
        return null;
    }

    public ArrayList getGroupIds() {
        return this.groupIds;
    }

    public ArrayList getInvalidationIds() {
        return this.invalidationIds;
    }

    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setEntryInfo(EntryInfo entryInfo) {
        entryInfo.setId(this.getId());
        entryInfo.addTemplate(this.getBaseName());
        if (this.cacheable) {
            entryInfo.setSharingPolicy(this.getSharingPolicy());
            entryInfo.setPersistToDisk(this.persistToDisk);
            entryInfo.setTimeLimit(this.getTimeout());
            entryInfo.setInactivity(this.getInactivity());
            if (this.getPriority() > 0) {
                entryInfo.setPriority(this.getPriority());
            }
            if (this.groupIds != null) {
                for (int i = 0; i < this.groupIds.size(); ++i) {
                    entryInfo.addDataId((String)this.groupIds.get(i));
                }
            }
            if (this.cacheIdForMetaDataGenerator != null) {
                this.processMetaDataGenerator(this.cacheIdForMetaDataGenerator);
            }
        }
    }

    public void setInvalidationIds() {
        if (this.configEntry.invalidations != null) {
            for (int i = 0; i < this.configEntry.invalidations.length; ++i) {
                this.processInvalidation(this.configEntry.invalidations[i]);
            }
        }
    }

    protected boolean processCacheId(CacheId cacheid) {
        boolean success = true;
        if (cacheid.idGenerator != null) {
            String cid = this.processIdGenerator(cacheid);
            if (cid == null) {
                success = false;
            } else {
                this.id.append(':');
                this.id.append(cid);
            }
        } else if (cacheid.components != null) {
            for (int i = 0; success && i < cacheid.components.length; ++i) {
                success = this.processComponent(cacheid.components[i], null, null, cacheid.components[i].required);
            }
        }
        if (success) {
            this.priority = cacheid.priority;
            this.timeout = cacheid.timeout;
            this.inactivity = cacheid.inactivity;
            this.cacheIdForMetaDataGenerator = null;
            if (cacheid.metaDataGenerator != null) {
                this.cacheIdForMetaDataGenerator = cacheid;
            }
            this.processConfigEntryProperties();
            this.processCacheIdProperties(cacheid);
        }
        return success;
    }

    protected abstract String processIdGenerator(CacheId var1);

    protected abstract void processMetaDataGenerator(CacheId var1);

    protected abstract String[] processInvalidationGenerator(Invalidation var1);

    protected boolean processComponent(Component comp, StringBuffer depId, ArrayList depIds, boolean isRequired) {
        JSPCache cache;
        DCacheConfig cacheConfig;
        boolean result = false;
        Object[] value = this.getComponentValue(comp);
        String compValue = null;
        if (value != null) {
            if (comp.iType == 11 || comp.iType == 0 || comp.iType == 1) {
                Object[] temp;
                if (value instanceof Collection) {
                    value = ((Collection)value).toArray();
                }
                if (value instanceof Object[] && (temp = value).length > 0) {
                    StringBuffer res = new StringBuffer();
                    for (int i = 0; i < temp.length; ++i) {
                        if (temp[i] == null) continue;
                        res.append(temp[i]);
                        res.append(",");
                    }
                    compValue = res.substring(0, res.length() - 1);
                }
            }
            if (compValue == null) {
                compValue = value.toString();
            }
            if (compValue != null) {
                Range r;
                int i;
                int compValueInt;
                result = true;
                if (comp.values != null && comp.values.size() != 0 || comp.valueRanges != null && comp.valueRanges.size() != 0) {
                    Value v;
                    boolean valueResult = false;
                    boolean rangeResult = false;
                    if (comp.values != null && comp.values.size() != 0 && (v = (Value)comp.values.get(compValue)) != null) {
                        valueResult = true;
                    }
                    try {
                        compValueInt = Integer.valueOf(compValue);
                        if (comp.valueRanges != null && comp.valueRanges.size() != 0) {
                            for (i = 0; i < comp.valueRanges.size(); ++i) {
                                r = (Range)comp.valueRanges.get(i);
                                if (r.low > compValueInt || compValueInt > r.high) continue;
                                rangeResult = true;
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        rangeResult = false;
                    }
                    boolean bl = result = valueResult || rangeResult;
                }
                if (comp.notValues != null && comp.notValues.size() != 0 || comp.notValueRanges != null && comp.notValueRanges.size() != 0) {
                    NotValue nv;
                    boolean valueResult = false;
                    boolean rangeResult = false;
                    if (comp.notValues != null && comp.notValues.size() != 0 && (nv = (NotValue)comp.notValues.get(compValue)) != null) {
                        valueResult = true;
                    }
                    try {
                        compValueInt = Integer.valueOf(compValue);
                        if (comp.notValueRanges != null && comp.notValueRanges.size() != 0) {
                            for (i = 0; i < comp.notValueRanges.size(); ++i) {
                                r = (Range)comp.notValueRanges.get(i);
                                if (r.low > compValueInt || compValueInt > r.high) continue;
                                rangeResult = true;
                            }
                        }
                    }
                    catch (Exception ex) {
                        rangeResult = false;
                    }
                    result = result && !valueResult && !rangeResult;
                }
            }
        } else {
            boolean bl = result = !isRequired;
        }
        if (result && compValue != null) {
            if (depId == null) {
                this.id.append(':');
                if (comp.id == null || comp.id.equals("")) {
                    comp.id = comp.type;
                }
                this.id.append(comp.id);
                if (!comp.ignoreValue) {
                    this.id.append('=');
                    this.id.append(compValue);
                }
            } else if (!comp.ignoreValue) {
                if (depId.length() != 0) {
                    depId.append(':');
                }
                depId.append(compValue);
                String multiIds = null;
                if (depIds != null) {
                    for (int i = 0; i < depIds.size(); ++i) {
                        multiIds = (String)depIds.get(i);
                        multiIds = multiIds + ":" + compValue;
                        depIds.set(i, multiIds);
                    }
                }
            }
        }
        if (!result && (cacheConfig = (cache = ServerCache.getJspCache(this.configEntry.instanceName)).getCache().getCacheConfig()).isUse602RequiredAttrCompatibility() && !isRequired) {
            boolean bl = result = !isRequired;
        }
        if (tc.isDebugEnabled() && !result) {
            Tr.debug((TraceComponent)tc, (String)("reason comp.id=" + comp.id + " result=" + result + " compValue=" + compValue), (Object[])new Object[0]);
        }
        return result;
    }

    protected void processDependencyId(DependencyId dependencyId) {
        if (dependencyId != null) {
            StringBuffer depId = new StringBuffer();
            depId.append(dependencyId.baseName);
            ArrayList<String> multipleIds = new ArrayList<String>();
            boolean success = true;
            for (int i = 0; success && i < dependencyId.components.length; ++i) {
                Object[] temp;
                String currentDepId = depId.toString();
                success = this.processComponent(dependencyId.components[i], depId, multipleIds, dependencyId.components[i].required);
                if (!dependencyId.components[i].multipleIds || dependencyId.components[i].iType != 11 && dependencyId.components[i].iType != 0 && dependencyId.components[i].iType != 1) continue;
                Object[] result = this.getComponentValue(dependencyId.components[i]);
                if (result instanceof Collection) {
                    result = ((Collection)result).toArray();
                }
                if (!(result instanceof Object[]) || (temp = result).length <= 0) continue;
                String multipleId = null;
                for (int j = 0; j < temp.length; ++j) {
                    if (temp[j] == null) continue;
                    multipleId = currentDepId + ":" + temp[j].toString();
                    multipleIds.add(multipleId);
                }
            }
            if (success) {
                if (this.groupIds == null) {
                    this.groupIds = new ArrayList();
                }
                this.groupIds.add(depId.toString());
                Iterator it = multipleIds.iterator();
                while (it.hasNext()) {
                    this.groupIds.add(it.next());
                }
            }
        }
    }

    protected void processInvalidation(Invalidation invalidation) {
        block8: {
            block9: {
                if (invalidation == null) break block8;
                if (invalidation.invalidationGenerator == null) break block9;
                String[] ids = this.processInvalidationGenerator(invalidation);
                if (ids == null) break block8;
                if (this.invalidationIds == null) {
                    this.invalidationIds = new ArrayList();
                }
                for (int i = 0; i < ids.length; ++i) {
                    String id = "";
                    id = invalidation.baseName != null && !invalidation.baseName.equals("") ? invalidation.baseName + ":" + ids[i] : ids[i];
                    this.invalidationIds.add(id);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("InvalidationGenerator - id=" + id), (Object[])new Object[0]);
                }
                break block8;
            }
            StringBuffer invId = new StringBuffer();
            invId.append(invalidation.baseName);
            ArrayList<String> multipleIds = new ArrayList<String>();
            boolean success = true;
            for (int i = 0; success && i < invalidation.components.length; ++i) {
                Object[] temp;
                String currentInvId = invId.toString();
                success = this.processComponent(invalidation.components[i], invId, multipleIds, invalidation.components[i].required);
                if (!invalidation.components[i].multipleIds || invalidation.components[i].iType != 11 && invalidation.components[i].iType != 0 && invalidation.components[i].iType != 1) continue;
                Object[] result = this.getComponentValue(invalidation.components[i]);
                if (result instanceof Collection) {
                    result = ((Collection)result).toArray();
                }
                if (!(result instanceof Object[]) || (temp = result).length <= 0) continue;
                String multipleId = null;
                for (int j = 0; j < temp.length; ++j) {
                    if (temp[j] == null) continue;
                    multipleId = currentInvId + ":" + temp[j].toString();
                    multipleIds.add(multipleId);
                }
            }
            if (success) {
                if (this.invalidationIds == null) {
                    this.invalidationIds = new ArrayList();
                }
                this.invalidationIds.add(invId.toString());
                Iterator it = multipleIds.iterator();
                while (it.hasNext()) {
                    this.invalidationIds.add(it.next());
                }
            }
        }
    }

    public boolean isDelayInvalidations() {
        return this.delayInvalidations;
    }

    public boolean getDoNotCache() {
        return this.doNotCache;
    }

    public ConfigEntry getConfigEntry() {
        return this.configEntry;
    }
}

