/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheInstanceInfo;
import com.ibm.ws.cache.CacheProviderLoaderImpl;
import com.ibm.ws.cache.CacheProviderWrapper;
import com.ibm.ws.cache.CacheService;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.CacheUnitImpl;
import com.ibm.ws.cache.NotificationService;
import com.ibm.ws.cache.NullNotificationService;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.intf.CommandCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.JSPCache;
import com.ibm.ws.cache.stat.CachePerfFactory;
import com.ibm.wsspi.cache.CacheFeatureSupport;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.cache.CoreCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ServerCache.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ServerCache {
    private static TraceComponent tc = Tr.register(ServerCache.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static volatile boolean coreCacheEnabled = false;
    public static volatile boolean servletCacheEnabled = false;
    public static volatile boolean objectCacheEnabled = false;
    public static CacheUnit cacheUnit = new CacheUnitImpl(new CacheConfig());
    public static DCache cache = null;
    public static CommandCache commandCache = null;
    public static JSPCache jspCache = null;
    private static int sharingPolicy = 1;
    private static int pushFrequency = 0;
    private static CacheService cacheService = null;
    private static final AtomicReference<CachePerfFactory> cachePerfFactoryRef = new AtomicReference();
    private static Map<String, DCache> cacheInstances = new ConcurrentHashMap<String, DCache>();

    public static int getSharingPolicy() {
        return sharingPolicy;
    }

    public static void setSharingPolicy(int i) {
        sharingPolicy = i;
    }

    public static int getPushFrequency() {
        return pushFrequency;
    }

    public static void setPushFrequency(int i) {
        pushFrequency = i;
    }

    @Trivial
    public static Map getCacheInstances() {
        return cacheInstances;
    }

    @Activate
    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
    }

    public static JSPCache getJspCache(String cacheName) {
        String methodName = "getJspCache()";
        JSPCache cacheOut = null;
        if (!servletCacheEnabled) {
            Tr.error((TraceComponent)tc, (String)"DYNA1059W", (Object[])new Object[]{cacheName});
        } else if (cacheName != null) {
            try {
                cacheOut = cacheUnit.getJSPCache(cacheName);
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"DYNA1003E", (Object[])new Object[]{cacheName, e});
            }
        } else {
            cacheOut = jspCache;
        }
        if (cacheOut == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getJspCache() could not find JSPCache for cacheName=" + cacheName), (Object[])new Object[0]);
        }
        return cacheOut;
    }

    public static CommandCache getCommandCache(String cacheName) {
        String methodName = "getCommandCache()";
        CommandCache cacheOut = null;
        if (!servletCacheEnabled) {
            Tr.error((TraceComponent)tc, (String)"DYNA1059W", (Object[])new Object[]{cacheName});
        } else if (cacheName != null) {
            try {
                cacheOut = cacheUnit.getCommandCache(cacheName);
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"DYNA1003E", (Object[])new Object[]{cacheName, e});
            }
        } else {
            cacheOut = commandCache;
        }
        if (cacheOut == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCommandCache() could not find CommandCache for cacheName=" + cacheName), (Object[])new Object[0]);
        }
        return cacheOut;
    }

    @Trivial
    public static DCache getCache(String cacheName) {
        String methodName = "getCache()";
        DCache cacheOut = cache;
        if (cacheName != null) {
            cacheName = ServerCache.normalizeCacheName(cacheName, null);
        }
        if (cacheName != null && !cacheName.equalsIgnoreCase("baseCache")) {
            cacheOut = cacheInstances.get(cacheName);
        }
        if (cacheOut == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCache() could not find cache for cacheName=" + cacheName), (Object[])new Object[0]);
        }
        return cacheOut;
    }

    public static DCache getConfiguredCache(String cacheName) {
        String methodName = "getConfiguredCache()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getConfiguredCache() input cacheName=" + cacheName), (Object[])new Object[0]);
        }
        DCache cacheOut = null;
        if (!coreCacheEnabled) {
            Tr.error((TraceComponent)tc, (String)"DYNA1003E", (Object[])new Object[]{cacheName, "Core Cache Service has not been started."});
        } else {
            cacheOut = ServerCache.getCache(cacheName);
            if (cacheOut == null) {
                CacheConfig config = ServerCache.getCacheService().getCacheInstanceConfig(cacheName);
                if (config == null) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1004E", (Object[])new Object[]{cacheName});
                    cacheOut = null;
                } else {
                    cacheOut = ServerCache.createCache(config.cacheName, config);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getConfiguredCache() output cacheName=" + (cacheOut != null ? cacheOut.getCacheName() : "null")));
        }
        return cacheOut;
    }

    public static synchronized DCache createCache(String cacheName, CacheConfig cacheConfig) {
        String methodName = "createCache()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createCache() cacheName=" + cacheName + " config=" + cacheConfig + " enableReplication=" + cacheConfig.enableCacheReplication + " provider: " + cacheConfig.cacheProviderName), (Object[])new Object[0]);
        }
        String tempCacheName = ServerCache.normalizeCacheName(cacheName, cacheConfig);
        cacheConfig.determineCacheProvider();
        DCache cacheOut = null;
        String errorString = "";
        boolean error = false;
        if (!coreCacheEnabled) {
            Tr.error((TraceComponent)tc, (String)"DYNA1003E", (Object[])new Object[]{cacheName, "Core Cache Service has not been started."});
        } else {
            cacheOut = ServerCache.getCache(tempCacheName);
            if (cacheOut == null) {
                String cacheProviderName = "default";
                CacheProvider cacheProvider = null;
                if (!cacheConfig.isDefaultCacheProvider()) {
                    cacheProviderName = cacheConfig.cacheProviderName;
                    cacheProvider = CacheProviderLoaderImpl.getInstance().getCacheProvider(cacheConfig.cacheProviderName);
                    if (cacheProvider != null) {
                        cacheConfig.cacheName = tempCacheName;
                        CoreCache coreCache = cacheProvider.createCache(cacheConfig);
                        CacheFeatureSupport featureSupport = cacheProvider.getCacheFeatureSupport();
                        if (coreCache == null || featureSupport == null) {
                            error = true;
                            errorString = "ENGLISH ONLY MESSAGE: coreCache == null || featureSupport == null....Check FFDC logs for Exceptions";
                        } else {
                            cacheUnit.startServices(false);
                            cacheOut = new CacheProviderWrapper(cacheConfig, featureSupport, coreCache);
                            cacheInstances.put(tempCacheName, cacheOut);
                            coreCache.start();
                            if (tempCacheName.equals("baseCache")) {
                                cache = cacheOut;
                            }
                            cacheConfig.cache = cacheOut;
                            cacheConfig.defaultProvider = false;
                            Tr.info((TraceComponent)tc, (String)"DYNA1001I", (Object[])new Object[]{tempCacheName});
                            Tr.info((TraceComponent)tc, (String)"DYNA1071I", (Object[])new Object[]{cacheProviderName});
                        }
                    } else {
                        error = true;
                        errorString = "ENGLISH ONLY MESSAGE: cacheProvider is null. Check for the cache provider libraries ";
                    }
                }
                if (error) {
                    Tr.error((TraceComponent)tc, (String)"DYNA1066E", (Object[])new Object[]{cacheConfig.cacheProviderName, cacheConfig.cacheName});
                    Tr.error((TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                    cacheConfig.resetProvider(tempCacheName);
                }
                if (cacheOut == null) {
                    cacheProviderName = "default";
                    cacheUnit.startServices(true);
                    cacheConfig.cache = cacheOut = new Cache(tempCacheName, cacheConfig);
                    cacheOut.setBatchUpdateDaemon(cacheUnit.getBatchUpdateDaemon());
                    CachePerfFactory factory = cachePerfFactoryRef.get();
                    cacheOut.setCachePerf(factory);
                    NotificationService ns = null;
                    RemoteServices rs = cacheUnit.getRemoteService();
                    rs.setNotificationService(new NullNotificationService());
                    cacheOut.setRemoteServices(rs);
                    cacheOut.setTimeLimitDaemon(cacheUnit.getTimeLimitDaemon());
                    cacheOut.setInvalidationAuditDaemon(cacheUnit.getInvalidationAuditDaemon());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cache settings are:  cacheSize=" + cacheConfig.cacheSize + " cachePriority=" + cacheConfig.cachePriority), (Object[])new Object[0]);
                    }
                    if (cacheConfig.enableCacheReplication && ns != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Cache Replication is enabled:  replicationDomain=" + cacheConfig.replicationDomain + " replicationType=" + cacheConfig.replicationType + " defaultShareType=" + cacheConfig.defaultShareType), (Object[])new Object[0]);
                        }
                        ns.setCacheStatisticsListener(cacheOut.getCacheStatisticsListener());
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"Cache Replication is not enabled", (Object[])new Object[0]);
                    }
                    cacheInstances.put(tempCacheName, cacheOut);
                    cacheOut.start();
                    if (tempCacheName.equals("baseCache")) {
                        cache = cacheOut;
                    }
                    Tr.info((TraceComponent)tc, (String)"DYNA1001I", (Object[])new Object[]{tempCacheName});
                    Tr.info((TraceComponent)tc, (String)"DYNA1071I", (Object[])new Object[]{cacheProviderName});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCache() normalized name=" + tempCacheName + " cache=" + cacheOut));
        }
        return cacheOut;
    }

    @Trivial
    public static String normalizeCacheName(String cacheName, CacheConfig cacheConfig) {
        String tempCacheName = cacheName;
        if (cacheName.equalsIgnoreCase("services/cache/basecache")) {
            tempCacheName = "baseCache";
        } else if (cacheName.equalsIgnoreCase("services/cache/distributedmap")) {
            tempCacheName = "default";
        }
        if (null != cacheConfig && !tempCacheName.equals(cacheConfig.cacheName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("normalized cacheName=" + cacheName + " does not match with cacheConfig cacheName=" + cacheConfig.cacheName), (Object[])new Object[0]);
            }
            cacheConfig.cacheName = tempCacheName;
        }
        return tempCacheName;
    }

    public static ArrayList getServletCacheInstanceNames() {
        ArrayList list = null;
        if (!servletCacheEnabled) {
            list = new ArrayList();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CacheMonitor: Servlet Cache Service has not been started.", (Object[])new Object[0]);
            }
        } else {
            list = ServerCache.getCacheService().getServletCacheInstanceNames();
        }
        return list;
    }

    public static CacheInstanceInfo[] getCacheInstanceInfo() {
        CacheInstanceInfo[] info = null;
        if (!coreCacheEnabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Core Cache Service has not been started.", (Object[])new Object[0]);
            }
        } else {
            info = ServerCache.getCacheService().getCacheInstanceInfo();
        }
        return info;
    }

    public static int getActiveCacheInstanceCount() {
        return cacheInstances.size();
    }

    public static ArrayList getObjectCacheInstanceNames() {
        ArrayList list = null;
        CacheService cs = ServerCache.getCacheService();
        if (cs != null) {
            list = cs.getObjectCacheInstanceNames();
        }
        return list;
    }

    @Reference(service=CacheService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, target="(id=baseCache)")
    protected void setCacheService(CacheService cs) {
    }

    public static void setCacheServiceEarly(CacheService cs) {
        cacheService = cs;
    }

    protected static void unsetCacheService(CacheService cs) {
        cacheService = null;
    }

    public static final CacheService getCacheService() {
        if (cacheService == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"*** Cache Service has not been started - null being returned (may cause NPEs).", (Object[])new Object[0]);
        }
        return cacheService;
    }

    @Reference(service=CachePerfFactory.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    protected void setCachePerfFactory(CachePerfFactory perfFactory) {
        cachePerfFactoryRef.set(perfFactory);
        for (DCache dcache : cacheInstances.values()) {
            dcache.setCachePerf(perfFactory);
        }
    }

    protected void unsetCachePerfFactory(CachePerfFactory perfFactory) {
        cachePerfFactoryRef.set(null);
        for (DCache dcache : cacheInstances.values()) {
            dcache.setCachePerf(null);
        }
    }
}

