/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.intf.ExternalInvalidation;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InvalidationAuditDaemon
extends RealTimeDaemon {
    TraceComponent tc = Tr.register(InvalidationAuditDaemon.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private long lastTimeCleared = 0L;
    private volatile Map<String, InvalidationTableList> cacheinvalidationTables = new ConcurrentHashMap<String, InvalidationTableList>(5, 0.75f, 2);

    public InvalidationAuditDaemon(int timeHoldingInvalidations) {
        super(timeHoldingInvalidations);
        this.lastTimeCleared = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUp(long startDaemonTime, long startWakeUpTime) {
        this.lastTimeCleared = startWakeUpTime;
        for (Map.Entry<String, InvalidationTableList> entry : this.cacheinvalidationTables.entrySet()) {
            InvalidationTableList invalidationTableList = entry.getValue();
            try {
                invalidationTableList.readWriteLock.writeLock().lock();
                invalidationTableList.pastIdSet.clear();
                Map<Object, InvalidationEvent> temp = invalidationTableList.pastIdSet;
                invalidationTableList.pastIdSet = invalidationTableList.presentIdSet;
                invalidationTableList.presentIdSet = invalidationTableList.futureIdSet;
                invalidationTableList.futureIdSet = temp;
                invalidationTableList.pastTemplateSet.clear();
                temp = invalidationTableList.pastTemplateSet;
                invalidationTableList.pastTemplateSet = invalidationTableList.presentTemplateSet;
                invalidationTableList.presentTemplateSet = invalidationTableList.futureTemplateSet;
                invalidationTableList.futureTemplateSet = temp;
            }
            finally {
                invalidationTableList.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidations(String cacheName, Iterator invalidations) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(cacheName);
        if (invalidationTableList != null) {
            try {
                invalidationTableList.readWriteLock.writeLock().lock();
                while (invalidations.hasNext()) {
                    try {
                        long timeStamp;
                        Object invalidation = invalidations.next();
                        if (invalidation instanceof InvalidateByIdEvent) {
                            InvalidateByIdEvent idEvent = (InvalidateByIdEvent)invalidation;
                            Object id = idEvent.getId();
                            InvalidateByIdEvent oldIdEvent = (InvalidateByIdEvent)invalidationTableList.presentIdSet.get(id);
                            timeStamp = idEvent.getTimeStamp();
                            if (oldIdEvent != null && oldIdEvent.getTimeStamp() >= timeStamp) continue;
                            invalidationTableList.presentIdSet.put(id, idEvent);
                            continue;
                        }
                        InvalidateByTemplateEvent templateEvent = (InvalidateByTemplateEvent)invalidation;
                        String template = templateEvent.getTemplate();
                        InvalidateByTemplateEvent oldTemplateEvent = (InvalidateByTemplateEvent)invalidationTableList.presentTemplateSet.get(template);
                        timeStamp = templateEvent.getTimeStamp();
                        if (oldTemplateEvent != null && oldTemplateEvent.getTimeStamp() >= timeStamp) continue;
                        invalidationTableList.presentTemplateSet.put(template, templateEvent);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.InvalidationAuditDaemon.registerInvalidations", (String)"126", (Object)this);
                    }
                }
            }
            finally {
                invalidationTableList.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry filterEntry(String cacheName, CacheEntry cacheEntry) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(cacheName);
        try {
            invalidationTableList.readWriteLock.readLock().lock();
            CacheEntry cacheEntry2 = this.internalFilterEntry(cacheName, invalidationTableList, cacheEntry);
            return cacheEntry2;
        }
        finally {
            invalidationTableList.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterEntryList(String cacheName, ArrayList incomingList) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(cacheName);
        try {
            invalidationTableList.readWriteLock.readLock().lock();
            Iterator it = incomingList.iterator();
            while (it.hasNext()) {
                CacheEntry cacheEntry;
                Object obj = it.next();
                if (!(obj instanceof CacheEntry) || this.internalFilterEntry(cacheName, invalidationTableList, cacheEntry = (CacheEntry)obj) != null) continue;
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("filterEntryList(): Filtered OUT cacheName=" + cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
                }
                it.remove();
            }
            ArrayList arrayList = incomingList;
            return arrayList;
        }
        finally {
            invalidationTableList.readWriteLock.readLock().unlock();
        }
    }

    private final CacheEntry internalFilterEntry(String cacheName, InvalidationTableList invalidationTableList, CacheEntry cacheEntry) {
        InvalidateByIdEvent idEvent = null;
        if (cacheEntry == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered cacheName=" + cacheName + " CE == NULL"), (Object[])new Object[0]);
            }
            return null;
        }
        if (cacheEntry.id == null) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered cacheName=" + cacheName + " id == NULL"), (Object[])new Object[0]);
            }
            return null;
        }
        long timeStamp = cacheEntry.getTimeStamp();
        idEvent = (InvalidateByIdEvent)invalidationTableList.presentIdSet.get(cacheEntry.id);
        if (idEvent != null && idEvent.getTimeStamp() > timeStamp) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered Found a more recent InvalidateByIdEvent for the cacheEntry in presentIdSet. cacheName=" + cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
            }
            return null;
        }
        if (this.collision(invalidationTableList.presentTemplateSet, cacheEntry.getTemplates(), timeStamp) || this.collision(invalidationTableList.presentIdSet, cacheEntry.getDataIds(), timeStamp)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered due to preexisting invalidations due to dependencies and templates in present template and IdSet. cacheName=" + cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
            }
            return null;
        }
        if (timeStamp > this.lastTimeCleared) {
            return cacheEntry;
        }
        idEvent = (InvalidateByIdEvent)invalidationTableList.pastIdSet.get(cacheEntry.id);
        if (idEvent != null && idEvent.getTimeStamp() > timeStamp) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered Found a more recent InvalidateByIdEvent for the cacheEntry in pastIdSet. cacheName=" + cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
            }
            return null;
        }
        if (this.collision(invalidationTableList.pastTemplateSet, cacheEntry.getTemplates(), timeStamp) || this.collision(invalidationTableList.pastIdSet, cacheEntry.getDataIds(), timeStamp)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterEntry(): Filtered due to preexisting invalidations due to dependencies and templates in past template and IdSet. cacheName=" + cacheName + " id=" + cacheEntry.id), (Object[])new Object[0]);
            }
            return null;
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalInvalidation filterExternalCacheFragment(String cacheName, ExternalInvalidation externalCacheFragment) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(cacheName);
        try {
            invalidationTableList.readWriteLock.readLock().lock();
            ExternalInvalidation externalInvalidation = this.internalFilterExternalCacheFragment(cacheName, invalidationTableList, externalCacheFragment);
            return externalInvalidation;
        }
        finally {
            invalidationTableList.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList filterExternalCacheFragmentList(String cacheName, ArrayList incomingList) {
        InvalidationTableList invalidationTableList = this.getInvalidationTableList(cacheName);
        try {
            invalidationTableList.readWriteLock.readLock().lock();
            Iterator it = incomingList.iterator();
            while (it.hasNext()) {
                ExternalInvalidation externalCacheFragment = (ExternalInvalidation)it.next();
                if (null != this.internalFilterExternalCacheFragment(cacheName, invalidationTableList, externalCacheFragment)) continue;
                if (this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("filterExternalCacheFragmentList(): Filtered OUT cacheName=" + cacheName + " uri=" + externalCacheFragment.getUri()), (Object[])new Object[0]);
                }
                it.remove();
            }
            ArrayList arrayList = incomingList;
            return arrayList;
        }
        finally {
            invalidationTableList.readWriteLock.readLock().unlock();
        }
    }

    private final ExternalInvalidation internalFilterExternalCacheFragment(String cacheName, InvalidationTableList invalidationTableList, ExternalInvalidation externalCacheFragment) {
        if (externalCacheFragment == null) {
            return null;
        }
        long timeStamp = externalCacheFragment.getTimeStamp();
        if (this.collision(invalidationTableList.presentTemplateSet, externalCacheFragment.getInvalidationIds(), timeStamp) || this.collision(invalidationTableList.presentIdSet, externalCacheFragment.getTemplates(), timeStamp)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterExternalCacheFragment(): Filtered due to preexisting invalidations due to dependencies and templates in present template and IdSet. cacheName=" + cacheName + " url=" + externalCacheFragment.getUri()), (Object[])new Object[0]);
            }
            return null;
        }
        if (timeStamp > this.lastTimeCleared) {
            return externalCacheFragment;
        }
        if (this.collision(invalidationTableList.pastTemplateSet, externalCacheFragment.getInvalidationIds(), timeStamp) || this.collision(invalidationTableList.pastIdSet, externalCacheFragment.getTemplates(), timeStamp)) {
            if (this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)("internalFilterExternalCacheFragment(): Filtered due to preexisting invalidations due to dependencies and templates in past template and IdSet. cacheName=" + cacheName + " url=" + externalCacheFragment.getUri()), (Object[])new Object[0]);
            }
            return null;
        }
        return externalCacheFragment;
    }

    private final boolean collision(Map<Object, InvalidationEvent> hashtable, Enumeration enumeration, long timeStamp) {
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            InvalidationEvent invalidationEvent = hashtable.get(key);
            if (invalidationEvent == null || invalidationEvent.getTimeStamp() <= timeStamp) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvalidationTableList getInvalidationTableList(String cacheName) {
        InvalidationTableList invalidationTableList = this.cacheinvalidationTables.get(cacheName);
        if (invalidationTableList == null) {
            InvalidationAuditDaemon invalidationAuditDaemon = this;
            synchronized (invalidationAuditDaemon) {
                invalidationTableList = new InvalidationTableList();
                this.cacheinvalidationTables.put(cacheName, invalidationTableList);
            }
        }
        return invalidationTableList;
    }

    public void cacheCleared(String cacheName) {
        InvalidationTableList list = this.cacheinvalidationTables.get(cacheName);
        if (list != null) {
            list.clear();
        }
    }

    static class InvalidationTableList {
        public Map<Object, InvalidationEvent> pastIdSet = new HashMap<Object, InvalidationEvent>(500);
        public Map<Object, InvalidationEvent> presentIdSet = new HashMap<Object, InvalidationEvent>(500);
        public Map<Object, InvalidationEvent> pastTemplateSet = new HashMap<Object, InvalidationEvent>(100);
        public Map<Object, InvalidationEvent> presentTemplateSet = new HashMap<Object, InvalidationEvent>(100);
        public Map<Object, InvalidationEvent> futureIdSet = new HashMap<Object, InvalidationEvent>(500);
        public Map<Object, InvalidationEvent> futureTemplateSet = new HashMap<Object, InvalidationEvent>(100);
        public ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        InvalidationTableList() {
        }

        public void clear() {
            try {
                this.readWriteLock.writeLock().lock();
                this.pastIdSet.clear();
                this.presentIdSet.clear();
                this.pastTemplateSet.clear();
                this.presentTemplateSet.clear();
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }
}

