/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.ValueSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HTODDependencyMap
extends ConcurrentHashMap {
    private static final long serialVersionUID = -867177773157684697L;
    private static TraceComponent tc = Tr.register(DependencyTable.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    Map<Object, Integer> cacheIdTable = null;
    boolean dependencyCacheIndexEnabled = false;

    public HTODDependencyMap(int initialCapacity, float loadFactor, int concurrencyLevel, boolean dependencyCacheIndexEnabled) {
        super(initialCapacity, loadFactor, concurrencyLevel);
        this.dependencyCacheIndexEnabled = dependencyCacheIndexEnabled;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dependencyCacheIndexEnabled=" + dependencyCacheIndexEnabled), (Object[])new Object[0]);
        }
        if (dependencyCacheIndexEnabled) {
            this.cacheIdTable = new HashMap<Object, Integer>(10 * initialCapacity);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.dependencyCacheIndexEnabled) {
            this.addToCacheIdTable((ValueSet)value);
        }
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        ValueSet valueSet = (ValueSet)super.remove(key);
        if (this.dependencyCacheIndexEnabled) {
            this.removeFromCacheIdTable(valueSet);
        }
        return valueSet;
    }

    @Override
    public boolean containsValue(Object id) {
        if (this.dependencyCacheIndexEnabled) {
            return this.cacheIdTable.containsKey(id);
        }
        boolean found = false;
        for (Map.Entry dependencyToCacheIDs : this.entrySet()) {
            if (!((Set)dependencyToCacheIDs.getValue()).contains(id)) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.cacheIdTable != null) {
            this.cacheIdTable.clear();
        }
        super.clear();
    }

    private void addToCacheIdTable(ValueSet valueSet) {
        for (Object cacheId : valueSet) {
            Integer count = this.cacheIdTable.get(cacheId);
            if (count != null) {
                this.cacheIdTable.put(cacheId, count + 1);
                continue;
            }
            this.cacheIdTable.put(cacheId, 1);
        }
    }

    private void removeFromCacheIdTable(ValueSet valueSet) {
        for (Object cacheId : valueSet) {
            Integer count = this.cacheIdTable.get(cacheId);
            if (count == null) continue;
            int counter = count;
            if (counter == 1) {
                this.cacheIdTable.remove(cacheId);
                continue;
            }
            this.cacheIdTable.put(cacheId, counter - 1);
        }
    }
}

