/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.util.AssertUtility;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheInstanceInfo {
    private static TraceComponent tc = Tr.register(CacheInstanceInfo.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static boolean assertRanOnce = false;
    private static CacheServiceImpl cacheService = null;
    private static long lastPopulate = 0L;
    private static long populateInterval = 3000L;
    private static CacheInstanceInfo cacheInstanceInfo = null;
    private static CacheInstanceInfo[] currentCacheInstanceInfoOut = null;
    static ArrayList<String> allFactory = new ArrayList();
    static ArrayList<String> allFile = new ArrayList();
    static ArrayList<String> allConfigured = new ArrayList();
    static ArrayList<String> allActive = new ArrayList();
    static ArrayList<String> objectConfigured = new ArrayList();
    static ArrayList<String> servletConfigured = new ArrayList();
    private String cacheName = null;
    private boolean isFactory = false;
    private boolean isFile = false;
    private boolean isActive = false;
    private boolean isObjectCache = false;
    private boolean isServletCache = false;

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean isFactory() {
        return this.isFactory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isObjectCache() {
        return this.isObjectCache;
    }

    public boolean isServletCache() {
        return this.isServletCache;
    }

    private CacheInstanceInfo() {
        String methodName = "<init>";
        assert (assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this));
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> cacheService=" + cacheService));
        }
    }

    static synchronized CacheInstanceInfo[] getCacheInstanceInfo(CacheServiceImpl cacheService) {
        CacheInstanceInfo[] infoOut = currentCacheInstanceInfoOut;
        if (System.currentTimeMillis() - lastPopulate > populateInterval) {
            if (cacheService != null) {
                if (cacheInstanceInfo == null) {
                    cacheInstanceInfo = new CacheInstanceInfo();
                }
                cacheService.populateCacheInstanceInfo(cacheInstanceInfo);
                CacheInstanceInfo.cacheService = cacheService;
                infoOut = new CacheInstanceInfo[allConfigured.size()];
                Iterator<String> i = allConfigured.iterator();
                int x = 0;
                while (i.hasNext()) {
                    String cacheName = i.next();
                    CacheInstanceInfo info = new CacheInstanceInfo();
                    info.cacheName = cacheName;
                    info.isActive = allActive.contains(cacheName);
                    info.isFactory = allFactory.contains(cacheName);
                    info.isFile = allFile.contains(cacheName);
                    info.isObjectCache = objectConfigured.contains(cacheName);
                    info.isServletCache = servletConfigured.contains(cacheName);
                    infoOut[x++] = info;
                }
                currentCacheInstanceInfoOut = infoOut;
                allConfigured.clear();
                allActive.clear();
                allFactory.clear();
                allFile.clear();
                objectConfigured.clear();
                servletConfigured.clear();
            }
            lastPopulate = System.currentTimeMillis();
        }
        return infoOut;
    }
}

