/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaConnectionInfo;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnection;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;

public final class SibRaManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
ValidatingManagedConnectionFactory {
    private static final long serialVersionUID = -736200360627318942L;
    private transient SICoreConnectionFactory _coreFactory;
    private transient PrintWriter _logWriter;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnection.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";

    public SibRaManagedConnectionFactory() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnectionFactory");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnectionFactory");
        }
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)connectionManager);
        }
        SibRaConnectionFactory connectionFactory = new SibRaConnectionFactory(this, connectionManager);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)connectionFactory);
        }
        return connectionFactory;
    }

    public Object createConnectionFactory() throws NotSupportedException {
        NotSupportedException exception = new NotSupportedException(NLS.getString("NON_MANAGED_ENVIRONMENT_CWSIV0351"));
        if (TRACE.isEventEnabled()) {
            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
        }
        throw exception;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo requestInfo) throws ResourceAdapterInternalException, ResourceException {
        SibRaManagedConnection managedConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)new Object[]{SibRaUtils.subjectToString(subject), requestInfo});
        }
        if (requestInfo == null) {
            ResourceAdapterInternalException exception = new ResourceAdapterInternalException(NLS.getString("NULL_REQUEST_INFO_CWSIV0352"));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
        if (requestInfo instanceof SibRaConnectionRequestInfo) {
            SICoreConnection coreConnection;
            SibRaConnectionRequestInfo sibRaRequestInfo = (SibRaConnectionRequestInfo)requestInfo;
            SibRaConnectionInfo connectionInfo = new SibRaConnectionInfo(this, subject, sibRaRequestInfo);
            try {
                coreConnection = sibRaRequestInfo.getCoreConnection() == null ? connectionInfo.createConnection() : sibRaRequestInfo.getCoreConnection().cloneConnection();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_2, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLONE_CWSIV0353", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLONE_CWSIV0353", new Object[]{exception}, null), (Throwable)exception);
            }
            try {
                managedConnection = new SibRaManagedConnection(this, connectionInfo, coreConnection);
                managedConnection.setLogWriter(this._logWriter);
            }
            catch (SIException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)ex));
                }
                throw new ResourceException(NLS.getFormattedMessage("CREATE_MANAGED_CONNECTION_CWSIV0355", new Object[]{ex}, null), (Throwable)ex);
            }
        }
        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_REQUEST_INFO_CWSIV0354", new Object[]{requestInfo, SibRaConnectionRequestInfo.class}, null));
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)managedConnection);
        }
        return managedConnection;
    }

    public ManagedConnection matchManagedConnections(Set potentialMatches, Subject subject, ConnectionRequestInfo requestInfo) throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matchManagedConnections", (Object)new Object[]{potentialMatches, SibRaUtils.subjectToString(subject), requestInfo});
        }
        SibRaManagedConnection match = null;
        if (requestInfo instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo sibRaRequestInfo = (SibRaConnectionRequestInfo)requestInfo;
            SibRaConnectionInfo connectionInfo = new SibRaConnectionInfo(this, subject, sibRaRequestInfo);
            Iterator iterator = potentialMatches.iterator();
            while (iterator.hasNext() && match == null) {
                SibRaManagedConnection potentialMatch;
                Object object = iterator.next();
                if (!(object instanceof SibRaManagedConnection) || !(potentialMatch = (SibRaManagedConnection)object).matches(connectionInfo, sibRaRequestInfo.getCoreConnection())) continue;
                match = potentialMatch;
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getString("UNRECOGNISED_REQUEST_INFO_CWSIV0354"));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matchManagedConnections", match);
        }
        return match;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return SibRaUtils.objectHashCode(this);
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "coreFactory", this._coreFactory);
        SibRaUtils.addFieldToString(buffer, "logWriter", this._logWriter);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    SICoreConnectionFactory getCoreFactory() throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCoreFactory");
        }
        if (this._coreFactory == null) {
            try {
                this._coreFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.getCoreFactory", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CONNECTION_FACTORY_ERROR_CWSIV0350", new Object[]{exception}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.getCoreFactory", (String)FFDC_PROBE_4, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CONNECTION_FACTORY_ERROR_CWSIV0350", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getCoreFactory", (Object)this._coreFactory);
        }
        return this._coreFactory;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getInvalidConnections", (Object)connectionSet);
        }
        HashSet<SibRaManagedConnection> invalidConnections = new HashSet<SibRaManagedConnection>();
        for (Object object : connectionSet) {
            SibRaManagedConnection potentialInvalidConnection;
            if (!(object instanceof SibRaManagedConnection) || (potentialInvalidConnection = (SibRaManagedConnection)object).isValid()) continue;
            invalidConnections.add(potentialInvalidConnection);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getInvalidConnections", invalidConnections);
        }
        return invalidConnections;
    }
}

