/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnection;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.io.Serializable;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;

final class SibRaConnectionFactory
implements SICoreConnectionFactory,
Serializable {
    private static final long serialVersionUID = -2706996958601844542L;
    private final SibRaManagedConnectionFactory _managedConnectionFactory;
    private final ConnectionManager _connectionManager;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionFactory.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();

    SibRaConnectionFactory(SibRaManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionFactory", (Object)new Object[]{managedConnectionFactory, connectionManager});
        }
        this._managedConnectionFactory = managedConnectionFactory;
        this._connectionManager = connectionManager;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionFactory");
        }
    }

    public SICoreConnection createConnection(String userName, String password, Map connectionProperties) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{userName, password == null ? null : "*****", connectionProperties});
        }
        SibRaConnectionRequestInfo requestInfo = new SibRaConnectionRequestInfo(userName, password, connectionProperties);
        SibRaConnection result = this.createConnection(requestInfo);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)result);
        }
        return result;
    }

    public SICoreConnection createConnection(Subject subject, Map connectionProperties) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{SibRaUtils.subjectToString(subject), connectionProperties});
        }
        SibRaConnectionRequestInfo connectionRequestInfo = new SibRaConnectionRequestInfo(subject, connectionProperties);
        SibRaConnection result = this.createConnection(connectionRequestInfo);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)result);
        }
        return result;
    }

    private SibRaConnection createConnection(ConnectionRequestInfo requestInfo) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)requestInfo);
        }
        SibRaConnection result = null;
        boolean tryAgain = true;
        do {
            try {
                Object connection = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, requestInfo);
                if (connection instanceof SibRaConnection) {
                    result = (SibRaConnection)connection;
                    SibRaManagedConnection managedConnection = result.getManagedConnection();
                    result.setConnectionFactory(this);
                    tryAgain = result.isCoreConnectionInValid();
                    if (tryAgain) {
                        SibTr.info((TraceComponent)TRACE, (String)NLS.getString("CONNECTION_ERROR_RETRY_CWSIV0356"), (Object)new Object[]{result.getManagedConnection().getConnectionException()});
                        requestInfo = (ConnectionRequestInfo)((SibRaConnectionRequestInfo)requestInfo).clone();
                        ((SibRaConnectionRequestInfo)requestInfo).incrementRequestCounter();
                        managedConnection.connectionErrorOccurred((Exception)new SIResourceException(), true);
                    }
                    continue;
                }
                ResourceAdapterInternalException exception = new ResourceAdapterInternalException(NLS.getFormattedMessage("INCORRECT_CONNECTION_TYPE_CWSIV0101", new Object[]{connection, SibRaConnection.class}, null));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw exception;
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionFactory.createConnection", (String)"1:318:1.21", (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                if (exception.getCause() instanceof SIResourceException) {
                    throw (SIResourceException)exception.getCause();
                }
                if (exception.getCause() instanceof SIErrorException) {
                    throw (SIErrorException)exception.getCause();
                }
                if (exception.getCause() instanceof SINotPossibleInCurrentConfigurationException) {
                    throw (SINotPossibleInCurrentConfigurationException)exception.getCause();
                }
                if (exception.getCause() instanceof SIIncorrectCallException) {
                    throw (SIIncorrectCallException)exception.getCause();
                }
                if (exception.getCause() instanceof SIAuthenticationException) {
                    throw (SIAuthenticationException)exception.getCause();
                }
                throw new SIResourceException(NLS.getString("CONNECTION_FACTORY_EXCEPTION_CWSIV0050"), (Throwable)exception);
            }
        } while (tryAgain);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)result);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "managedConnectionFactory", this._managedConnectionFactory);
        SibRaUtils.addFieldToString(buffer, "connectionManager", this._connectionManager);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    SibRaManagedConnectionFactory getManagedConnectionFactory() {
        return this._managedConnectionFactory;
    }

    public SICoreConnection createConnection(ClientConnection cc, String credentialType, String userid, String password) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{cc, credentialType, userid, password});
        }
        SibTr.error((TraceComponent)TRACE, (String)"This method should not have been called");
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", null);
        }
        return null;
    }
}

