/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.ant.WsTask2;
import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class WsGen2
extends WsTask2 {
    protected Path compileClasspath = null;
    private final List<ExternalMetadata> externalMetadataFiles = new ArrayList<ExternalMetadata>();
    protected boolean inlineSchemas;
    private File resourceDestDir = null;
    private boolean genWsdl = false;
    private String protocol = "";
    private String serviceName = null;
    private String portName = null;
    private String sei;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path classpath) {
        this.setClasspath(classpath);
    }

    public boolean getInlineSchemas() {
        return this.inlineSchemas;
    }

    public void setInlineSchemas(boolean inlineSchemas) {
        this.inlineSchemas = inlineSchemas;
    }

    public File getResourcedestdir() {
        return this.resourceDestDir;
    }

    public void setResourcedestdir(File resourceDir) {
        this.resourceDestDir = resourceDir;
    }

    public boolean getGenwsdl() {
        return this.genWsdl;
    }

    public void setGenwsdl(boolean genWsdl) {
        this.genWsdl = genWsdl;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServicename() {
        return this.serviceName;
    }

    public void setServicename(String name) {
        this.serviceName = name;
    }

    public String getPortname() {
        return this.portName;
    }

    public void setPortname(String name) {
        this.portName = name;
    }

    public String getSei() {
        return this.sei;
    }

    public void setSei(String endpointImplementationClass) {
        this.sei = endpointImplementationClass;
    }

    @Override
    protected CommandlineJava setupCommand() {
        CommandlineJava cmd = super.setupCommand();
        Path classpath = this.getClasspath();
        if (classpath != null && !classpath.toString().equals("")) {
            cmd.createArgument().setValue("-classpath");
            cmd.createArgument().setPath(classpath);
        }
        if (this.isXnocompile()) {
            cmd.createArgument().setValue("-Xnocompile");
        }
        if (this.getGenwsdl()) {
            String tmp = "-wsdl";
            if (this.protocol.length() > 0) {
                tmp = tmp + ":" + this.protocol;
            }
            cmd.createArgument().setValue(tmp);
            if (this.serviceName != null && this.serviceName.length() > 0) {
                cmd.createArgument().setValue("-servicename");
                cmd.createArgument().setValue(this.serviceName);
            }
            if (this.portName != null && this.portName.length() > 0) {
                cmd.createArgument().setValue("-portname");
                cmd.createArgument().setValue(this.portName);
            }
            if (this.getInlineSchemas()) {
                cmd.createArgument().setValue("-inlineSchemas");
            }
        }
        if (null != this.getResourcedestdir() && !this.getResourcedestdir().getName().equals("")) {
            cmd.createArgument().setValue("-r");
            cmd.createArgument().setFile(this.getResourcedestdir());
        }
        if (this.externalMetadataFiles != null) {
            for (ExternalMetadata file : this.externalMetadataFiles) {
                cmd.createArgument().setValue("-x");
                cmd.createArgument().setValue(file.file);
            }
        }
        for (String a : this.getJavacargs().getArguments()) {
            cmd.createArgument().setValue("-J" + a);
        }
        if (this.getSei() != null) {
            cmd.createArgument().setValue(this.getSei());
        }
        return cmd;
    }

    public void execute() throws BuildException {
        this.execute("wsgen", "com.sun.tools.ws.WsGen");
    }

    @Override
    protected boolean runInVm(String[] arguments, OutputStream out) {
        WsgenTool compTool = new WsgenTool(out);
        return compTool.run(arguments);
    }

    public ExternalMetadata createExternalMetadata() {
        ExternalMetadata e = new ExternalMetadata();
        this.externalMetadataFiles.add(e);
        return e;
    }

    public static class ExternalMetadata {
        String file;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

