/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.client.AttributeToSubjectExt;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl;
import com.ibm.ws.security.openidconnect.client.jose4j.OidcTokenImpl;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.token.Payload;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientAuthenticator {
    private static final TraceComponent tc = Tr.register(OidcClientAuthenticator.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    OidcClientUtil oidcClientUtil = new OidcClientUtil();
    private SSLSupport sslSupport;
    private final JwKRetriever retriever = null;
    private Jose4jUtil jose4jUtil = null;
    private OIDCClientAuthenticatorUtil authenticatorUtil = null;
    private static final String SIGNATURE_ALG_HS256 = "HS256";
    private static final String SIGNATURE_ALG_RS256 = "RS256";
    private static final String SIGNATURE_ALG_NONE = "none";
    private final AuthorizationCodeHandler authzCodeHandler = null;
    static final long serialVersionUID = -8207639822773439459L;

    public OidcClientAuthenticator() {
        this.authenticatorUtil = new OIDCClientAuthenticatorUtil();
    }

    public OidcClientAuthenticator(AtomicServiceReference<SSLSupport> sslSupportRef) {
        this.sslSupport = (SSLSupport)sslSupportRef.getService();
        this.jose4jUtil = new Jose4jUtil(this.sslSupport);
        this.authenticatorUtil = new OIDCClientAuthenticatorUtil(this.sslSupport);
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, OidcClientConfig clientConfig) {
        ProviderAuthenticationResult result = this.authenticatorUtil.authenticate(req, res, (ConvergedClientConfig)clientConfig);
        result = this.discoverOPAgain(result, clientConfig);
        result = this.fixSubject(result);
        result = this.invokeUserResolverSPI(result, clientConfig);
        return result;
    }

    private ProviderAuthenticationResult discoverOPAgain(ProviderAuthenticationResult result, OidcClientConfig clientConfig) {
        OidcClientConfigImpl oidcConfigImpl = (OidcClientConfigImpl)clientConfig;
        if (result.getStatus() != AuthResult.SUCCESS && oidcConfigImpl.isDiscoveryInUse() && System.currentTimeMillis() > oidcConfigImpl.getNextDiscoveryTime()) {
            oidcConfigImpl.handleDiscoveryEndpoint(oidcConfigImpl.getDiscoveryEndpointUrl());
        } else if (result.getStatus() == AuthResult.SUCCESS && oidcConfigImpl.isDiscoveryInUse()) {
            oidcConfigImpl.setNextDiscoveryTime();
        }
        return result;
    }

    private ProviderAuthenticationResult invokeUserResolverSPI(ProviderAuthenticationResult result, OidcClientConfig config) {
        if (result.getCustomProperties() == null) {
            return result;
        }
        OidcTokenImplBase idToken = (OidcTokenImplBase)result.getCustomProperties().get("id_token_object");
        if (idToken == null) {
            return result;
        }
        result.getCustomProperties().remove("id_token_object");
        AttributeToSubjectExt a2s = new AttributeToSubjectExt(config, idToken);
        if (!a2s.isTokenMappingSpi()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"token mapping SPI is not active", (Object[])new Object[0]);
            }
            return result;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"token mapping SPI is active, updating mapping.", (Object[])new Object[0]);
        }
        Hashtable customProperties = result.getCustomProperties();
        customProperties.remove("com.ibm.wsspi.security.cred.uniqueId");
        customProperties.remove("com.ibm.wsspi.security.cred.realm");
        customProperties.remove("com.ibm.wsspi.security.cred.groups");
        result = a2s.doMapping(result.getCustomProperties(), result.getSubject());
        return result;
    }

    ProviderAuthenticationResult fixSubject(ProviderAuthenticationResult result) {
        Object o;
        if (result.getSubject() == null) {
            return result;
        }
        Set<Object> creds = result.getSubject().getPrivateCredentials();
        if (creds.size() > 0 && (o = creds.iterator().next()) instanceof OidcTokenImplBase) {
            creds.remove(o);
            creds.add((Object)new OidcTokenImpl((OidcTokenImplBase)o));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"idToken in subject is replaced with OidcTokenImpl", (Object[])new Object[0]);
            }
        }
        return result;
    }

    ProviderAuthenticationResult handleRedirectToServer(HttpServletRequest req, HttpServletResponse res, OidcClientConfig clientConfig) {
        return this.authenticatorUtil.handleRedirectToServer(req, res, (ConvergedClientConfig)clientConfig);
    }

    /*
     * WARNING - void declaration
     */
    Hashtable<String, String> getAuthzCodeAndStateFromCookie(IExtendedRequest req, HttpServletResponse res) {
        Hashtable hashtable;
        block5: {
            byte[] cookieValueBytes = req.getCookieValueAsBytes("WASOidcCode");
            if (cookieValueBytes == null || cookieValueBytes.length == 0) {
                return null;
            }
            OidcClientUtil.invalidateReferrerURLCookie((HttpServletRequest)req, (HttpServletResponse)res, (String)"WASOidcCode");
            byte[] bParams = Base64Coder.base64Decode((byte[])cookieValueBytes);
            ByteArrayInputStream inParamsStream = new ByteArrayInputStream(bParams);
            hashtable = null;
            try {
                ObjectInputStream inParamsObjStream = new ObjectInputStream(inParamsStream);
                hashtable = (Hashtable)inParamsObjStream.readObject();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.OidcClientAuthenticator", (String)"218", (Object)this, (Object[])new Object[]{req, res});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("getAuthzCodeAndState encounted an un-expected exception: " + e), (Object[])new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                void ex;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.client.OidcClientAuthenticator", (String)"222", (Object)this, (Object[])new Object[]{req, res});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("getAuthzCodeAndState encounted an un-expected exception: " + ex), (Object[])new Object[0]);
            }
        }
        return hashtable;
    }

    void doIdAssertion(Hashtable<String, Object> customProperties, Payload payload, OidcClientConfig clientConfig) {
        String uniqueSecurityName;
        if (clientConfig.isMapIdentityToRegistryUser()) {
            return;
        }
        if (payload == null) {
            return;
        }
        String realm = (String)payload.get((Object)clientConfig.getRealmIdentifier());
        if (realm == null || realm.isEmpty()) {
            realm = (String)payload.get((Object)"iss");
        }
        if ((uniqueSecurityName = (String)payload.get((Object)clientConfig.getUniqueUserIdentifier())) == null || uniqueSecurityName.isEmpty()) {
            uniqueSecurityName = (String)payload.get((Object)clientConfig.getUserIdentityToCreateSubject());
        }
        String uniqueID = new StringBuffer("user:").append(realm).append("/").append(uniqueSecurityName).toString();
        ArrayList groupIds = (ArrayList)payload.get((Object)clientConfig.getGroupIdentifier());
        ArrayList<String> groups = new ArrayList<String>();
        if (groupIds != null && !groupIds.isEmpty()) {
            Iterator it = groupIds.iterator();
            while (it.hasNext()) {
                String group = new StringBuffer("group:").append(realm).append("/").append(it.next()).toString();
                groups.add(group);
            }
        }
        customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
        if (realm != null && !realm.isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
        }
        if (groups != null && !groups.isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.groups", groups);
        }
        if (clientConfig.isDisableLtpaCookie()) {
            customProperties.put("com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie", Boolean.TRUE);
        }
    }

    public String getIssuerIdentifier(OidcClientConfig clientConfig) {
        return this.authenticatorUtil.getIssuerIdentifier((ConvergedClientConfig)clientConfig);
    }

    String getReqURL(HttpServletRequest req) {
        String queryString;
        boolean rewritePort = false;
        Integer realPort = null;
        if (req.getScheme().toLowerCase().contains("https")) {
            realPort = new WebUtils().getRedirectPortFromRequest(req);
        }
        int port = req.getServerPort();
        if (realPort != null && realPort != port) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serverport = " + port + "real port is " + realPort.toString() + ", url will be rewritten to use real port"), (Object[])new Object[0]);
            }
            rewritePort = true;
        }
        StringBuffer reqURL = req.getRequestURL();
        if (rewritePort) {
            reqURL = new StringBuffer();
            reqURL.append(req.getScheme());
            reqURL.append("://");
            reqURL.append(req.getServerName());
            reqURL.append(":");
            reqURL.append(realPort);
            reqURL.append(req.getRequestURI());
        }
        if ((queryString = req.getQueryString()) != null) {
            reqURL.append("?");
            reqURL.append(OidcUtil.encodeQuery((String)queryString));
        }
        return reqURL.toString();
    }

    protected SSLContext getSSLContext(String tokenUrl, String sslConfigurationName, String clientId) throws SSLException {
        SSLContext sslContext = null;
        JSSEHelper jsseHelper = this.getJSSEHelper();
        if (jsseHelper != null) {
            sslContext = jsseHelper.getSSLContext(sslConfigurationName, null, null, true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslContext () get: " + sslContext), (Object[])new Object[0]);
            }
        }
        if (sslContext == null && tokenUrl != null && tokenUrl.startsWith("https")) {
            throw new SSLException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl conext", clientId}));
        }
        return sslContext;
    }

    protected JSSEHelper getJSSEHelper() throws SSLException {
        if (this.sslSupport != null) {
            return this.sslSupport.getJSSEHelper();
        }
        return null;
    }
}

