/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.cdi.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSocketInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    private static final TraceComponent tc = Tr.register(WebSocketInjectionClassListCollaborator.class, (String)"websockets", null);
    private static final String[] INJECTION_SUPER_CLASSES = new String[]{"javax.websocket.Endpoint"};
    static final long serialVersionUID = 3237434130876184251L;

    @FFDCIgnore(value={UnableToAdaptException.class})
    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> injectionClassNames;
        block7: {
            String methodName = "getInjectionClasses";
            injectionClassNames = new ArrayList<String>();
            try {
                WebAnnotations webAnno = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
                AnnotationTargets_Targets annoTargets = webAnno.getAnnotationTargets();
                Set endpointClassNames = annoTargets.getAnnotatedClasses("javax.websocket.server.ServerEndpoint");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"ServerEndpoint annotated classes: " + endpointClassNames});
                }
                injectionClassNames.addAll(endpointClassNames);
                for (String injectionSuperClass : INJECTION_SUPER_CLASSES) {
                    Set implementorClassNames = annoTargets.getSubclassNames(injectionSuperClass);
                    for (String implementorClassName : implementorClassNames) {
                        if (injectionClassNames.contains(implementorClassName)) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Already added: Extender of: " + injectionSuperClass + ": " + implementorClassName});
                            continue;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Add: Extender of: " + injectionSuperClass + ": " + implementorClassName});
                        }
                        injectionClassNames.add(implementorClassName);
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Failed to adapt class annotations", (Object[])new Object[]{e});
            }
        }
        return injectionClassNames;
    }
}

