/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.jmx;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.jmx.PmiCollaboratorMBean;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.Locale;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PmiCollaborator
implements PmiCollaboratorMBean {
    private static final TraceComponent tc = Tr.register(PmiCollaborator.class, (String)"pmi", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    private static PmiCollaborator _instance = null;
    static final long serialVersionUID = 5542038412590838845L;

    private PmiCollaborator() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init: PmiCollaboratorImpl", (Object[])new Object[0]);
        }
    }

    public static PmiCollaborator getSingletonInstance() {
        if (_instance == null) {
            _instance = new PmiCollaborator();
        }
        return _instance;
    }

    @Override
    @ManualTrace
    public StatDescriptor[] listStatMembers(StatDescriptor sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listStatMembers(StatDescriptor, Boolean)", (Object[])new Object[0]);
        }
        StatDescriptor[] members = PmiRegistry.listStatMembers(sd, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listStatMembers(StatDescriptor, Boolean)");
        }
        return members;
    }

    @Override
    @ManualTrace
    public void setStatisticSet(String statSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setStatisticSet(statSet): " + statSet), (Object[])new Object[0]);
        }
        PmiRegistry.setInstrumentationLevel(statSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStatisticSet(statSet)");
        }
    }

    @Override
    @ManualTrace
    public String getCustomSetString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCustomSetString", (Object[])new Object[0]);
        }
        String ret = PmiRegistry.getInstrumentationLevelString60();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCustomSetString");
        }
        return ret;
    }

    @Override
    @ManualTrace
    public void setCustomSetString(String setting, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setCustomSetString (String, Boolean): " + setting), (Object[])new Object[0]);
        }
        this.setInstrumentationLevel(this._createSLSFromString(setting), recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCustomSetString");
        }
    }

    @Override
    @ManualTrace
    public void appendCustomSetString(String setting, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("appendCustomSetString (String, Boolean): " + setting), (Object[])new Object[0]);
        }
        this.appendInstrumentationLevel(this._createSLSFromString(setting), recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendCustomSetString");
        }
    }

    private StatLevelSpec[] _createSLSFromString(String spec) {
        StringTokenizer psr1 = new StringTokenizer(spec, ":");
        int s = psr1.countTokens();
        StatLevelSpec[] sls = new StatLevelSpec[s];
        int k = 0;
        while (psr1.hasMoreTokens()) {
            sls[k++] = this._createSLS(psr1.nextToken());
        }
        return sls;
    }

    private StatLevelSpec _createSLS(String spec) {
        String enable;
        String[] sd;
        StringTokenizer psr1 = new StringTokenizer(spec, "=");
        try {
            sd = PmiCollaborator.parsePath(psr1.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        try {
            enable = psr1.nextToken();
        }
        catch (Exception e) {
            enable = null;
        }
        return new StatLevelSpec(sd, PmiCollaborator.parseSpecStr(enable));
    }

    private static String[] parsePath(String path) {
        StringTokenizer p = new StringTokenizer(path, ">");
        String[] ret = new String[p.countTokens()];
        int i = 0;
        while (p.hasMoreTokens()) {
            ret[i++] = p.nextToken();
        }
        return ret;
    }

    public static int[] parseSpecStr(String in) {
        if (in == null) {
            return new int[0];
        }
        in = in.replaceAll(" ", "");
        if ((in = in.trim()).length() == 0) {
            return new int[0];
        }
        String[] tokens = in.split(",");
        int[] toReturn = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            try {
                toReturn[i] = Integer.parseInt(tokens[i]);
                continue;
            }
            catch (NumberFormatException e) {
                toReturn[i] = tokens[i].equals("*") && i == 0 ? -3 : -1;
            }
        }
        return toReturn;
    }

    @Override
    @ManualTrace
    public WSStats[] getStatsArray(StatDescriptor[] sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStatsArray (StatDescriptor[], Boolean)", (Object[])new Object[0]);
        }
        if (sd == null || sd.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"StatDescriptor is null or empty");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(sd, recursive, new PmiModuleConfig(null));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStatsArray (StatDescriptor[], Boolean)");
        }
        return stats;
    }

    @Override
    public String queryAllStatsAsString() {
        WSStats[] s = this.getStatsArray(new StatDescriptor[]{new StatDescriptor(null)}, (Boolean)true);
        if (s == null) {
            return "No PMI Data found.";
        }
        return s[0].toString();
    }

    @Override
    @ManualTrace
    public void setInstrumentationLevel(StatLevelSpec[] mlss, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentationLevel (StatLevelSpec[], Boolean)", (Object[])new Object[0]);
        }
        if (mlss == null || mlss.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"StatLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.setInstrumentationLevel(mlss, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
    }

    @ManualTrace
    public void appendInstrumentationLevel(StatLevelSpec[] mlss, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appendInstrumentationLevel (StatLevelSpec[], Boolean)", (Object[])new Object[0]);
        }
        if (mlss == null || mlss.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"StatLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.appendInstrumentationLevel(mlss, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appendInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
    }

    @Override
    @ManualTrace
    public StatLevelSpec[] getInstrumentationLevel(StatDescriptor sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstrumentationLevel (StatDescriptor, Boolean)", (Object[])new Object[0]);
        }
        if (sd == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel (StatDescriptor, Boolean)");
            }
            return null;
        }
        StatLevelSpec[] specs = PmiRegistry.getInstrumentationLevel(sd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel (StatDescriptor, Boolean)");
        }
        return specs;
    }

    @Deprecated
    @ManualTrace
    public PmiModuleConfig[] getConfigs() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigs", (Object[])new Object[0]);
        }
        PmiModuleConfig[] configs = PmiRegistry.getConfigs();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigs");
        }
        return configs;
    }

    @Override
    @ManualTrace
    public PmiModuleConfig[] getConfigs(Locale l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigs(Locale)", (Object[])new Object[0]);
        }
        PmiModuleConfig[] configs = PmiRegistry.getConfigs(l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigs(Locale)");
        }
        return configs;
    }

    @Override
    @ManualTrace
    public PmiModuleConfig getConfig(String statsType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfig(String)", (Object[])new Object[0]);
        }
        PmiModuleConfig configs = PmiRegistry.getConfig(statsType);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfig(String)");
        }
        return configs;
    }

    @Deprecated
    @ManualTrace
    public String getInstrumentationLevelString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstrumentationLevelString", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevelString");
        }
        return PmiRegistry.getInstrumentationLevelString();
    }

    @Deprecated
    @ManualTrace
    public WSStats getStatsObject(DataDescriptor dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStatsObject(DataDescriptor, Boolean)", (Object[])new Object[0]);
        }
        StatsImpl stat = PmiRegistry.getStats(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getStatsObject(DataDescriptor, Boolean)");
        }
        return stat;
    }

    @Deprecated
    @ManualTrace
    public WSStats[] getStatsArray(DataDescriptor[] dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStatsArray(DataDescriptor[], Boolean)", (Object[])new Object[0]);
        }
        if (dd == null || dd.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getStatsArray(DataDescriptor[], Boolean)");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getStatsArray(DataDescriptor)" + stats.length));
        }
        return stats;
    }

    @Deprecated
    @ManualTrace
    public DataDescriptor[] listStatMembers(DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listStatMembers(DataDescriptor)", (Object[])new Object[0]);
        }
        DataDescriptor[] members = PmiRegistry.listMembers(dd);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listStatMembers(DataDescriptor)");
        }
        return members;
    }

    @Deprecated
    @ManualTrace
    public void setInstrumentationLevel(PerfLevelDescriptor pld, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentationLevel(PerfLevelDescriptor, Boolean)", (Object[])new Object[0]);
        }
        PmiRegistry.setInstrumentationLevel(pld, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    @Deprecated
    @ManualTrace
    public void setInstrumentationLevel(PerfLevelDescriptor[] pld, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentationLevel(PerfLevelDescriptor[], Boolean)", (Object[])new Object[0]);
        }
        PmiRegistry.setInstrumentationLevel(pld, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    @Deprecated
    @ManualTrace
    public PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstrumentationLevel(DataDescriptor, Boolean)", (Object[])new Object[0]);
        }
        if (dd == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel(DataDescriptor)");
            }
            return null;
        }
        PerfLevelDescriptor[] specs = PmiRegistry.getInstrumentationLevel(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstrumentationLevel(DataDescriptor)");
        }
        return specs;
    }
}

