/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class CommonCache {
    protected int entryLimit = 50000;
    protected long timeoutInMilliSeconds = 300000L;
    protected Timer timer;
    static final long serialVersionUID = -966540817961818580L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public int size() {
        return this.entryLimit;
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliSeconds;
    }

    public abstract void remove(@Sensitive Object var1);

    public abstract Object get(@Sensitive String var1);

    public abstract void put(@Sensitive String var1, Object var2);

    public synchronized void rescheduleCleanup(long newTimeoutInMillis) {
        if (newTimeoutInMillis > 0L) {
            this.timeoutInMilliSeconds = newTimeoutInMillis;
        }
        this.timer.cancel();
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    protected void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    protected abstract void evictStaleEntries();

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache", CommonCache.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = 8035657797859227659L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            CommonCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache$EvictionTask", EvictionTask.class, null, null);
        }
    }
}

