/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class BundleHookBundleTracker<T>
extends BundleTracker {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    final BundleTrackerCustomizer customizer;
    private volatile Tracked tracked;
    private final int mask;
    private ServiceRegistration sr;

    private Tracked tracked() {
        return this.tracked;
    }

    public BundleHookBundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        super(context, stateMask, customizer);
        this.context = context;
        this.mask = stateMask;
        this.customizer = customizer == null ? this : customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        BundleHookBundleTracker bundleHookBundleTracker = this;
        synchronized (bundleHookBundleTracker) {
            Tracked t;
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = new Tracked();
            synchronized (tracked) {
                BundleEventHook hook = new BundleEventHook(t);
                this.sr = this.context.registerService(EventHook.class.getName(), (Object)hook, null);
                Bundle[] bundles = this.context.getBundles();
                if (bundles != null) {
                    int length = bundles.length;
                    for (int i = 0; i < length; ++i) {
                        int state = bundles[i].getState();
                        if ((state & this.mask) != 0) continue;
                        bundles[i] = null;
                    }
                    t.setInitial(bundles);
                }
            }
            this.tracked = t;
        }
        this.tracked.trackInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Bundle[] bundles;
        Tracked outgoing;
        BundleHookBundleTracker bundleHookBundleTracker = this;
        synchronized (bundleHookBundleTracker) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            this.tracked.close();
            bundles = this.getBundles();
            this.tracked = null;
            try {
                this.sr.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                outgoing.untrack(bundles[i], null);
            }
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        Bundle result = bundle;
        return result;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return t.copyKeys(new Bundle[length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject(Bundle bundle) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(bundle);
        }
    }

    public void remove(Bundle bundle) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Bundle, T> getTracked() {
        HashMap map = new HashMap();
        Tracked t = this.tracked();
        if (t == null) {
            return map;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.copyEntries(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked t = this.tracked();
        if (t == null) {
            return true;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.isEmpty();
        }
    }

    static {
        Class<EventHook> clazz = EventHook.class;
    }

    private static abstract class AbstractTracked<S, T, R> {
        static final boolean DEBUG = false;
        private final Map<S, T> tracked = new HashMap<S, T>();
        private int trackingCount = 0;
        private final List<S> adding = new ArrayList<S>(6);
        volatile boolean closed = false;
        private final LinkedList<S> initial = new LinkedList();

        AbstractTracked() {
        }

        void setInitial(S[] list) {
            if (list == null) {
                return;
            }
            for (S item : list) {
                if (item == null) continue;
                this.initial.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackInitial() {
            while (true) {
                S item;
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.closed || this.initial.size() == 0) {
                        return;
                    }
                    item = this.initial.removeFirst();
                    if (this.tracked.get(item) != null) {
                        continue;
                    }
                    if (this.adding.contains(item)) {
                        continue;
                    }
                    this.adding.add(item);
                }
                this.trackAdding(item, null);
            }
        }

        void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void track(S item, R related) {
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed) {
                    return;
                }
                object = this.tracked.get(item);
                if (object == null) {
                    if (this.adding.contains(item)) {
                        return;
                    }
                    this.adding.add(item);
                } else {
                    this.modified();
                }
            }
            if (object == null) {
                this.trackAdding(item, related);
            } else {
                this.customizerModified(item, related, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(S item, R related) {
            T object = null;
            boolean becameUntracked = false;
            try {
                object = this.customizerAdding(item, related);
            }
            finally {
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.adding.remove(item) && !this.closed) {
                        if (object != null) {
                            this.tracked.put(item, object);
                            this.modified();
                            this.notifyAll();
                        }
                    } else {
                        becameUntracked = true;
                    }
                }
            }
            if (becameUntracked && object != null) {
                this.customizerRemoved(item, related, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack(S item, R related) {
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.initial.remove(item)) {
                    return;
                }
                if (this.adding.remove(item)) {
                    return;
                }
                object = this.tracked.remove(item);
                if (object == null) {
                    return;
                }
                this.modified();
            }
            this.customizerRemoved(item, related, object);
        }

        int size() {
            return this.tracked.size();
        }

        boolean isEmpty() {
            return this.tracked.isEmpty();
        }

        T getCustomizedObject(S item) {
            return this.tracked.get(item);
        }

        S[] copyKeys(S[] list) {
            return this.tracked.keySet().toArray(list);
        }

        void modified() {
            ++this.trackingCount;
        }

        int getTrackingCount() {
            return this.trackingCount;
        }

        <M extends Map<? super S, ? super T>> M copyEntries(M map) {
            map.putAll(this.tracked);
            return map;
        }

        abstract T customizerAdding(S var1, R var2);

        abstract void customizerModified(S var1, R var2, T var3);

        abstract void customizerRemoved(S var1, R var2, T var3);
    }

    private final class Tracked
    extends AbstractTracked<Bundle, T, BundleEvent>
    implements SynchronousBundleListener {
        Tracked() {
        }

        public void bundleChanged(BundleEvent event) {
            if (this.closed) {
                return;
            }
            Bundle bundle = event.getBundle();
            int state = bundle.getState();
            if ((state & BundleHookBundleTracker.this.mask) != 0) {
                this.track(bundle, event);
            } else {
                this.untrack(bundle, event);
            }
        }

        @Override
        T customizerAdding(Bundle item, BundleEvent related) {
            return BundleHookBundleTracker.this.customizer.addingBundle(item, related);
        }

        @Override
        void customizerModified(Bundle item, BundleEvent related, T object) {
            BundleHookBundleTracker.this.customizer.modifiedBundle(item, related, object);
        }

        @Override
        void customizerRemoved(Bundle item, BundleEvent related, T object) {
            BundleHookBundleTracker.this.customizer.removedBundle(item, related, object);
        }
    }

    private class BundleEventHook
    implements EventHook {
        private final Tracked tracked;

        private BundleEventHook(Tracked tracked) {
            this.tracked = tracked;
        }

        public void event(BundleEvent bundleEvent, Collection bundleContexts) {
            this.tracked.bundleChanged(bundleEvent);
        }
    }
}

