/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityException;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.intfc.SubjectManagerService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class WSSubject {
    private static final TraceComponent tc = Tr.register(WSSubject.class, null, null);
    private static final AuthPermission DOAS_PERM = new AuthPermission("doAs");
    private static final AuthPermission DOASPRIVILEGED_PERM = new AuthPermission("doAsPrivileged");
    private static final AuthPermission GETCALLERSUBJECT_PERM = new AuthPermission("wssecurity.getCallerSubject");
    private static final AuthPermission GETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.getRunAsSubject");
    private static final AuthPermission SETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.setRunAsSubject");
    private static final AtomicServiceReference<SubjectManagerService> smServiceRef = new AtomicServiceReference("subjectManagerService");
    private static final PrivilegedExceptionAction getCallerSubjectAction = new PrivilegedExceptionAction(){
        static final long serialVersionUID = 8639087948251670234L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Object run() throws WSSecurityException {
            SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
            Subject s = null;
            if (sms != null && (s = sms.getCallerSubject()) != null) {
                s.setReadOnly();
            }
            return s;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.auth.WSSubject$1", 1.class, null, null);
        }
    };
    private static final PrivilegedExceptionAction getRunAsSubjectAction = new PrivilegedExceptionAction(){
        static final long serialVersionUID = 1854071459313758011L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Object run() throws WSSecurityException {
            SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
            Subject s = null;
            if (sms != null && (s = sms.getInvocationSubject()) != null) {
                s.setReadOnly();
            }
            return s;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.auth.WSSubject$2", 2.class, null, null);
        }
    };
    static final long serialVersionUID = 395804206152188920L;

    protected void setSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        smServiceRef.setReference(reference);
    }

    protected void unsetSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        smServiceRef.unsetReference(reference);
    }

    protected void activate(ComponentContext cc) {
        smServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        smServiceRef.deactivate(cc);
    }

    public static Object doAs(Subject subject, PrivilegedAction action) {
        return WSSubject.doAs(subject, action, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object doAs(Subject subject, PrivilegedAction action, boolean setCaller) {
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(DOAS_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        Subject callerSubject = null;
        SubjectCookie invocationCookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerSubject = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAs(subject, action);
            return t;
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"124", null, (Object[])new Object[]{subject, action, setCaller});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAs(Subject, PrivilegedAction) Exception caught: " + t), (Object[])new Object[0]);
            }
            throw new RuntimeException((Throwable)t);
        }
        finally {
            WSSubject.restoreInvocationSubject(invocationCookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerSubject);
            }
        }
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return WSSubject.doAs(subject, action, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object doAs(Subject subject, PrivilegedExceptionAction action, boolean setCaller) throws PrivilegedActionException {
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(DOAS_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        Subject callerSubject = null;
        SubjectCookie invocationCookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerSubject = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAs(subject, action);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"173", null, (Object[])new Object[]{subject, action, setCaller});
            throw pae;
        }
        catch (Throwable pae) {
            void t;
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"175", null, (Object[])new Object[]{subject, action, setCaller});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAs(Subject, PrivilegedExceptionAction) Exception caught: " + t), (Object[])new Object[0]);
            }
            throw new RuntimeException((Throwable)t);
        }
        finally {
            WSSubject.restoreInvocationSubject(invocationCookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerSubject);
            }
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        return WSSubject.doAsPrivileged(subject, action, acc, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc, boolean setCaller) {
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedAction provided");
        }
        Subject callerSubject = null;
        SubjectCookie invocationCookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerSubject = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAsPrivileged(subject, action, acc);
            return t;
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"229", null, (Object[])new Object[]{subject, action, acc, setCaller});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAsPrivileged(Subject, PrivilegedAction, AccessControlContext) Exception caught: " + t), (Object[])new Object[0]);
            }
            throw new RuntimeException((Throwable)t);
        }
        finally {
            WSSubject.restoreInvocationSubject(invocationCookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerSubject);
            }
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        return WSSubject.doAsPrivileged(subject, action, acc, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc, boolean setCaller) throws PrivilegedActionException {
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (action == null) {
            throw new IllegalArgumentException("null PrivilegedExceptionAction provided");
        }
        Subject callerSubject = null;
        SubjectCookie invocationCookie = WSSubject.setInvocationSubject(subject);
        if (setCaller) {
            callerSubject = WSSubject.setCallerSubject(subject);
        }
        try {
            Object t = Subject.doAsPrivileged(subject, action, acc);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"284", null, (Object[])new Object[]{subject, action, acc, setCaller});
            throw pae;
        }
        catch (Throwable pae) {
            void t;
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"286", null, (Object[])new Object[]{subject, action, acc, setCaller});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAsPrivileged(Subject, PrivilegedExceptionAction, AccessControlContext) Exception caught: " + t), (Object[])new Object[0]);
            }
            throw new RuntimeException((Throwable)t);
        }
        finally {
            WSSubject.restoreInvocationSubject(invocationCookie);
            if (setCaller) {
                WSSubject.restoreCallerSubject(callerSubject);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Subject getCallerSubject() throws WSSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GETCALLERSUBJECT_PERM);
        }
        Subject s = null;
        try {
            s = (Subject)AccessController.doPrivileged(getCallerSubjectAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"341", null, (Object[])new Object[0]);
            WSSecurityException e = (WSSecurityException)pae.getException();
            throw e;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static Subject getRunAsSubject() throws WSSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GETRUNASSUBJECT_PERM);
        }
        Subject s = null;
        try {
            s = (Subject)AccessController.doPrivileged(getRunAsSubjectAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"402", null, (Object[])new Object[0]);
            WSSecurityException e = (WSSecurityException)pae.getException();
            throw e;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    public static void setRunAsSubject(final Subject subject) throws WSSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SETRUNASSUBJECT_PERM);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static final long serialVersionUID = 3548918179825975585L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() throws WSSecurityException {
                    SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
                    if (sms != null) {
                        sms.setInvocationSubject(subject);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.auth.WSSubject$3", 3.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"461", null, (Object[])new Object[]{subject});
            WSSecurityException e = (WSSecurityException)pae.getException();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getCallerPrincipal() {
        String caller;
        block3: {
            WSCredential wsCred;
            Subject subject;
            caller = null;
            SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
            if (sms != null && (subject = sms.getCallerSubject()) != null && (wsCred = WSSubject.getWSCredential(subject)) != null && !wsCred.isUnauthenticated()) {
                try {
                    caller = wsCred.getSecurityName();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"500", null, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Internal error: " + e), (Object[])new Object[0]);
                }
            }
        }
        return caller;
    }

    public static String getSAFUserFromSubject(Subject subject) {
        String safUser = null;
        return safUser;
    }

    public static Throwable getRootLoginException() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static SubjectCookie setInvocationSubject(Subject s) {
        SubjectCookie cookie = new SubjectCookie();
        SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
        if (sms != null) {
            if (s == null) {
                s = new Subject();
            }
            Subject currentInvocationSubject = sms.getInvocationSubject();
            sms.setInvocationSubject(s);
            cookie.subject = currentInvocationSubject;
            try {
                cookie.token = ThreadIdentityManager.setAppThreadIdentity((Subject)s);
            }
            catch (ThreadIdentityException threadIdentityException) {
                void e;
                FFDCFilter.processException((Throwable)threadIdentityException, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"569", null, (Object[])new Object[]{s});
                throw new SecurityException((Throwable)e);
            }
        }
        return cookie;
    }

    private static Subject setCallerSubject(Subject s) {
        Subject currentCallerSubject = null;
        SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
        if (sms != null) {
            if (s == null) {
                s = new Subject();
            }
            currentCallerSubject = sms.getCallerSubject();
            sms.setCallerSubject(s);
        }
        return currentCallerSubject;
    }

    /*
     * WARNING - void declaration
     */
    private static void restoreInvocationSubject(SubjectCookie cookie) {
        try {
            if (cookie.token != null) {
                ThreadIdentityManager.resetChecked((Object)cookie.token);
            }
        }
        catch (ThreadIdentityException sms) {
            void e;
            FFDCFilter.processException((Throwable)sms, (String)"com.ibm.websphere.security.auth.WSSubject", (String)"602", null, (Object[])new Object[]{cookie});
            throw new SecurityException((Throwable)e);
        }
        finally {
            SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
            if (sms != null) {
                sms.setInvocationSubject(cookie.subject);
            }
        }
    }

    private static void restoreCallerSubject(Subject s) {
        SubjectManagerService sms = (SubjectManagerService)smServiceRef.getService();
        if (sms != null) {
            sms.setCallerSubject(s);
        }
    }

    private static WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class SubjectCookie {
        boolean prevSyncedState = false;
        Subject subject = null;
        Object token = null;
        static final long serialVersionUID = -404743658882910945L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SubjectCookie() {
        }

        public String toString() {
            return super.toString() + ";prevSyncedState=" + this.prevSyncedState + ",token=" + this.token + ",subject=" + this.subject;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.websphere.security.auth.WSSubject$SubjectCookie", SubjectCookie.class, null, null);
        }
    }
}

