/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap12;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAP12BodySerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAP12Body soapBody = (SOAP12Body)extension;
        if (soapBody != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap12/", (String)"body", (Definition)def);
            if (parentType != null && MIMEPart.class.isAssignableFrom(parentType)) {
                pw.print("    ");
            }
            pw.print("        <" + tagName);
            DOMUtils.printAttribute((String)"parts", (String)StringUtils.getNMTokens((List)soapBody.getParts()), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"use", (String)soapBody.getUse(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"encodingStyle", (String)soapBody.getEncodingStyle(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"namespace", (String)soapBody.getNamespaceURI(), (PrintWriter)pw);
            Boolean required = soapBody.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAP12Body soapBody = (SOAP12Body)extReg.createExtension(parentType, elementType);
        String partsStr = DOMUtils.getAttribute((Element)el, (String)"parts");
        String use = DOMUtils.getAttribute((Element)el, (String)"use");
        String encStyleStr = DOMUtils.getAttribute((Element)el, (String)"encodingStyle");
        String namespaceURI = DOMUtils.getAttribute((Element)el, (String)"namespace");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (partsStr != null) {
            soapBody.setParts(StringUtils.parseNMTokens((String)partsStr));
        }
        if (use != null) {
            soapBody.setUse(use);
        }
        if (encStyleStr != null) {
            soapBody.setEncodingStyle(encStyleStr);
        }
        if (namespaceURI != null) {
            soapBody.setNamespaceURI(namespaceURI);
        }
        if (requiredStr != null) {
            soapBody.setRequired(new Boolean(requiredStr));
        }
        return soapBody;
    }
}

