/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.SingleDataItem;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RecoverableUnitSectionImpl
implements RecoverableUnitSection {
    private static final TraceComponent tc;
    private static final int INITIAL_DATA_CAPACITY = 10;
    protected static short RECORDTYPENORMAL;
    protected static short RECORDTYPEDELETED;
    private static final int HEADER_SIZE = 11;
    private static final int LOCK_REQUEST_ID_RUSI_ADDDATA = 3;
    private static final int LOCK_REQUEST_ID_RUSI_WRITE = 4;
    private static final int LOCK_REQUEST_ID_RUSI_FORCE = 5;
    private static final int LOCK_REQUEST_ID_RUSI_FORMAT = 6;
    private static final int LOCK_REQUEST_ID_RUSI_DATA = 7;
    private int _identity = 0;
    private ArrayList _unwrittenData = null;
    private ArrayList _writtenData = null;
    private boolean _singleData = false;
    private DataItem _lastDataItem = null;
    private Lock _controlLock = null;
    private LogHandle _logHandle = null;
    private long _recoverableUnitIdentity = 0L;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private MultiScopeRecoveryLog _recLog = null;
    private RecoverableUnitImpl _recUnit = null;
    private int _storageMode = 1;
    private String _serverName = null;
    private String _clientName = null;
    private int _clientVersion = 0;
    private String _logName = null;
    private int _logIdentifier = 0;
    private String _traceId;
    static final long serialVersionUID = 7436906457357275922L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    RecoverableUnitSectionImpl(MultiScopeRecoveryLog recLog, RecoverableUnitImpl recUnit, long recoverableUnitIdentity, int identity, Lock controlLock, LogHandle logHandle, int storageMode, boolean singleData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoverableUnitSectionImpl", (Object)new Object[]{recLog, recUnit, new Long(recoverableUnitIdentity), new Integer(identity), controlLock, logHandle, new Integer(storageMode), new Boolean(singleData)});
        }
        this._recLog = recLog;
        this._recoverableUnitIdentity = recoverableUnitIdentity;
        this._identity = identity;
        this._controlLock = controlLock;
        this._logHandle = logHandle;
        this._singleData = singleData;
        this._recUnit = recUnit;
        this._storageMode = storageMode;
        this._unwrittenData = new ArrayList(10);
        this._writtenData = new ArrayList(10);
        this._serverName = recLog.serverName();
        this._clientName = recLog.clientName();
        this._clientVersion = recLog.clientVersion();
        this._logName = recLog.logName();
        this._logIdentifier = recLog.logIdentifier();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoverableUnitSectionImpl", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addData(byte[] data) throws InternalLogException {
        DataItem dataItem2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addData", (Object)new Object[]{RLSUtils.toHexString(data, 32), this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData", (Object)this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(3);
        if (this._singleData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section can hold only a single data item.");
            }
            if (this._writtenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing WRITTEN data. Updating data wrapper.");
                }
                dataItem2 = (SingleDataItem)this._writtenData.get(0);
                ((SingleDataItem)dataItem2).setData(data);
                this._writtenData.clear();
                this._unwrittenData.add(0, dataItem2);
                this._lastDataItem = dataItem2;
            } else if (this._unwrittenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is existing UNWRITTEN data. Updating data wrapper.");
                }
                dataItem2 = (SingleDataItem)this._unwrittenData.get(0);
                ((SingleDataItem)dataItem2).setData(data);
                this._lastDataItem = dataItem2;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There is no existing data. Creating data wrapper");
                }
                dataItem2 = new SingleDataItem(this._storageMode, data, this);
                this._unwrittenData.add(0, dataItem2);
                this._lastDataItem = dataItem2;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Section holds multiple data items");
            }
            dataItem2 = new DataItem(this._storageMode, data, this);
            this._unwrittenData.add(dataItem2);
            this._lastDataItem = dataItem2;
        }
        try {
            this._controlLock.releaseSharedLock(3);
        }
        catch (NoSharedLockException dataItem2) {
            void exc;
            FFDCFilter.processException((Throwable)dataItem2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"417", (Object)this, (Object[])new Object[]{data});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.addData", (String)"382", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addData", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addData");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(4);
        if (this._unwrittenDataSize > 0) {
            try {
                this._recUnit.writeSection(this, this._unwrittenDataSize + 11);
            }
            catch (InternalLogException internalLogException) {
                void exc;
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"472", (Object)this, (Object[])new Object[0]);
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", (String)"437", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"write", (Object)exc);
                }
                throw exc;
            }
        }
        try {
            this._controlLock.releaseSharedLock(4);
        }
        catch (NoSharedLockException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"484", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", (String)"449", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.write();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"544", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"509", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)exc);
            }
            throw exc;
        }
        this._controlLock.getSharedLock(5);
        try {
            this._logHandle.force();
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"557", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"522", (Object)this);
            this._recLog.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)exc);
            }
            throw exc;
        }
        finally {
            try {
                this._controlLock.releaseSharedLock(5);
            }
            catch (Throwable throwable) {
                void exc;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"570", (Object)this, (Object[])new Object[0]);
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", (String)"535", (Object)this);
                throw new InternalLogException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    /*
     * WARNING - void declaration
     */
    void format(boolean rewriteRequired, WriteableLogRecord logRecord) throws IOException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"format", (Object)new Object[]{new Boolean(rewriteRequired), logRecord, this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"format", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(6);
        int totalDataSize = 0;
        int writtenDataSize = 0;
        int unwrittenDataSize = 0;
        if (this._writtenData != null) {
            writtenDataSize = this._writtenData.size();
        }
        if (this._unwrittenData != null) {
            unwrittenDataSize = this._unwrittenData.size();
        }
        if (rewriteRequired) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Section has '" + unwrittenDataSize + "' unwritten data items and '" + writtenDataSize + "' written data items to write"));
            }
            totalDataSize = unwrittenDataSize + writtenDataSize;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Section has '" + unwrittenDataSize + "' unwritten data items and '0' written data items to write"));
            }
            totalDataSize = unwrittenDataSize;
        }
        if (totalDataSize > 0) {
            int i;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing section identity '" + this._identity + "'"));
            }
            logRecord.putInt(this._identity);
            logRecord.putShort(RECORDTYPENORMAL);
            logRecord.putBoolean(this._singleData);
            logRecord.putInt(totalDataSize);
            if (rewriteRequired) {
                for (i = 0; i < writtenDataSize; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Writing written data item '" + i + "'"));
                    }
                    ((DataItem)this._writtenData.get(i)).write(logRecord);
                }
            }
            for (i = 0; i < unwrittenDataSize; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Writing unwritten data item '" + i + "'"));
                }
                DataItem dataItem = (DataItem)this._unwrittenData.get(i);
                dataItem.write(logRecord);
                this._writtenData.add(dataItem);
            }
            if (unwrittenDataSize > 0) {
                this._unwrittenData.clear();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSectionImpl '" + this._identity + "' has no data to format"));
        }
        try {
            this._controlLock.releaseSharedLock(6);
        }
        catch (NoSharedLockException i) {
            void exc;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"705", (Object)this, (Object[])new Object[]{rewriteRequired, logRecord});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.format", (String)"670", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"format", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"format");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogCursor data() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"data", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"data", (Object)this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(7);
        if (tc.isEventEnabled()) {
            int writtenDataBlocks = 0;
            int unwrittenDataBlocks = 0;
            if (this._writtenData != null) {
                writtenDataBlocks = this._writtenData.size();
            }
            if (this._unwrittenData != null) {
                unwrittenDataBlocks = this._unwrittenData.size();
            }
            Tr.event((TraceComponent)tc, (String)("#writtenDataBlocks = " + writtenDataBlocks + " #unwrittenDataBlocks = " + unwrittenDataBlocks));
        }
        LogCursorImpl cursor = null;
        cursor = this._singleData ? (this._writtenData.size() > 0 ? new LogCursorImpl(null, ((DataItem)this._writtenData.get(0)).getData()) : new LogCursorImpl(null, ((DataItem)this._unwrittenData.get(0)).getData())) : new LogCursorImpl(null, this._writtenData, this._unwrittenData, false, null);
        try {
            this._controlLock.releaseSharedLock(7);
        }
        catch (NoSharedLockException unwrittenDataBlocks) {
            void exc;
            FFDCFilter.processException((Throwable)unwrittenDataBlocks, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"801", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.data", (String)"766", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"data", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"data", (Object)new Integer(cursor.initialSize()));
        }
        return cursor;
    }

    @Override
    public int identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)new Integer(this._identity));
        }
        return this._identity;
    }

    /*
     * WARNING - void declaration
     */
    void recover(ReadableLogRecord logRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)new Object[]{logRecord, this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int numDataItems = logRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Recovering '" + numDataItems + "' data items"));
            }
            for (int d = 0; d < numDataItems; ++d) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Recovering data item '" + d + "'"));
                }
                DataItem dataItem = null;
                if (this._singleData) {
                    if (this._writtenData.size() > 0) {
                        dataItem = (DataItem)this._writtenData.get(0);
                    }
                    if (dataItem == null) {
                        dataItem = new SingleDataItem(this._storageMode, logRecord, this);
                        this._writtenData.add(dataItem);
                    } else {
                        ((SingleDataItem)dataItem).setData(logRecord);
                        this._writtenData.set(0, dataItem);
                    }
                } else {
                    dataItem = new DataItem(this._storageMode, logRecord, this);
                    this._writtenData.add(dataItem);
                }
                this._lastDataItem = dataItem;
            }
        }
        catch (InternalLogException numDataItems) {
            void exc;
            FFDCFilter.processException((Throwable)numDataItems, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"925", (Object)this, (Object[])new Object[]{logRecord});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", (String)"876", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An InternalLogException occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed((Throwable)exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"LogCorruptedException");
            }
            throw new LogCorruptedException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", (String)"933", (Object)this, (Object[])new Object[]{logRecord});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", (String)"884", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    @Override
    public byte[] lastData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lastData", (Object)this);
        }
        byte[] lastData = null;
        if (this._lastDataItem != null) {
            lastData = this._lastDataItem.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lastData", (Object)RLSUtils.toHexString(lastData, 32));
        }
        return lastData;
    }

    protected void payloadAdded(int payloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object)new Object[]{this, new Integer(payloadSize)});
        }
        int unwrittenRecUnitAdjustment = payloadSize;
        int totalRecUnitAdjustment = payloadSize;
        if (this._unwrittenDataSize == 0) {
            unwrittenRecUnitAdjustment += 11;
        }
        if (this._totalDataSize == 0) {
            totalRecUnitAdjustment += 11;
        }
        this._unwrittenDataSize += payloadSize;
        this._totalDataSize += payloadSize;
        this._recUnit.payloadAdded(unwrittenRecUnitAdjustment, totalRecUnitAdjustment);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    protected void payloadWritten(int payloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object)new Object[]{this, new Integer(payloadSize)});
        }
        this._unwrittenDataSize -= payloadSize;
        if (this._unwrittenDataSize == 0) {
            this._recUnit.payloadWritten(payloadSize + 11);
        } else {
            this._recUnit.payloadWritten(payloadSize);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    protected void payloadDeleted(int totalPayloadSize, int unwrittenPayloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object)new Object[]{this, new Integer(totalPayloadSize), new Integer(unwrittenPayloadSize)});
        }
        this._totalDataSize -= totalPayloadSize;
        this._unwrittenDataSize -= unwrittenPayloadSize;
        if (this._unwrittenDataSize == 0 && unwrittenPayloadSize != 0) {
            unwrittenPayloadSize += 11;
        }
        if (this._totalDataSize == 0) {
            totalPayloadSize += 11;
        }
        this._recUnit.payloadDeleted(totalPayloadSize, unwrittenPayloadSize);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    public String toString() {
        if (this._traceId == null) {
            this._traceId = "RecoverableUnitSectionImpl:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        }
        return this._traceId;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl", RecoverableUnitSectionImpl.class, null, null);
        tc = Tr.register(RecoverableUnitSectionImpl.class, (String)"Transaction", null);
        RECORDTYPENORMAL = 1;
        RECORDTYPEDELETED = (short)2;
    }
}

