/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.OperatingSystemException;
import com.ibm.ws.kernel.service.util.OperatingSystemType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperatingSystem {
    private static final TraceComponent tc = Tr.register(OperatingSystem.class, null, (String)"com.ibm.ws.kernel.service.utils.resources.ServiceMessages");
    private static final OperatingSystem instance = new OperatingSystem();
    private final OperatingSystemType osType = OperatingSystem.parseOperatingSystemType();
    private static int cachedPageSize = -1;
    static final long serialVersionUID = 2146516632008671522L;

    public static OperatingSystem instance() {
        return instance;
    }

    public OperatingSystemType getOperatingSystemType() {
        return this.osType;
    }

    private static OperatingSystemType parseOperatingSystemType() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if ((osName = osName.toLowerCase().replaceAll("/", "")).contains("linux")) {
                return OperatingSystemType.Linux;
            }
            if (osName.contains("mac") || osName.contains("darwin")) {
                return OperatingSystemType.Mac;
            }
            if (osName.contains("aix")) {
                return OperatingSystemType.AIX;
            }
            if (osName.contains("win")) {
                return OperatingSystemType.Windows;
            }
            if (osName.contains("400")) {
                return OperatingSystemType.IBMi;
            }
            if (osName.contains("os390") || osName.contains("zos")) {
                return OperatingSystemType.zOS;
            }
            if (osName.contains("hp")) {
                return OperatingSystemType.HPUX;
            }
            if (osName.contains("solaris") || osName.contains("sun")) {
                return OperatingSystemType.Solaris;
            }
        }
        return OperatingSystemType.Unknown;
    }

    public static synchronized int getPageSize() throws OperatingSystemException {
        if (cachedPageSize == -1) {
            switch (OperatingSystem.instance().getOperatingSystemType()) {
                case AIX: 
                case HPUX: 
                case IBMi: 
                case Linux: 
                case Mac: 
                case Solaris: 
                case zOS: {
                    cachedPageSize = OperatingSystem.getPageSizePOSIX();
                    break;
                }
                default: {
                    throw new OperatingSystemException(Tr.formatMessage((TraceComponent)tc, (String)"os.pagesize.unavailable", (Object[])new Object[0]));
                }
            }
        }
        return cachedPageSize;
    }

    private static int getPageSizePOSIX() throws OperatingSystemException {
        List<String> getconfLines = OperatingSystem.executeProgram("/usr/bin/getconf", "PAGE_SIZE");
        return Integer.parseInt(getconfLines.get(0).trim());
    }

    public static List<String> executeProgram(String ... commandLine) throws OperatingSystemException {
        return OperatingSystem.executeProgramWithInput(null, commandLine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={IOException.class, InterruptedException.class})
    public static List<String> executeProgramWithInput(String input, String ... commandLine) throws OperatingSystemException {
        try {
            int returnCode;
            ArrayList<String> lines;
            Process process;
            block33: {
                block30: {
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    builder.command(commandLine);
                    process = builder.start();
                    if (input != null) {
                        OutputStream os = process.getOutputStream();
                        try {
                            OutputStreamWriter osw = new OutputStreamWriter(os);
                            try {
                                BufferedWriter bw = new BufferedWriter(osw);
                                try {
                                    bw.write(input);
                                    bw.flush();
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"154", null, (Object[])new Object[]{input, commandLine});
                                    try {
                                        bw.close();
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"154", null, (Object[])new Object[]{input, commandLine});
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                bw.close();
                            }
                            catch (Throwable bw) {
                                FFDCFilter.processException((Throwable)bw, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"153", null, (Object[])new Object[]{input, commandLine});
                                try {
                                    osw.close();
                                    throw bw;
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"153", null, (Object[])new Object[]{input, commandLine});
                                    bw.addSuppressed(throwable);
                                }
                                throw bw;
                            }
                            osw.close();
                            if (os == null) break block30;
                        }
                        catch (Throwable osw) {
                            FFDCFilter.processException((Throwable)osw, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"152", null, (Object[])new Object[]{input, commandLine});
                            if (os == null) throw osw;
                            try {
                                os.close();
                                throw osw;
                            }
                            catch (Throwable bw) {
                                FFDCFilter.processException((Throwable)bw, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"152", null, (Object[])new Object[]{input, commandLine});
                                osw.addSuppressed(bw);
                            }
                            throw osw;
                        }
                        os.close();
                    }
                }
                lines = new ArrayList<String>();
                InputStream is = process.getInputStream();
                try {
                    InputStreamReader isr = new InputStreamReader(is);
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                lines.add(line);
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"165", null, (Object[])new Object[]{input, commandLine});
                            try {
                                br.close();
                                throw throwable;
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"165", null, (Object[])new Object[]{input, commandLine});
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        br.close();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"164", null, (Object[])new Object[]{input, commandLine});
                        try {
                            isr.close();
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"164", null, (Object[])new Object[]{input, commandLine});
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    isr.close();
                    if (is == null) break block33;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"163", null, (Object[])new Object[]{input, commandLine});
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable throwable5) {
                        FFDCFilter.processException((Throwable)throwable5, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"163", null, (Object[])new Object[]{input, commandLine});
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
                is.close();
            }
            if ((returnCode = process.waitFor()) == 0) return lines;
            throw new OperatingSystemException(Tr.formatMessage((TraceComponent)tc, (String)"os.execute.error", (Object[])new Object[]{commandLine, returnCode, lines}));
        }
        catch (IOException e) {
            throw new OperatingSystemException(e);
        }
        catch (InterruptedException e) {
            throw new OperatingSystemException(e);
        }
    }
}

