/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.product.utility.CommandConstants;
import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.CommandUtils;
import com.ibm.ws.product.utility.ExecutionContext;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public abstract class BaseCommandTask
implements CommandTask {
    private PrintStream outputStream = null;

    @Override
    public void execute(ExecutionContext context) {
        try {
            if (!this.validateArguments(context)) {
                return;
            }
            if (!this.populateCommonOptions(context)) {
                return;
            }
            this.doExecute(context);
        }
        finally {
            this.cleanUp(context);
        }
    }

    protected boolean validateArguments(ExecutionContext context) {
        boolean optionsValid = true;
        LinkedHashSet<String> supportedOptions = new LinkedHashSet<String>();
        supportedOptions.add("--output");
        supportedOptions.addAll(this.getSupportedOptions());
        String supportedOptionsString = null;
        Set<String> suppliedOptions = context.getOptionNames();
        for (String option : suppliedOptions) {
            if (option.startsWith("--") && supportedOptions.contains(option)) continue;
            optionsValid = false;
            if (supportedOptionsString == null) {
                supportedOptionsString = this.getSupportedOptionsString(supportedOptions);
            }
            context.getCommandConsole().printlnErrorMessage(this.getMessage("ERROR_INVALID_COMMAND_OPTION", option, supportedOptionsString));
        }
        return optionsValid;
    }

    protected abstract void doExecute(ExecutionContext var1);

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, Object ... args) {
        return CommandUtils.getOption(key, args);
    }

    protected boolean populateCommonOptions(ExecutionContext context) {
        String outputFile = context.getOptionValue("--output");
        if (outputFile != null && !outputFile.isEmpty()) {
            try {
                this.outputStream = new PrintStream((OutputStream)new FileOutputStream(outputFile), true, "UTF-8");
                context.setOverrideOutputStream(this.outputStream);
            }
            catch (UnsupportedEncodingException e) {
                context.getCommandConsole().printlnErrorMessage(this.getMessage("ERROR_UNABLE_WRITE_FILE", outputFile, e.getMessage()));
                return false;
            }
            catch (FileNotFoundException e) {
                context.getCommandConsole().printlnErrorMessage(this.getMessage("ERROR_UNABLE_WRITE_FILE", outputFile, e.getMessage()));
                return false;
            }
        }
        return true;
    }

    protected void cleanUp(ExecutionContext context) {
        if (this.outputStream != null) {
            try {
                context.setOverrideOutputStream(null);
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String getTaskHelp(String desc, String usage, String optionKeyPrefix, String optionDescPrefix, String addon) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.description", new Object[0]));
        scriptHelp.append(CommandConstants.LINE_SEPARATOR);
        scriptHelp.append(this.getOption(desc, new Object[0]));
        scriptHelp.append(CommandConstants.LINE_SEPARATOR);
        scriptHelp.append(CommandConstants.LINE_SEPARATOR);
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(CommandConstants.LINE_SEPARATOR);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        scriptHelp.append(CommandConstants.LINE_SEPARATOR);
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            ResourceBundle options = CommandConstants.PRODUCT_OPTIONS;
            Enumeration<String> keys = options.getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix) || key.equals("validate.option-key.checksumfile")) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                scriptHelp.append(CommandConstants.LINE_SEPARATOR);
                scriptHelp.append(this.getOption("global.options", new Object[0]));
                for (String optionKey : optionKeys) {
                    scriptHelp.append(CommandConstants.LINE_SEPARATOR);
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptHelp.append(options.getString(optionKey));
                    scriptHelp.append(CommandConstants.LINE_SEPARATOR);
                    scriptHelp.append(options.getString(optionDescPrefix + option));
                    scriptHelp.append(CommandConstants.LINE_SEPARATOR);
                }
            }
        }
        if (addon != null && !addon.isEmpty()) {
            scriptHelp.append(CommandConstants.LINE_SEPARATOR);
            scriptHelp.append(this.getOption(addon, new Object[0]));
        }
        return scriptHelp.toString();
    }

    protected String getSupportedOptionsString(Set<String> supportedOptions) {
        StringBuffer supportedOptionsBuffer = new StringBuffer();
        for (String supportedOption : supportedOptions) {
            if (!supportedOption.startsWith("--")) continue;
            supportedOptionsBuffer.append(supportedOption);
            supportedOptionsBuffer.append(", ");
        }
        String supportedOptionsString = supportedOptionsBuffer.toString();
        supportedOptionsString = supportedOptionsString.substring(0, supportedOptionsString.length() - 2);
        return supportedOptionsString;
    }
}

