/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckResponseImpl
extends HealthCheckResponse {
    private static final TraceComponent tc = Tr.register(HealthCheckResponseImpl.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private final String name;
    private final HealthCheckResponse.State state;
    private final Optional<Map<String, Object>> data;
    static final long serialVersionUID = -4016045735227567756L;

    public HealthCheckResponseImpl(String name, HealthCheckResponse.State state, Optional<Map<String, Object>> data) {
        this.name = name;
        this.state = state;
        this.data = data;
    }

    public String getName() {
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Name is null", (Object[])new Object[0]));
        }
        return this.name;
    }

    public HealthCheckResponse.State getState() {
        if (this.state == null || this.state != HealthCheckResponse.State.UP && this.state != HealthCheckResponse.State.DOWN) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"State is null", (Object[])new Object[0]));
        }
        return this.state;
    }

    public Optional<Map<String, Object>> getData() {
        if (this.data.isPresent()) {
            Set<String> keys = this.data.get().keySet();
            for (String key : keys) {
                if (key != null && key.length() != 0) continue;
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Key is null", (Object[])new Object[0]));
            }
        }
        return this.data;
    }

    public static HealthCheckResponseBuilder named(String sName) {
        HealthCheckResponseBuilder builder = null;
        if (sName == null || sName.length() <= 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Name is null", (Object[])new Object[0]));
        }
        builder = HealthCheckResponse.named((String)sName);
        builder.name(sName);
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HealthCheckResponse: ");
        builder.append("\n\t");
        builder.append("name");
        builder.append(" = ");
        builder.append(this.name);
        builder.append("\n\t");
        builder.append("state");
        builder.append(" = ");
        builder.append(this.state);
        builder.append("\n\t");
        builder.append("data");
        builder.append(" = ");
        builder.append(this.data);
        return builder.toString();
    }
}

