/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.utils.CauseMsg;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtTokenException
extends Exception {
    private static final TraceComponent tc = Tr.register(JwtTokenException.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private static final long serialVersionUID = 1L;
    String message = null;
    JwtTokenException childException = null;
    String msgKey = null;
    Object[] objs = new Object[0];
    boolean bFfdcAlready = false;

    private JwtTokenException(boolean bTrError, String msgKey, Object[] objs) {
        this.msgKey = msgKey;
        this.objs = objs;
        if (objs != null) {
            for (int iI = 0; iI < objs.length; ++iI) {
                if (!(objs[iI] instanceof Throwable)) continue;
                if (objs[iI] instanceof JwtTokenException) {
                    this.childException = (JwtTokenException)objs[iI];
                    continue;
                }
                objs[iI] = new CauseMsg((Throwable)objs[iI]);
            }
        }
        if (bTrError) {
            this.handleTrError();
        }
    }

    @Trivial
    public static JwtTokenException newInstance(boolean parent, String msgKey, Object[] objs) {
        JwtTokenException result = new JwtTokenException(parent, msgKey, objs);
        return result;
    }

    void handleTrError() {
        if (this.childException != null && this.msgKey.equals(this.childException.getMsgKey())) {
            this.childException.handleTrError();
        } else {
            Tr.error((TraceComponent)tc, (String)this.msgKey, (Object[])this.objs);
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        if (this.childException != null && this.msgKey.equals(this.childException.getMsgKey())) {
            return this.childException.getMessage();
        }
        if (this.message == null && this.msgKey != null) {
            this.message = Tr.formatMessage((TraceComponent)tc, (String)this.msgKey, (Object[])this.objs);
        }
        if (this.message != null) {
            return this.message;
        }
        return this.getClass().getName();
    }

    public JwtTokenException(String message) {
        super(message);
        this.message = message;
    }

    public JwtTokenException(String message, Exception e) {
        super(message, e);
        this.message = message;
    }

    Exception getChildException() {
        return this.childException;
    }

    String getMsgKey() {
        return this.msgKey;
    }

    public void handleFfdc() {
        if (!this.bFfdcAlready) {
            FFDCFilter.processException((Throwable)this, (String)"com.ibm.websphere.security.jwt.JwtTokenException", (String)"155", (Object)this);
            this.bFfdcAlready = true;
        }
    }
}

