/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction.was;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.transaction.TransactionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.transaction.JTATransactionController;

public class WebSphereTransactionController
extends JTATransactionController {
    private static final String TX_MANAGER_FACTORY_CLASS = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String TX_MANAGER_FACTORY_METHOD = "getTransactionManager";

    protected String getTxManagerFactoryClass() {
        return TX_MANAGER_FACTORY_CLASS;
    }

    protected String getTxManagerFactoryMethod() {
        return TX_MANAGER_FACTORY_METHOD;
    }

    @Override
    protected TransactionManager acquireTransactionManager() throws Exception {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getTxManagerFactoryClass()));
                Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, this.getTxManagerFactoryMethod(), null, false));
                return (TransactionManager)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, null, null));
            }
            catch (PrivilegedActionException ex) {
                if (ex.getCause() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getCause();
                }
                if (ex.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)ex.getCause();
                }
                if (ex.getCause() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)ex.getCause();
                }
                if (ex.getCause() instanceof InvocationTargetException) {
                    throw (InvocationTargetException)ex.getCause();
                }
                throw (RuntimeException)ex.getCause();
            }
        }
        Class clazz = PrivilegedAccessHelper.getClassForName(this.getTxManagerFactoryClass());
        Method method = PrivilegedAccessHelper.getMethod(clazz, this.getTxManagerFactoryMethod(), null, false);
        return (TransactionManager)PrivilegedAccessHelper.invokeMethod(method, null, null);
    }
}

