/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public final class IndirectCollectionsFactory {
    private static final String JDK8_SUPPORT_PROVIDER = "org.eclipse.persistence.internal.indirection.jdk8.IndirectCollectionsProvider";
    private static final IndirectCollectionsProvider provider = IndirectCollectionsFactory.getProvider();
    public static final Class IndirectList_Class = provider.getListClass();
    public static final Class IndirectSet_Class = provider.getSetClass();
    public static final Class IndirectMap_Class = provider.getMapClass();

    public static <E> IndirectList<E> createIndirectList() {
        return provider.createIndirectList(10, 0);
    }

    public static <E> IndirectList<E> createIndirectList(int initialCapacity) {
        return provider.createIndirectList(initialCapacity, 0);
    }

    public static <E> IndirectList<E> createIndirectList(Collection<? extends E> collection) {
        return provider.createIndirectList(collection);
    }

    public static <E> IndirectSet<E> createIndirectSet() {
        return provider.createIndirectSet(10, 0.75f);
    }

    public static <E> IndirectSet<E> createIndirectSet(int initialCapacity) {
        return provider.createIndirectSet(initialCapacity, 0.75f);
    }

    public static <E> IndirectSet<E> createIndirectSet(Collection<? extends E> collection) {
        return provider.createIndirectSet(collection);
    }

    public static <K, V> IndirectMap<K, V> createIndirectMap() {
        return provider.createIndirectMap(11, 0.75f);
    }

    public static <K, V> IndirectMap<K, V> createIndirectMap(int initialCapacity) {
        return provider.createIndirectMap(initialCapacity, 0.75f);
    }

    public static <K, V> IndirectMap<K, V> createIndirectMap(Map<? extends K, ? extends V> map) {
        return provider.createIndirectMap(map);
    }

    private static IndirectCollectionsProvider getProvider() {
        if (JavaSEPlatform.atLeast(JavaSEPlatform.v1_8)) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    final Class support = (Class)AccessController.doPrivileged(new PrivilegedClassForName(JDK8_SUPPORT_PROVIDER, true, IndirectCollectionsFactory.class.getClassLoader()));
                    return AccessController.doPrivileged(new PrivilegedAction<IndirectCollectionsProvider>(){

                        @Override
                        public IndirectCollectionsProvider run() {
                            try {
                                return (IndirectCollectionsProvider)support.newInstance();
                            }
                            catch (IllegalAccessException | InstantiationException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    });
                }
                Class support = PrivilegedAccessHelper.getClassForName(JDK8_SUPPORT_PROVIDER, true, IndirectCollectionsFactory.class.getClassLoader());
                return (IndirectCollectionsProvider)PrivilegedAccessHelper.newInstanceFromClass(support);
            }
            catch (Throwable t) {
                SessionLogEntry sle = new SessionLogEntry(null, t);
                sle.setMessage("IndirectCollections: Using JDK 7 compatible APIs.");
                sle.setLevel(1);
                sle.setNameSpace("misc");
                sle.setDate(null);
                AbstractSessionLog.getLog().log(sle);
            }
        }
        return new DefaultProvider();
    }

    private static final class DefaultProvider
    implements IndirectCollectionsProvider {
        private DefaultProvider() {
        }

        @Override
        public Class getListClass() {
            return IndirectList.class;
        }

        @Override
        public <E> IndirectList<E> createIndirectList(int initialCapacity, int capacityIncrement) {
            return new IndirectList(initialCapacity, capacityIncrement);
        }

        @Override
        public <E> IndirectList<E> createIndirectList(Collection<? extends E> collection) {
            return new IndirectList<E>(collection);
        }

        @Override
        public Class getSetClass() {
            return IndirectSet.class;
        }

        @Override
        public <E> IndirectSet<E> createIndirectSet(int initialCapacity, float loadFactor) {
            return new IndirectSet(initialCapacity, loadFactor);
        }

        @Override
        public <E> IndirectSet<E> createIndirectSet(Collection<? extends E> collection) {
            return new IndirectSet<E>(collection);
        }

        @Override
        public Class getMapClass() {
            return IndirectMap.class;
        }

        @Override
        public <K, V> IndirectMap<K, V> createIndirectMap(int initialCapacity, float loadFactor) {
            return new IndirectMap(initialCapacity, loadFactor);
        }

        @Override
        public <K, V> IndirectMap<K, V> createIndirectMap(Map<? extends K, ? extends V> map) {
            return new IndirectMap<K, V>(map);
        }
    }

    public static interface IndirectCollectionsProvider {
        public Class getListClass();

        public <E> IndirectList<E> createIndirectList(int var1, int var2);

        public <E> IndirectList<E> createIndirectList(Collection<? extends E> var1);

        public Class getSetClass();

        public <E> IndirectSet<E> createIndirectSet(int var1, float var2);

        public <E> IndirectSet<E> createIndirectSet(Collection<? extends E> var1);

        public Class getMapClass();

        public <K, V> IndirectMap<K, V> createIndirectMap(int var1, float var2);

        public <K, V> IndirectMap<K, V> createIndirectMap(Map<? extends K, ? extends V> var1);
    }
}

