/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.test;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.test.XAFlowCallback;

public final class XAFlowCallbackControl {
    private static XAFlowCallback _callback;
    private static boolean _enabled;
    private static final TraceComponent tc;

    public static void initialize() {
        if (System.getProperty("com.ibm.ws.Transaction.fvt") != null) {
            if (!XAFlowCallbackControl.initialize("com.ibm.ws.Transaction.test.impl.XAFlowCallbackImpl")) {
                XAFlowCallbackControl.initialize("com.ibm.ws.tx.test.impl.XAFlowCallbackImpl");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"XAFlowCallbacks not enabled", (Object[])new Object[0]);
        }
    }

    private static boolean initialize(String classToLoad) {
        block8: {
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[]{classToLoad});
                }
                try {
                    _callback = (XAFlowCallback)Class.forName(classToLoad).newInstance();
                    _enabled = true;
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("Couldn't load " + classToLoad + " using default classloader: " + e.getLocalizedMessage()), (Object[])new Object[0]);
                }
            }
            try {
                if (!_enabled) {
                    _callback = (XAFlowCallback)Class.forName(classToLoad, true, Thread.currentThread().getContextClassLoader()).newInstance();
                    _enabled = true;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("Couldn't load " + classToLoad + " using " + Thread.currentThread().getContextClassLoader() + ": " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize", (Object)_enabled);
        }
        return _enabled;
    }

    public static final boolean isEnabled() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isEnabled", (Object[])new Object[]{_enabled});
        }
        return _enabled;
    }

    public static boolean beforeXAFlow(int flowType, int flag) {
        if (tc.isEntryEnabled()) {
            StringBuffer params = new StringBuffer("Flow type=");
            switch (flowType) {
                case 0: {
                    params.append("FORGET, Flag=");
                    break;
                }
                case 1: {
                    params.append("PREPARE, Flag=");
                    break;
                }
                case 2: {
                    params.append("COMMIT, Flag=");
                    break;
                }
                case 3: {
                    params.append("ROLLBACK, Flag=");
                    break;
                }
                default: {
                    params.append("UNKNOWN, Flag=");
                }
            }
            switch (flag) {
                case 10: {
                    params.append("FORGET_NORMAL");
                    break;
                }
                case 20: {
                    params.append("PREPARE_NORMAL");
                    break;
                }
                case 21: {
                    params.append("PREPARE_1PC_OPT");
                    break;
                }
                case 30: {
                    params.append("COMMIT_2PC");
                    break;
                }
                case 31: {
                    params.append("COMMIT_1PC_OPT");
                    break;
                }
                case 40: {
                    params.append("ROLLBACK_NORMAL");
                    break;
                }
                case 41: {
                    params.append("ROLLBACK_DUE_TO_ERROR");
                    break;
                }
                default: {
                    params.append("UNKNOWN");
                }
            }
            Tr.entry((TraceComponent)tc, (String)"beforeXAFlow", (Object[])new Object[]{params.toString()});
        }
        boolean retval = _callback.beforeXAFlow(flowType, flag);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeXAFlow", (Object)("return=" + retval));
        }
        return retval;
    }

    public static boolean afterXAFlow(int flowType, int flag) {
        if (tc.isEntryEnabled()) {
            StringBuffer params = new StringBuffer("Flow type=");
            switch (flowType) {
                case 0: {
                    params.append("FORGET, Flag=");
                    break;
                }
                case 1: {
                    params.append("PREPARE, Flag=");
                    break;
                }
                case 2: {
                    params.append("COMMIT, Flag=");
                    break;
                }
                case 3: {
                    params.append("ROLLBACK, Flag=");
                    break;
                }
                default: {
                    params.append("UNKNOWN, Flag=");
                }
            }
            switch (flag) {
                case 50: {
                    params.append("AFTER_SUCCESS");
                    break;
                }
                case 51: {
                    params.append("AFTER_FAIL");
                    break;
                }
                default: {
                    params.append("UNKNOWN");
                }
            }
            Tr.entry((TraceComponent)tc, (String)"afterXAFlow", (Object[])new Object[]{params.toString()});
        }
        boolean retval = _callback.afterXAFlow(flowType, flag);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterXAFlow", (Object)("return=" + retval));
        }
        return retval;
    }

    static {
        tc = Tr.register(XAFlowCallbackControl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

