/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.archive;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirPattern {
    boolean includeByDefault;
    Set<Pattern> includePatterns;
    Set<Pattern> excludePatterns;
    PatternStrategy strategy;

    public DirPattern(boolean includeByDefault, PatternStrategy strategy) {
        this.includeByDefault = includeByDefault;
        this.strategy = strategy;
        this.includePatterns = new HashSet<Pattern>();
        this.excludePatterns = new HashSet<Pattern>();
    }

    public Set<Pattern> getIncludePatterns() {
        return this.includePatterns;
    }

    public Set<Pattern> getExcludePatterns() {
        return this.excludePatterns;
    }

    public PatternStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isIncludeByDefault() {
        return this.includeByDefault;
    }

    static boolean includePreference(File file, Set<Pattern> excludePattern, Set<Pattern> includePattern, boolean includeByDefault) {
        boolean include = includeByDefault;
        if (include) {
            for (Pattern pattern : excludePattern) {
                Matcher excludeMatcher = pattern.matcher(file.getAbsolutePath());
                if (!excludeMatcher.find()) continue;
                include = false;
                break;
            }
        }
        if (!include) {
            for (Pattern pattern : includePattern) {
                Matcher includeMatcher = pattern.matcher(file.getAbsolutePath());
                if (!includeMatcher.find()) continue;
                include = true;
                break;
            }
        }
        return include;
    }

    static boolean excludePreference(File file, Set<Pattern> excludePattern, Set<Pattern> includePattern, boolean includeByDefault) {
        boolean include = includeByDefault;
        if (!include) {
            for (Pattern pattern : includePattern) {
                Matcher includeMatcher = pattern.matcher(file.getAbsolutePath());
                if (!includeMatcher.find()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            for (Pattern pattern : excludePattern) {
                Matcher excludeMatcher = pattern.matcher(file.getAbsolutePath());
                if (!excludeMatcher.find()) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    public static enum PatternStrategy {
        IncludePreference,
        ExcludePreference;

    }
}

