/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NonCancelableResultFuture<T>
implements Future<T> {
    private volatile boolean _done;
    private T _result;
    private ExecutionException _failure;
    private final Queue<CompletionListener<T>> _listeners = new ConcurrentLinkedQueue<CompletionListener<T>>();
    private final AtomicBoolean _notifiedListeners = new AtomicBoolean();
    static final long serialVersionUID = -296387658814354272L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String toString() {
        if (!this._done) {
            return super.toString() + "[incomplete]";
        }
        ExecutionException failure = this._failure;
        if (failure != null) {
            return super.toString() + "[fail exception=" + failure + ']';
        }
        T result = this._result;
        String resultString = result == null ? null : result.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(result));
        return super.toString() + "[success result=" + resultString + ']';
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException timeoutException) {
            void e;
            FFDCFilter.processException((Throwable)timeoutException, (String)"com.ibm.ws.threading.internal.NonCancelableResultFuture", (String)"59", (Object)this, (Object[])new Object[0]);
            throw (InterruptedException)new InterruptedException().initCause((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this._done) {
            NonCancelableResultFuture nonCancelableResultFuture = this;
            synchronized (nonCancelableResultFuture) {
                long startTime = System.currentTimeMillis();
                long waitTime = unit.toMillis(timeout);
                long elapsedWaitTime = 0L;
                do {
                    this.wait(waitTime - elapsedWaitTime);
                } while (!this.isDone() && (elapsedWaitTime = System.currentTimeMillis() - startTime) < waitTime);
            }
            if (!this.isDone()) {
                throw new TimeoutException();
            }
        }
        if (this._failure != null) {
            throw this._failure;
        }
        return this._result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    public synchronized void complete(T result) {
        if (!this._done) {
            this._result = result;
            this._done = true;
            this.notifyGetter();
        }
    }

    public synchronized void fail(Throwable t) {
        if (!this._done) {
            this._failure = new ExecutionException(t);
            this._done = true;
            this.notifyGetter();
        }
    }

    private synchronized void notifyGetter() {
        this.notifyAll();
    }

    public void callListeners() {
        if (this.isDone()) {
            this._notifiedListeners.compareAndSet(false, true);
            CompletionListener<T> l = this._listeners.poll();
            while (l != null) {
                if (this._failure != null) {
                    try {
                        l.failedCompletion(this, this._failure.getCause());
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.threading.internal.NonCancelableResultFuture", (String)"131", (Object)this, (Object[])new Object[0]);
                    }
                } else {
                    l.successfulCompletion(this, this._result);
                }
                l = this._listeners.poll();
            }
        }
    }

    public void queueListener(CompletionListener<T> l) {
        this._listeners.offer(l);
        if (this._notifiedListeners.get()) {
            this.callListeners();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.internal.NonCancelableResultFuture", NonCancelableResultFuture.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }
}

