/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.logger;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;

class LogManager
extends ServiceTracker<Object, Object>
implements BundleListener {
    private static final String LOGGER_FACTORY_CLASS_NAME = "org.osgi.service.log.LoggerFactory";
    final BundleContext scrContext;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final Lock lock = new Lock();

    LogManager(BundleContext context) {
        super(context, LOGGER_FACTORY_CLASS_NAME, null);
        this.scrContext = context;
        this.scrContext.addBundleListener((BundleListener)this);
    }

    public Object addingService(ServiceReference<Object> reference) {
        Object service = super.addingService(reference);
        Integer ranking = (Integer)reference.getProperty("service.ranking");
        if (ranking == null) {
            ranking = 0;
        }
        this.lock.setFactory(ranking, service);
        return service;
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        super.removedService(reference, service);
        this.lock.removedFactory(service);
    }

    <T> T getLogger(Bundle bundle, String name, Class<T> type) {
        return type.cast(this.lock.getLogDomain(bundle).getLogger(name));
    }

    public void bundleChanged(BundleEvent event) {
        LogDomain domain;
        if (event.getType() == 4 && !this.closed.get() && (domain = this.lock.remove(event.getBundle())) != null) {
            domain.close();
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.lock.close();
            super.close();
            this.context.removeBundleListener((BundleListener)this);
        }
    }

    LoggerFacade createLoggerFacade(LogDomain logDomain, String name) {
        assert (!this.closed.get());
        return new LoggerFacade(logDomain, name);
    }

    class LoggerFacade {
        private final String name;
        private final LogDomain domain;
        volatile Object logger;
        volatile String prefix;

        LoggerFacade(LogDomain logDomain, String name) {
            this.domain = logDomain;
            this.name = name;
        }

        void reset() {
            this.logger = null;
        }

        Object getLogger() {
            Object l = this.logger;
            if (l == null) {
                l = LogManager.this.lock.getLogger(this, this.domain.bundle, this.name);
            }
            return l;
        }

        Bundle getBundle() {
            return this.domain.bundle;
        }

        String getName() {
            return this.name;
        }
    }

    class LogDomain
    implements Closeable {
        private final Bundle bundle;
        private final Set<LoggerFacade> facades = new HashSet<LoggerFacade>();

        LogDomain(Bundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Set<LoggerFacade> set = this.facades;
            synchronized (set) {
                for (LoggerFacade facade : this.facades) {
                    facade.reset();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoggerFacade getLogger(String name) {
            LoggerFacade facade = LogManager.this.createLoggerFacade(this, name);
            Set<LoggerFacade> set = this.facades;
            synchronized (set) {
                this.facades.add(facade);
            }
            return facade;
        }

        @Override
        public void close() {
            this.reset();
        }
    }

    class Lock {
        final Map<Bundle, LogDomain> domains = new HashMap<Bundle, LogDomain>();
        int trackingCount;
        Object factory;
        int ranking = 0;

        Lock() {
        }

        synchronized LogDomain getLogDomain(Bundle bundle) {
            LogDomain domain = this.domains.get(bundle);
            if (domain == null) {
                domain = new LogDomain(bundle);
                this.domains.put(bundle, domain);
            }
            return domain;
        }

        synchronized void removedFactory(Object service) {
            if (this.factory == service) {
                this.factory = null;
                this.reset();
            }
        }

        synchronized void setFactory(int ranking, Object service) {
            if (this.factory == null) {
                this.factory = service;
                this.ranking = ranking;
            } else if (this.ranking < ranking) {
                this.factory = service;
                this.ranking = ranking;
                this.reset();
            }
        }

        synchronized void reset() {
            for (LogDomain domain : this.domains.values()) {
                domain.reset();
            }
        }

        synchronized Object getLogger(LoggerFacade facade, Bundle bundle, String name) {
            if (this.factory == null) {
                facade.logger = null;
                return null;
            }
            try {
                facade.logger = ((LoggerFactory)this.factory).getLogger(bundle, name, Logger.class);
                return facade.logger;
            }
            catch (IllegalArgumentException e) {
                return ((LoggerFactory)this.factory).getLogger(LogManager.this.context.getBundle(), name, Logger.class);
            }
        }

        synchronized LogDomain remove(Bundle bundle) {
            return this.domains.remove(bundle);
        }

        synchronized void close() {
            this.reset();
            this.domains.clear();
        }
    }
}

